/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.fileupload;

import java.util.Objects;
import kd.ebg.egf.common.model.properties.ObjectProperties;
import kd.ebg.egf.common.repository.properties.ObjectPropertiesRepository;
import kd.ebg.egf.common.utils.AESUtil;

public class OpenApiUtil {
    public static String appTokenUrlCangqiong = "/api/getAppToken.do";
    public static String accessTokenUrl = "/api/login.do";
    public static String attachUrl = "/attachment/upload.do";

    public static boolean isUseOpenApi() {
        ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();
        ObjectProperties properties = objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("isUseOpenApi", "receipt", "common_business");
        if (properties == null) {
            return false;
        }
        return !Boolean.parseBoolean(properties.getAttrValue());
    }

    public static String getAppTokenUrlFromCosmic() {
        return OpenApiUtil.getCosmicApiUrl() + appTokenUrlCangqiong;
    }

    public static String getAccessTokenUrlCangqiong() {
        return OpenApiUtil.getCosmicApiUrl() + accessTokenUrl;
    }

    public static String getAttachUrlCangqiong() {
        return OpenApiUtil.getCosmicApiUrl() + attachUrl;
    }

    private static String getCosmicApiUrl() {
        ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();
        ObjectProperties properties = objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("cosmic_api_url", "receipt", "common_business");
        return OpenApiUtil.handleUrl(properties.getAttrValue());
    }

    public static String getAppIdCangqiong() {
        ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();
        ObjectProperties properties = objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("cosmic_app_id", "receipt", "common_business");
        return properties.getAttrValue();
    }

    public static String getAppSecuretCangqiong() {
        ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();
        ObjectProperties properties = objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("cosmic_app_securet", "receipt", "common_business");
        return AESUtil.unencryptedDesEncrypt((String)properties.getAttrValue(), (String)"");
    }

    public static String getCosmicAccountId() {
        ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();
        ObjectProperties properties = objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("cosmic_account_id", "receipt", "common_business");
        return properties.getAttrValue();
    }

    public static String getUserCangqiong() {
        ObjectPropertiesRepository objectPropertiesRepository = ObjectPropertiesRepository.getInstance();
        ObjectProperties properties = objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("cosmic_user_name", "receipt", "common_business");
        return properties.getAttrValue();
    }

    public static String handleUrl(String url) {
        if (!Objects.nonNull(url)) {
            return "";
        }
        String[] array = url.split("//");
        if (array.length < 1) {
            return url;
        }
        String second = array[array.length - 1];
        return !second.contains("/") ? url + "/ierp" : url;
    }
}

