/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.notePayable;

import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.business.cache.CachePayableStorage;
import kd.ebg.note.business.notePayable.atomic.INotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.bank.EBBankNotePayableResponse;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.frame.BankBundleManager;
import kd.ebg.note.common.framework.services.NotePayableInfoService;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.MDC;

public class BankNotePayableTask
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankNotePayableTask.class);
    private BankNotePayableRequest request;
    private EBContext context;

    public BankNotePayableTask(BankNotePayableRequest request, EBContext context) {
        this.request = request;
        this.context = context;
    }

    public Object doBiz() {
        EBBankNotePayableResponse response = this.submitNotePayable(this.request, this.context);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EBBankNotePayableResponse submitNotePayable(BankNotePayableRequest request, EBContext context) {
        List<Object> result;
        FEPAccess access;
        String key;
        NotePayableInfoService service;
        block21: {
            INotePayable payable;
            List notePayableInfos;
            block20: {
                String bizSeqID = Sequence.gen18Sequence();
                if (StringUtils.isEmpty((String)request.getHeader().getBizSeqID())) {
                    request.getHeader().setBizSeqID(bizSeqID);
                }
                context.setBizName("notePayable");
                MDCUtil.clearBussinessMDC();
                MDCUtil.initMDC((EBContext)context);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                this.logger.infoIndex("\u5f00\u59cb\u8fdb\u884c\u5e94\u4ed8\u7968\u636e\u4e1a\u52a1\u5904\u7406,{}", (Object)bizSeqID);
                EBContext.setContext((EBContext)context);
                notePayableInfos = request.getNotePayableInfoList();
                if (notePayableInfos.isEmpty()) {
                    return null;
                }
                service = NotePayableInfoService.getInstance();
                String bankVersionID = context.getBankVersionID();
                String implClassName = notePayableInfos.get(0).getImplClassName();
                String batchSeqId = notePayableInfos.get(0).getBatchSeqId();
                String bankBatchSeqID = notePayableInfos.get(0).getBankBatchSeqId();
                key = "payable_" + batchSeqId + "_" + bankBatchSeqID;
                access = null;
                result = new ArrayList(16);
                payable = (INotePayable)BankBundleManager.getInstance().getImplByClassName(bankVersionID, INotePayable.class, implClassName);
                this.logger.info("\u94f6\u884c\u63d2\u4ef6\u7684\u5b9e\u73b0\u7c7b\u4e3a\uff1a{}", payable.getClass());
                EBContext.initParameter();
                MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankLoginID());
                notePayableInfos = service.compareAndStateState(notePayableInfos, PaymentState.PACKAGED, PaymentState.SUBMITTING);
                if (!Objects.isNull(notePayableInfos) && !notePayableInfos.isEmpty()) break block20;
                this.logger.warn("\u72b6\u6001\u4fee\u6539\u4e3a\u63d0\u4ea4\u4e2d\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u5176\u4ed6\u8282\u70b9\u5904\u7406\u8fc7\u7684.bankBatchSeqId:{}", new Object[]{request.getBankBatchSeqID()});
                EBBankNotePayableResponse eBBankNotePayableResponse = null;
                FEPAccessUtil.release((FEPAccess)access);
                CachePayableStorage.release(key);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                return eBBankNotePayableResponse;
            }
            try {
                request.setNotePayableInfoList(notePayableInfos);
                EBBankNotePayableResponse response = payable.pay(request);
                if (Objects.nonNull(EBContext.getContext().getThrowableAfterSend())) {
                    Throwable t = EBContext.getContext().getThrowableAfterSend();
                    this.logger.error("\u5e94\u4ed8\u7968\u636e\u63d0\u4ea4\u94f6\u884c\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", t);
                    if (t instanceof EBServiceException) {
                        if ("ProxyCreateConnectionException".equals(((EBServiceException)t).getErrorCode())) {
                            EBGNotePayableUtils.setPaymentState(request.getNotePayableInfoList(), PaymentState.FAIL, ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u4ea4\u6613\u3002", (String)"BankNotePayableTask_4", (String)"ebg-note-business", (Object[])new Object[0]), "", "");
                        } else if ("ProxyConnectionException".equals(((EBServiceException)t).getErrorCode())) {
                            EBGNotePayableUtils.setPaymentState(request.getNotePayableInfoList(), PaymentState.UNKNOWN, ResManager.loadKDString((String)"\u8bf7\u6c42\u53d1\u9001\u65f6\u5f02\u5e38\uff0c\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u540c\u6b65\u7ed3\u679c\u3002", (String)"BankNotePayableTask_5", (String)"ebg-note-business", (Object[])new Object[0]), "", "");
                        } else if (t.getCause() != null) {
                            EBGNotePayableUtils.setPaymentState(request.getNotePayableInfoList(), PaymentState.UNKNOWN, ResManager.loadKDString((String)"\u8bf7\u6c42\u53d1\u9001\u65f6\u5f02\u5e38\uff0c\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u540c\u6b65\u7ed3\u679c\u3002", (String)"BankNotePayableTask_5", (String)"ebg-note-business", (Object[])new Object[0]), "", t.getCause().getMessage());
                        } else {
                            EBGNotePayableUtils.setPaymentState(request.getNotePayableInfoList(), PaymentState.UNKNOWN, ResManager.loadKDString((String)"\u8bf7\u6c42\u53d1\u9001\u65f6\u5f02\u5e38\uff0c\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u540c\u6b65\u7ed3\u679c\u3002", (String)"BankNotePayableTask_5", (String)"ebg-note-business", (Object[])new Object[0]), "", "");
                        }
                        result = request.getNotePayableInfoList();
                    } else {
                        EBGNotePayableUtils.setPaymentState(request.getNotePayableInfoList(), PaymentState.UNKNOWN, ResManager.loadKDString((String)"\u8bf7\u6c42\u53d1\u9001\u65f6\u5f02\u5e38\uff0c\u7ed3\u679c\u672a\u77e5\uff0c\u8bf7\u540c\u6b65\u7ed3\u679c\u3002", (String)"BankNotePayableTask_5", (String)"ebg-note-business", (Object[])new Object[0]), "", "");
                        result = request.getNotePayableInfoList();
                    }
                    break block21;
                }
                Preconditions.checkState((boolean)Objects.nonNull((Object)response), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (String)"BankNotePayableTask_6", (String)"ebg-note-business", (Object[])new Object[0]));
                if (response == null) break block21;
                Preconditions.checkState((boolean)Objects.nonNull(response.getNotePayableInfos()), (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String)"BankNotePayableTask_7", (String)"ebg-note-business", (Object[])new Object[0]));
                result = response.getNotePayableInfos();
            }
            catch (Throwable e) {
                block22: {
                    try {
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                        this.logger.error("\u63d0\u4ea4\u94f6\u884c\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\uff0c", e);
                        String errorMsg = ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u884c\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", (String)"BankNotePayableTask_8", (String)"ebg-note-business", (Object[])new Object[0]);
                        if (!StringUtils.isEmpty((String)e.getMessage())) {
                            errorMsg = errorMsg + "," + e.getMessage();
                        }
                        if (!StringUtils.isEmpty((String)errorMsg) && errorMsg.length() > 250) {
                            errorMsg = errorMsg.substring(0, 250);
                        }
                        result = request.getNotePayableInfoList();
                        if (e instanceof EBServiceException) {
                            EBGNotePayableUtils.setPaymentState(result, PaymentState.FAIL, errorMsg, "", "");
                            break block22;
                        }
                        EBGNotePayableUtils.setPaymentState(result, PaymentState.UNKNOWN, errorMsg, "", "");
                    }
                    catch (Throwable throwable) {
                        FEPAccessUtil.release(access);
                        CachePayableStorage.release(key);
                        MDC.put((String)"bussiness_type", (String)"bussiness_process");
                        throw throwable;
                    }
                }
                FEPAccessUtil.release((FEPAccess)access);
                CachePayableStorage.release(key);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
            }
        }
        FEPAccessUtil.release((FEPAccess)access);
        CachePayableStorage.release(key);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        if (CollectionUtils.isNotEmpty(result)) {
            result.forEach(r -> {
                if (r != null) {
                    if (r.getStatus().intValue() == PaymentState.SUCCESS.getId()) {
                        r.setPayFinishTime(LocalDateTime.now());
                    } else if (r.getStatus().intValue() == PaymentState.SUBMITTING.getId()) {
                        EBGNotePayableUtils.setPaymentState(r, PaymentState.SUBMITED, "", "", "");
                    }
                    r.setSubmitSuccessTime(LocalDateTime.now());
                    r.setUpdateTime(LocalDateTime.now());
                }
            });
        }
        service.save(result);
        EBBankNotePayableResponse response = new EBBankNotePayableResponse();
        response.setHeader(request.getHeader());
        response.setNotePayableInfos(result);
        response.setBankBatchSeqID(request.getBankBatchSeqID());
        return response;
    }
}

