/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.notePayable;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.note.business.notePayable.util.NotePayableConvert;
import kd.ebg.note.business.notePayable.util.QueryNotePayableUtil;
import kd.ebg.note.business.util.AccessUtils;
import kd.ebg.note.business.util.CacheQueryPayStorage;
import kd.ebg.note.common.entity.biz.querynotepayable.QueryNotePayableRequest;
import kd.ebg.note.common.entity.biz.querynotepayable.QueryNotePayableResponse;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.services.NotePayableInfoService;
import kd.ebg.note.common.model.NotePayableInfo;
import org.slf4j.MDC;

public class QueryNotePayableMethod
implements EBServiceMethod<QueryNotePayableRequest, QueryNotePayableResponse> {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryNotePayableMethod.class);

    public QueryNotePayableResponse executeClientRequest(QueryNotePayableRequest request, EBContext context) throws MalformedURLException {
        AccessUtils.checkQueryAllowed(context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC();
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        String batchSeqID = request.getBody().getBatchSeqId();
        String reserved1 = request.getBody().getReserved1();
        this.logger.info("\u5e94\u4ed8\u7968\u636e\u540c\u6b65\u6279\u6b21\u53f7\uff1a" + batchSeqID);
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)ResManager.loadKDString((String)"\u6279\u6b21\u6d41\u6c34\u53f7 \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryNotePayableMethod_0", (String)"ebg-note-business", (Object[])new Object[0]));
        List infos = NotePayableInfoService.getInstance().selectByBatchSeqID(batchSeqID);
        if (infos.isEmpty()) {
            throw EBExceiptionUtil.preCheckException((String)"unknown_batch", (String)String.format(ResManager.loadKDString((String)"\u67e5\u65e0\u6b64\u6279\u6b21\u53f7: %s\u3002", (String)"QueryNotePayableMethod_3", (String)"ebg-note-business", (Object[])new Object[0]), batchSeqID));
        }
        String customId = request.getHeader().getCustomId();
        String key = customId + batchSeqID;
        boolean isHasSubmitting = infos.stream().anyMatch(info -> info.getStatus().intValue() == PaymentState.SUBMITTING.getId());
        if (!CacheQueryPayStorage.checkRepeat(key)) {
            if ("unittest".equals(reserved1)) {
                Set<List<NotePayableInfo>> paymentInfoSet = QueryNotePayableUtil.setOfPay(infos);
                QueryNotePayableUtil.async(paymentInfoSet, (EBRequest)request, context.getAcnt(), reserved1);
            } else if (isHasSubmitting) {
                this.logger.info("\u4ed8\u6b3e\u72b6\u6001\u63d0\u4ea4\u4e2d\uff0c\u7279\u6b8a\u5904\u7406");
                LocalDateTime submitSuccessTime = ((NotePayableInfo)infos.get(0)).getUpdateTime();
                Duration duration = Duration.between(submitSuccessTime, LocalDateTime.now());
                long minutes = duration.toMinutes();
                if (minutes > 20L) {
                    for (NotePayableInfo info2 : infos) {
                        if (info2.getStatus().intValue() != PaymentState.SUBMITTING.getId()) continue;
                        info2.setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
                        info2.setStatusName(PaymentState.UNKNOWN.getEnName());
                        info2.setStatusMsg(String.format(ResManager.loadKDString((String)"%s\uff0c\u63d0\u4ea4\u4e2d\u72b6\u6001\u6301\u7eed\u5df2\u8d85\u8fc720\u5206\u949f\u3002", (String)"QueryNotePayableMethod_4", (String)"ebg-note-business", (Object[])new Object[0]), PaymentState.UNKNOWN.getCnName()));
                    }
                    this.logger.info("\u4ed8\u6b3e\u72b6\u6001\u63d0\u4ea4\u4e2d\u8d85\u8fc720\u5206\u949f\uff0c\u7279\u6b8a\u5904\u7406");
                    Set<List<NotePayableInfo>> paymentInfoSet = QueryNotePayableUtil.setOfPay(infos);
                    QueryNotePayableUtil.async(paymentInfoSet, (EBRequest)request, context.getAcnt(), reserved1);
                }
            } else if (((NotePayableInfo)infos.get(0)).getStatus().intValue() == PaymentState.PACKAGED.getId()) {
                this.logger.info("\u8be5\u7b14\u5904\u4e8e\u6253\u5305\u72b6\u6001\uff0c\u65e0\u6cd5\u540c\u6b65");
            } else if (!this.isNeedQuery(infos)) {
                if ("forceQuery".equals(reserved1)) {
                    Set<List<NotePayableInfo>> paymentInfoSet = QueryNotePayableUtil.setOfPay(infos);
                    QueryNotePayableUtil.async(paymentInfoSet, (EBRequest)request, context.getAcnt(), reserved1);
                }
            } else {
                this.logger.info("\u5524\u9192\u540c\u6b65\u7ebf\u7a0b\u8fdb\u884c\u540c\u6b65");
                Set<List<NotePayableInfo>> paymentInfoSet = QueryNotePayableUtil.setOfPay(infos);
                QueryNotePayableUtil.async(paymentInfoSet, (EBRequest)request, context.getAcnt(), reserved1);
            }
        } else {
            if ("unittest".equals(reserved1)) {
                Set<List<NotePayableInfo>> paymentInfoSet = QueryNotePayableUtil.setOfPay(infos);
                QueryNotePayableUtil.async(paymentInfoSet, (EBRequest)request, context.getAcnt(), reserved1);
            }
            this.logger.info("\u5f53\u524d\u6279\u6b21\u5df2\u7ecf\u5b58\u5728\u540c\u6b65\u67e5\u8be2\u7684\u8bf7\u6c42\uff0c\u672c\u6b21\u8bf7\u6c42\u4e0d\u751f\u6548");
        }
        return NotePayableConvert.convertToResponse((List<NotePayableInfo>)infos, request);
    }

    boolean isNeedQuery(List<NotePayableInfo> infos) {
        for (NotePayableInfo info : infos) {
            if (info.getStatus().intValue() == PaymentState.SUCCESS.getId() || info.getStatus().intValue() == PaymentState.FAIL.getId()) continue;
            return true;
        }
        return false;
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "queryNotePayable";
    }
}

