/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.notePayable.util;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;
import kd.ebg.note.business.cache.CachePayableStorage;
import kd.ebg.note.business.notePayable.BankNotePayableTask;
import kd.ebg.note.business.notePayable.atomic.INotePayable;
import kd.ebg.note.business.notePayable.atomic.INotePayablePretreat;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.business.util.EBThreadPools;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.frame.BankBundleManager;
import kd.ebg.note.common.framework.services.NotePayableInfoService;
import kd.ebg.note.common.framework.utils.CurrencyUtils;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.utils.SpringContextUtil;
import net.sf.json.JSONObject;

public class NotePayableUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(NotePayableUtil.class);

    public static void preTreatment(List<NotePayableInfo> notePayableInfos) {
        for (NotePayableInfo info : notePayableInfos) {
            NotePayableUtil.preTreatmentEach(info);
            logger.info("\u5f53\u524d\u8bb0\u5f55\u7684\u4ed8\u6b3e\u8def\u7531\u4fe1\u606f\u4e3a:" + info.getPackageKey());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void preTreatmentEach(NotePayableInfo info) {
        StringBuilder packageKey = new StringBuilder();
        packageKey.append("acceptorAccNo=").append(info.getAcceptorAccNo()).append(";").append("detail_seq_id=").append(info.getDetailSeqId()).append(";").append("bizType=").append(info.getBizType()).append(";").append("subBizType=").append(info.getSubBizType()).append(";");
        info.setPackageKey(packageKey.toString());
        String bankVersionID = info.getBankVersionID();
        INotePayablePretreat pretreat = (INotePayablePretreat)BankBundleManager.getInstance().getImpl(bankVersionID, INotePayablePretreat.class, (Object)info);
        if (pretreat == null) {
            INotePayable pay = (INotePayable)BankBundleManager.getInstance().getImpl(bankVersionID, INotePayable.class, (Object)info);
            IQueryNotePayable queryPayImpl = null;
            Class<? extends IQueryNotePayable> queryPayImplClass = pay.defaultQueryClass();
            if (Objects.nonNull(queryPayImplClass)) {
                queryPayImpl = (IQueryNotePayable)BankBundleManager.getInstance().getImplByClassName(info.getBankVersionID(), IQueryNotePayable.class, queryPayImplClass.getName());
            }
            if (Objects.isNull(queryPayImpl)) {
                queryPayImpl = (IQueryNotePayable)BankBundleManager.getInstance().getImpl(bankVersionID, IQueryNotePayable.class, (Object)info);
            }
            if (pay.getClass() == null) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u63d2\u4ef6\u5b9e\u73b0\u9519\u8bef", (String)"NotePayableUtil_0", (String)"ebg-note-business", (Object[])new Object[0]));
            }
            info.setImplClassName(pay.getClass().getName());
            if (queryPayImpl == null) throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u63d2\u4ef6\u5b9e\u73b0\u9519\u8bef", (String)"NotePayableUtil_0", (String)"ebg-note-business", (Object[])new Object[0]));
            if (queryPayImpl.getClass() == null) throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u63d2\u4ef6\u5b9e\u73b0\u9519\u8bef", (String)"NotePayableUtil_0", (String)"ebg-note-business", (Object[])new Object[0]));
            info.setQueryImplClassName(queryPayImpl.getClass().getName());
        } else {
            pretreat.appendData(info);
        }
        info.setStatus(Integer.valueOf(PaymentState.INITIAL.getId()));
        info.setStatusName(PaymentState.INITIAL.getEnName());
        info.setStatusMsg(PaymentState.INITIAL.getCnName());
    }

    public static void insertPay(List<NotePayableInfo> notePayableInfos) {
        LocalDateTime insertTime = LocalDateTime.now();
        notePayableInfos.forEach(info -> {
            info.setInsertTime(insertTime);
            info.setEbgID(((SingleNodeIDGetter)SpringContextUtil.getBean(SingleNodeIDGetter.class)).nodeID());
        });
        NotePayableInfoService.getInstance().save(notePayableInfos);
    }

    public static Set<List<NotePayableInfo>> reloadData(Set<List<NotePayableInfo>> set) {
        for (List<NotePayableInfo> infos : set) {
            BigDecimal amountCount = new BigDecimal(0);
            for (NotePayableInfo notePayableInfo : infos) {
                amountCount = amountCount.add(notePayableInfo.getAmount());
            }
            for (int i = 0; i < infos.size(); ++i) {
                NotePayableInfo info = infos.get(i);
                info.setBankSerialNo(i + 1 + "");
                info.setTotalSize(Integer.valueOf(infos.size()));
                info.setBatchTotalAmount(amountCount);
            }
        }
        return set;
    }

    public static void async(Set<List<NotePayableInfo>> set, EBRequest request, BankAcnt acnt) {
        String extDate = request.getHeader().getExtData();
        String loggerBankNo = "";
        try {
            if (extDate != null) {
                JSONObject object = JSONObject.fromObject((Object)extDate);
                loggerBankNo = (String)object.get("loggerBankNo");
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u65e5\u5fd7\u8ddf\u8e2a\u53f7\u5f02\u5e38\uff1a", (Object)e);
        }
        for (List<NotePayableInfo> infos : set) {
            BankNotePayableRequest notePayableRequest = NotePayableUtil.prepareBankPayRequest(infos, acnt);
            NotePayableInfo notePayableInfo = infos.get(0);
            for (int i = 0; i < infos.size(); ++i) {
                NotePayableInfo info = infos.get(i);
                info.setBankSerialNo(i + 1 + "");
            }
            String bankVersion = notePayableInfo.getBankVersionID();
            String bizType = "notePayable";
            String customerId = notePayableInfo.getCustomID();
            String batchSeqId = notePayableInfo.getBatchSeqId();
            String requestSeqId = String.valueOf(request.getHeader().getRequestSeqID());
            String logRequestSeqId = String.valueOf(request.getHeader().getLogRequestSeqID());
            String logBizSeqId = String.valueOf(request.getHeader().getLogBizSeqID());
            if (StringUtils.isEmpty((String)loggerBankNo)) {
                loggerBankNo = notePayableInfo.getBankBatchSeqId();
            }
            EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customerId).requestSeqID(requestSeqId).bizName(bizType).subBizName(bizType).bankVersionID(bankVersion).bizSeqID(batchSeqId).bankLoginID(EBContext.getContext().getBankLoginID()).logRequestSeqID(logRequestSeqId).logBizSeqID(logBizSeqId).loggerBatchNo(batchSeqId).loggerDetailNo(notePayableInfo.getBankBatchSeqId()).loggerBankNo(loggerBankNo).loggerSubType(EBContext.getContext().getLogger_sub_type()).build();
            String bankLoginId = notePayableRequest.getHeader().getAcnt().getBankLoginId();
            String bankBatchSeqID = infos.get(0).getBankBatchSeqId();
            BigDecimal totalAmount = infos.get(0).getTotalAmount();
            notePayableRequest.setBankBatchSeqID(bankBatchSeqID);
            notePayableRequest.setNotePayableInfoList(infos);
            notePayableRequest.setTotalAmount(totalAmount);
            notePayableRequest.setTotalCount(infos.size());
            context.setBankAcnt(acnt);
            String bankLoginID = EBContext.getContext().getBankLoginID();
            String key = "payable_" + batchSeqId + "_" + bankBatchSeqID;
            if (CachePayableStorage.checkSubmitLock(key)) {
                logger.info(String.format("\u5e94\u4ed8\u7968\u636e\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u6279\u6b21\u53f7\u4e3a%s\uff0c\u4efb\u52a1\u4e0d\u63d0\u4ea4\u7ebf\u7a0b\u6c60", key));
                continue;
            }
            EBThreadPools.getNotePayable(customerId, bankLoginId).submit((Callable)((Object)new BankNotePayableTask(notePayableRequest, context)));
        }
    }

    private static BankNotePayableRequest prepareBankPayRequest(List<NotePayableInfo> notePayableInfos, BankAcnt acnt) {
        BankNotePayableRequest payableRequest = new BankNotePayableRequest();
        if (notePayableInfos.size() > 0) {
            NotePayableInfo info = notePayableInfos.get(0);
            payableRequest.setNotePayableInfoList(notePayableInfos);
            payableRequest.setTotalCount(notePayableInfos.size());
            payableRequest.setTotalAmount(NotePayableUtil.getTotalAmount(notePayableInfos));
            payableRequest.setBankBatchSeqID(info.getBankBatchSeqId());
            payableRequest.setHeader(NotePayableUtil.getHeader(info, acnt));
        }
        return payableRequest;
    }

    private static BankHeader getHeader(NotePayableInfo info, BankAcnt bankAcnt) {
        BankHeader header = new BankHeader();
        BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(bankAcnt.getAccNo(), info.getCustomID());
        String bankVersionID = info.getBankVersionID();
        String bankLoginID = info.getBankLoginID();
        String bankCurrency = CurrencyUtils.convert2Bank((String)acnt.getCurrency(), (String)info.getBankVersionID(), (String)info.getCustomID());
        header.setCustomerID(info.getCustomID());
        header.setBankCurrency(bankCurrency);
        header.setBankLoginID(bankLoginID);
        header.setBankVersionID(bankVersionID);
        header.setBizType(info.getBizType());
        header.setSubBizType(info.getSubBizType());
        header.setBizSeqID(info.getBankBatchSeqId());
        header.setLogBizSeqID(info.getBatchSeqId());
        header.setLogRequestSeqID(String.valueOf(System.currentTimeMillis()));
        header.setRequestSeqID(Sequence.genSequence());
        header.setAcnt(acnt);
        header.setClientName("ebc_bankNotePayableTask");
        header.setClientVersion("1.0");
        return header;
    }

    public static BigDecimal getTotalAmount(List<NotePayableInfo> infos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        if (!Objects.isNull(infos)) {
            for (NotePayableInfo info : infos) {
                bigDecimal = bigDecimal.add(info.getAmount());
            }
        }
        return bigDecimal;
    }

    public static void newTransactionDeal(List<NotePayableInfo> infos) {
        for (NotePayableInfo info : infos) {
            if (info.getSubBizType().equals("remit_register")) {
                if (info.getNoteStatus().equals("CS01") && info.getCirStatus().equals("TF0101")) {
                    EBGNotePayableUtils.setPaymentState(info, PaymentState.SUCCESS, "", "");
                    continue;
                }
                if (info.getNoteStatus().equals("CS02") && info.getCirStatus().equals("TF0101")) {
                    EBGNotePayableUtils.setPaymentState(info, PaymentState.SUCCESS, "", "");
                    continue;
                }
                if (info.getNoteStatus().equals("CS03") && (info.getCirStatus().equals("TF0301") || info.getCirStatus().equals("TF0303"))) {
                    EBGNotePayableUtils.setPaymentState(info, PaymentState.SUCCESS, "", "");
                    continue;
                }
                EBGNotePayableUtils.setPaymentState(info, PaymentState.SUBMITED, "", "");
                continue;
            }
            if (info.getSubBizType().equals("remit_accept")) {
                if (info.getNoteStatus().equals("CS02") && info.getCirStatus().equals("TF0101")) {
                    EBGNotePayableUtils.setPaymentState(info, PaymentState.SUCCESS, "", "");
                    continue;
                }
                EBGNotePayableUtils.setPaymentState(info, PaymentState.SUBMITED, "", "");
                continue;
            }
            if (info.getSubBizType().equals("remit_receive")) {
                if (info.getNoteStatus().equals("CS03") && (info.getCirStatus().equals("TF0301") || info.getCirStatus().equals("TF0303"))) {
                    EBGNotePayableUtils.setPaymentState(info, PaymentState.SUCCESS, "", "");
                    continue;
                }
                EBGNotePayableUtils.setPaymentState(info, PaymentState.SUBMITED, "", "");
                continue;
            }
            if (info.getSubBizType().equals("remit_revocation")) {
                if (info.getNoteStatus().equals("CS05") && info.getCirStatus().equals("TF0501")) {
                    EBGNotePayableUtils.setPaymentState(info, PaymentState.SUCCESS, "", "");
                    continue;
                }
                EBGNotePayableUtils.setPaymentState(info, PaymentState.SUBMITED, "", "");
                continue;
            }
            if (!info.getSubBizType().equals("remit_cancle")) continue;
            if (info.getOperationCode().equals("02")) {
                if (info.getNoteStatus().equals("CS01") && info.getCirStatus().equals("TF0101")) {
                    EBGNotePayableUtils.setPaymentState(info, PaymentState.SUCCESS, "", "");
                    continue;
                }
                EBGNotePayableUtils.setPaymentState(info, PaymentState.SUBMITED, "", "");
                continue;
            }
            if (!info.getOperationCode().equals("03")) continue;
            if (info.getNoteStatus().equals("CS02") && info.getCirStatus().equals("TF0101")) {
                EBGNotePayableUtils.setPaymentState(info, PaymentState.SUCCESS, "", "");
                continue;
            }
            EBGNotePayableUtils.setPaymentState(info, PaymentState.SUBMITED, "", "");
        }
    }
}

