/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.notePayable.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.note.business.notePayable.BankQueryNotePayableTask;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.util.EBThreadPools;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.utils.CurrencyUtils;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import net.sf.json.JSONObject;

public class QueryNotePayableUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(QueryNotePayableUtil.class);

    public static void setPaymentState(List<NoteReceivableInfo> paymentInfos, PaymentState state, String errorMsg, String bankStatus, String bankMsg) {
        for (NoteReceivableInfo info : paymentInfos) {
            QueryNotePayableUtil.setPaymentState(info, state, errorMsg, bankStatus, bankMsg);
            QueryNotePayableUtil.setPaymentUpdateTimeAndStatus(info, LocalDateTime.now());
        }
    }

    public static void setPaymentState(NoteReceivableInfo paymentInfo, PaymentState state, String errorMsg, String bankStatus, String bankMsg) {
        paymentInfo.setStatus(Integer.valueOf(state.getId()));
        paymentInfo.setStatusName(state.getEnName());
        paymentInfo.setStatusMsg(state.getCnName());
        if (StrUtil.isNotBlank((CharSequence)errorMsg)) {
            if (errorMsg.length() > 250) {
                paymentInfo.setErrorMsg(errorMsg.substring(0, 250) + "...");
            } else {
                paymentInfo.setErrorMsg(errorMsg);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)bankStatus)) {
            paymentInfo.setBankStatus(bankStatus);
        }
        if (StrUtil.isNotBlank((CharSequence)bankMsg)) {
            paymentInfo.setBankMsg(bankMsg);
        }
    }

    public static void setPaymentUpdateTimeAndStatus(NoteReceivableInfo paymentInfos, LocalDateTime updateTime) {
        paymentInfos.setUpdateTime(updateTime);
    }

    public static void setPaymentUpdateTimeAndStatus(List<NoteReceivableInfo> paymentInfos, LocalDateTime updateTime) {
        for (NoteReceivableInfo info : paymentInfos) {
            info.setUpdateTime(updateTime);
            PaymentState state = PaymentState.getEnumById((int)info.getStatus());
            info.setStatusMsg(state.getCnName());
            info.setStatusName(state.getEnName());
        }
    }

    public static void setPaymentState(List<NoteReceivableInfo> paymentInfos, PaymentState state, String bankStatus, String bankMsg) {
        for (NoteReceivableInfo info : paymentInfos) {
            QueryNotePayableUtil.setPaymentState(info, state, bankStatus, bankMsg);
            QueryNotePayableUtil.setPaymentUpdateTimeAndStatus(info, LocalDateTime.now());
        }
    }

    public static void setPaymentState(NoteReceivableInfo paymentInfo, PaymentState state, String bankStatus, String bankMsg) {
        paymentInfo.setStatus(Integer.valueOf(state.getId()));
        paymentInfo.setStatusName(state.getEnName());
        paymentInfo.setStatusMsg(state.getCnName());
        if (StrUtil.isNotBlank((CharSequence)bankStatus)) {
            paymentInfo.setBankStatus(bankStatus);
        }
        if (StrUtil.isNotBlank((CharSequence)bankMsg)) {
            paymentInfo.setBankMsg(bankMsg);
        }
    }

    public static Set<List<NotePayableInfo>> setOfPay(List<NotePayableInfo> infos) {
        HashMap map = Maps.newHashMap();
        Map<String, Long> countMap = infos.stream().collect(Collectors.groupingBy(NotePayableInfo::getBankBatchSeqId, Collectors.counting()));
        List toQuery = infos.stream().filter(info -> info.getStatus().intValue() == PaymentState.SUBMITED.getId() || info.getStatus().intValue() == PaymentState.UNKNOWN.getId() || info.getStatus().intValue() == PaymentState.SUBMITTING.getId()).collect(Collectors.toList());
        for (NotePayableInfo info2 : toQuery) {
            String bankBatchSeqId = info2.getBankBatchSeqId();
            Long count = countMap.get(bankBatchSeqId);
            info2.setBankBatchCount(count.intValue());
            if (map.containsKey(bankBatchSeqId)) {
                ((List)map.get(bankBatchSeqId)).add(info2);
                continue;
            }
            map.put(bankBatchSeqId, Lists.newArrayList());
            ((List)map.get(bankBatchSeqId)).add(info2);
        }
        return Sets.newHashSet(map.values());
    }

    public static void async(Set<List<NotePayableInfo>> set, EBRequest request, BankAcnt acnt, String type) {
        String extDate = request.getHeader().getExtData();
        String loggerBankNo = "";
        try {
            if (extDate != null) {
                JSONObject object = JSONObject.fromObject((Object)extDate);
                loggerBankNo = (String)object.get("loggerBankNo");
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u65e5\u5fd7\u8ddf\u8e2a\u53f7\u5f02\u5e38\uff1a", (Object)e);
        }
        for (List<NotePayableInfo> infos : set) {
            BankNotePayableRequest notePayableRequest = QueryNotePayableUtil.getQueryNotePayableRequest(infos, acnt);
            NotePayableInfo notePayableInfo = infos.get(0);
            String bankVersion = notePayableInfo.getBankVersionID();
            String bizType = "queryNotePayable";
            String customerId = notePayableInfo.getCustomID();
            String batchSeqId = notePayableInfo.getBatchSeqId();
            String requestSeqId = String.valueOf(request.getHeader().getRequestSeqID());
            String logRequestSeqId = String.valueOf(request.getHeader().getLogRequestSeqID());
            String logBizSeqId = String.valueOf(request.getHeader().getLogBizSeqID());
            EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customerId).requestSeqID(requestSeqId).bizName(bizType).subBizName(bizType).bankVersionID(bankVersion).bizSeqID(batchSeqId).bankLoginID(EBContext.getContext().getBankLoginID()).logRequestSeqID(logRequestSeqId).logBizSeqID(logBizSeqId).loggerBatchNo(batchSeqId).loggerDetailNo(notePayableInfo.getBankBatchSeqId()).loggerBankNo(loggerBankNo).build();
            String bankLoginId = notePayableRequest.getHeader().getAcnt().getBankLoginId();
            String bankBatchSeqID = infos.get(0).getBankBatchSeqId();
            BigDecimal totalAmount = infos.get(0).getTotalAmount();
            notePayableRequest.setBankBatchSeqID(bankBatchSeqID);
            notePayableRequest.setReserved1(type);
            notePayableRequest.setNotePayableInfoList(infos);
            notePayableRequest.setTotalAmount(totalAmount);
            notePayableRequest.setTotalCount(infos.size());
            context.setBankAcnt(acnt);
            String bankLoginID = EBContext.getContext().getBankLoginID();
            EBThreadPools.getQueryNotePayable(customerId, bankLoginId).submit((Callable)((Object)new BankQueryNotePayableTask(notePayableRequest, context)));
        }
    }

    private static BankNotePayableRequest getQueryNotePayableRequest(List<NotePayableInfo> infos, BankAcnt bankAcnt) {
        BankNotePayableRequest request = new BankNotePayableRequest();
        String bankBatchSeqID = infos.get(0).getBankBatchSeqId();
        BigDecimal totalAmount = infos.get(0).getTotalAmount();
        request.setBankBatchSeqID(bankBatchSeqID);
        request.setNotePayableInfoList(infos);
        request.setTotalAmount(totalAmount);
        request.setTotalCount(infos.size());
        request.setHeader(QueryNotePayableUtil.getHeader(infos.get(0), bankAcnt));
        return request;
    }

    private static BankHeader getHeader(NotePayableInfo info, BankAcnt bankAcnt) {
        BankHeader header = new BankHeader();
        BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(bankAcnt.getAccNo(), info.getCustomID());
        String bankVersionID = info.getBankVersionID();
        String bankLoginID = info.getBankLoginID();
        String bankCurrency = CurrencyUtils.convert2Bank((String)acnt.getCurrency(), (String)info.getBankVersionID(), (String)info.getCustomID());
        header.setCustomerID(info.getCustomID());
        header.setBankCurrency(bankCurrency);
        header.setBankLoginID(bankLoginID);
        header.setBankVersionID(bankVersionID);
        header.setBizType(info.getBizType());
        header.setSubBizType(info.getSubBizType());
        header.setBizSeqID(info.getBankBatchSeqId());
        header.setLogBizSeqID(info.getBatchSeqId());
        header.setLogRequestSeqID(String.valueOf(System.currentTimeMillis()));
        header.setRequestSeqID(Sequence.genSequence());
        header.setAcnt(acnt);
        header.setClientName("ebc_bankQueryNotePayableTask");
        header.setClientVersion("1.0");
        return header;
    }
}

