/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.schedule;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.business.cache.CachePayableStorage;
import kd.ebg.note.business.notePayable.BankNotePayableTask;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.BankNoteReceivableTask;
import kd.ebg.note.business.util.EBThreadPools;
import kd.ebg.note.common.entity.biz.file.FileList;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.services.NotePayableInfoService;
import kd.ebg.note.common.framework.services.NoteReceivableInfoService;
import kd.ebg.note.common.framework.utils.CurrencyUtils;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.slf4j.MDC;

public class NoteScheduleJob
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(NoteScheduleJob.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LocalDateTime limitTime30 = LocalDateTime.now().minus(30L, ChronoUnit.MINUTES);
        LocalDateTime limitTime8 = LocalDateTime.now().minus(8L, ChronoUnit.HOURS);
        this.handlePayableSubmittingAgain(limitTime30, limitTime8);
        this.handleReceivableSubmittingAgain(limitTime30, limitTime8);
    }

    private void handleReceivableSubmittingAgain(LocalDateTime limitTime30, LocalDateTime limitTime8) {
        try {
            List noteReceivableInfos = NoteReceivableInfoService.getInstance().findByStatusAndInsertTime(PaymentState.PACKAGED.getId(), limitTime8, limitTime30);
            if (CollectionUtil.isNotEmpty((Collection)noteReceivableInfos)) {
                Map<String, List<NoteReceivableInfo>> groupByBatchSeqId = noteReceivableInfos.stream().collect(Collectors.groupingBy(notePayableInfo -> notePayableInfo.getBatchSeqId() + "_" + notePayableInfo.getBankBatchSeqId()));
                for (Map.Entry<String, List<NoteReceivableInfo>> entry : groupByBatchSeqId.entrySet()) {
                    String key = "receivable_" + entry.getKey();
                    if (CachePayableStorage.checkSubmitLock(key)) {
                        this.logger.info(String.format("\u5e94\u4ed8\u7968\u636e\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u6279\u6b21\u53f7\u4e3a%s\uff0c\u4efb\u52a1\u4e0d\u63d0\u4ea4\u7ebf\u7a0b\u6c60", key));
                        continue;
                    }
                    List<NoteReceivableInfo> receivableInfos = entry.getValue();
                    for (NoteReceivableInfo noteReceivableInfo : receivableInfos) {
                        if (!StringUtils.isNotEmpty((String)noteReceivableInfo.getFileListTag())) continue;
                        String fileListTag = noteReceivableInfo.getFileListTag();
                        List fileLists = JsonUtil.json2Array((String)fileListTag, FileList.class);
                        noteReceivableInfo.setFileList(fileLists);
                    }
                    this.submitReceivable(receivableInfos);
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("\u5e94\u6536\u7968\u636e\u91cd\u65b0\u63d0\u4ea4\u94f6\u884c\u5f02\u5e38", t);
        }
    }

    private void handlePayableSubmittingAgain(LocalDateTime limitTime30, LocalDateTime limitTime8) {
        try {
            List notePayableInfoListSubmitting = NotePayableInfoService.getInstance().findByStatusAndInsertTime(PaymentState.PACKAGED.getId(), limitTime8, limitTime30);
            if (CollectionUtil.isNotEmpty((Collection)notePayableInfoListSubmitting)) {
                Map<String, List<NotePayableInfo>> groupByBatchSeqId = notePayableInfoListSubmitting.stream().collect(Collectors.groupingBy(notePayableInfo -> notePayableInfo.getBatchSeqId() + "_" + notePayableInfo.getBankBatchSeqId()));
                for (Map.Entry<String, List<NotePayableInfo>> entry : groupByBatchSeqId.entrySet()) {
                    String key = "payable_" + entry.getKey();
                    if (CachePayableStorage.checkSubmitLock(key)) {
                        this.logger.info(String.format("\u5e94\u4ed8\u7968\u636e\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u6279\u6b21\u53f7\u4e3a%s\uff0c\u4efb\u52a1\u4e0d\u63d0\u4ea4\u7ebf\u7a0b\u6c60", key));
                        continue;
                    }
                    List<NotePayableInfo> notePayableInfoList = entry.getValue();
                    for (NotePayableInfo notePayableInfo2 : notePayableInfoList) {
                        if (!StringUtils.isNotEmpty((String)notePayableInfo2.getFileListTag())) continue;
                        String fileListTag = notePayableInfo2.getFileListTag();
                        List fileLists = JsonUtil.json2Array((String)fileListTag, FileList.class);
                        notePayableInfo2.setFileList(fileLists);
                    }
                    this.submitPayable(notePayableInfoList);
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("\u5e94\u4ed8\u7968\u636e\u91cd\u65b0\u63d0\u4ea4\u94f6\u884c\u5f02\u5e38", t);
        }
    }

    private void submitReceivable(List<NoteReceivableInfo> noteReceivableInfoList) {
        NoteReceivableInfo receivableInfo = noteReceivableInfoList.get(0);
        String bankVersion = receivableInfo.getBankVersionID();
        String bizType = receivableInfo.getBizType();
        String customerId = receivableInfo.getCustomID();
        String batchSeqId = receivableInfo.getBatchSeqId();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo(receivableInfo.getDrawerAccNo());
        bankAcnt.setBankLoginId(receivableInfo.getBankLoginID());
        bankAcnt.setBankVersionId(bankVersion);
        String subBizType = receivableInfo.getSubBizType();
        String traceId = String.valueOf(System.currentTimeMillis());
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customerId).requestSeqID("").bizName(bizType).subBizName(subBizType).bankVersionID(bankVersion).bankLoginID(receivableInfo.getBankLoginID()).bizSeqID(batchSeqId).logBizSeqID(Sequence.gen18Sequence()).logRequestSeqID(traceId).loggerBatchNo(batchSeqId).loggerDetailNo(receivableInfo.getBankBatchSeqId()).loggerBankNo(receivableInfo.getBankBatchSeqId()).build();
        context.setBankAcnt(bankAcnt);
        EBContext.setContext((EBContext)context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC((EBContext)context);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        BankNoteReceivableRequest notePayableRequest = NoteScheduleJob.prepareBankReceivableRequest(noteReceivableInfoList, bankAcnt);
        EBThreadPools.getNotePayable(customerId, receivableInfo.getBankLoginID()).submit((Callable)((Object)new BankNoteReceivableTask(notePayableRequest, context)));
    }

    private static BankNoteReceivableRequest prepareBankReceivableRequest(List<NoteReceivableInfo> noteReceivableInfos, BankAcnt acnt) {
        BankNoteReceivableRequest payableRequest = new BankNoteReceivableRequest();
        if (noteReceivableInfos.size() > 0) {
            NoteReceivableInfo info = noteReceivableInfos.get(0);
            payableRequest.setNoteReceivableInfos(noteReceivableInfos);
            payableRequest.setTotalCount(noteReceivableInfos.size());
            payableRequest.setTotalAmount(NoteScheduleJob.getTotalAmountReceivable(noteReceivableInfos));
            payableRequest.setBankBatchSeqID(info.getBankBatchSeqId());
            payableRequest.setHeader(NoteScheduleJob.getHeader(info, acnt));
        }
        return payableRequest;
    }

    private static BankHeader getHeader(NoteReceivableInfo info, BankAcnt bankAcnt) {
        BankHeader header = new BankHeader();
        BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(bankAcnt.getAccNo(), info.getCustomID());
        String bankVersionID = info.getBankVersionID();
        String bankLoginID = info.getBankLoginID();
        String bankCurrency = CurrencyUtils.convert2Bank((String)acnt.getCurrency(), (String)info.getBankVersionID(), (String)info.getCustomID());
        header.setCustomerID(info.getCustomID());
        header.setBankCurrency(bankCurrency);
        header.setBankLoginID(bankLoginID);
        header.setBankVersionID(bankVersionID);
        header.setBizType(info.getBizType());
        header.setSubBizType(info.getSubBizType());
        header.setBizSeqID(info.getBankBatchSeqId());
        header.setLogBizSeqID(info.getBatchSeqId());
        header.setLogRequestSeqID(String.valueOf(System.currentTimeMillis()));
        header.setRequestSeqID(Sequence.genSequence());
        header.setAcnt(acnt);
        header.setClientName("ebc_bankNoteReceivableTask");
        header.setClientVersion("1.0");
        return header;
    }

    public static BigDecimal getTotalAmountReceivable(List<NoteReceivableInfo> infos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        if (!Objects.isNull(infos)) {
            for (NoteReceivableInfo info : infos) {
                bigDecimal = bigDecimal.add(info.getAmount());
            }
        }
        return bigDecimal;
    }

    private void submitPayable(List<NotePayableInfo> notePayableInfoList) {
        NotePayableInfo paymentInfo = notePayableInfoList.get(0);
        String bankVersion = paymentInfo.getBankVersionID();
        String bizType = paymentInfo.getBizType();
        String customerId = paymentInfo.getCustomID();
        String batchSeqId = paymentInfo.getBatchSeqId();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo(paymentInfo.getDrawerAccNo());
        bankAcnt.setBankLoginId(paymentInfo.getBankLoginID());
        bankAcnt.setBankVersionId(bankVersion);
        String subBizType = paymentInfo.getSubBizType();
        String traceId = String.valueOf(System.currentTimeMillis());
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customerId).requestSeqID("").bizName(bizType).subBizName(subBizType).bankVersionID(bankVersion).bankLoginID(paymentInfo.getBankLoginID()).bizSeqID(batchSeqId).logBizSeqID(Sequence.gen18Sequence()).logRequestSeqID(traceId).loggerBatchNo(batchSeqId).loggerDetailNo(paymentInfo.getBankBatchSeqId()).loggerBankNo(paymentInfo.getBankBatchSeqId()).build();
        context.setBankAcnt(bankAcnt);
        EBContext.setContext((EBContext)context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC((EBContext)context);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        BankNotePayableRequest notePayableRequest = NoteScheduleJob.prepareBankPayRequest(notePayableInfoList, bankAcnt);
        EBThreadPools.getNotePayable(customerId, paymentInfo.getBankLoginID()).submit((Callable)((Object)new BankNotePayableTask(notePayableRequest, context)));
    }

    private static BankNotePayableRequest prepareBankPayRequest(List<NotePayableInfo> notePayableInfos, BankAcnt acnt) {
        BankNotePayableRequest payableRequest = new BankNotePayableRequest();
        if (notePayableInfos.size() > 0) {
            NotePayableInfo info = notePayableInfos.get(0);
            payableRequest.setNotePayableInfoList(notePayableInfos);
            payableRequest.setTotalCount(notePayableInfos.size());
            payableRequest.setTotalAmount(NoteScheduleJob.getTotalAmount(notePayableInfos));
            payableRequest.setBankBatchSeqID(info.getBankBatchSeqId());
            payableRequest.setHeader(NoteScheduleJob.getHeader(info, acnt));
        }
        return payableRequest;
    }

    public static BigDecimal getTotalAmount(List<NotePayableInfo> infos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        if (!Objects.isNull(infos)) {
            for (NotePayableInfo info : infos) {
                bigDecimal = bigDecimal.add(info.getAmount());
            }
        }
        return bigDecimal;
    }

    private static BankHeader getHeader(NotePayableInfo info, BankAcnt bankAcnt) {
        BankHeader header = new BankHeader();
        BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(bankAcnt.getAccNo(), info.getCustomID());
        String bankVersionID = info.getBankVersionID();
        String bankLoginID = info.getBankLoginID();
        String bankCurrency = CurrencyUtils.convert2Bank((String)acnt.getCurrency(), (String)info.getBankVersionID(), (String)info.getCustomID());
        header.setCustomerID(info.getCustomID());
        header.setBankCurrency(bankCurrency);
        header.setBankLoginID(bankLoginID);
        header.setBankVersionID(bankVersionID);
        header.setBizType(info.getBizType());
        header.setSubBizType(info.getSubBizType());
        header.setBizSeqID(info.getBankBatchSeqId());
        header.setLogBizSeqID(info.getBatchSeqId());
        header.setLogRequestSeqID(String.valueOf(System.currentTimeMillis()));
        header.setRequestSeqID(Sequence.genSequence());
        header.setAcnt(acnt);
        header.setClientName("ebc_bankNotePayableTask");
        header.setClientVersion("1.0");
        return header;
    }
}

