/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.mservice.boot.handler;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBException;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.entity.base.EBResponse;
import kd.ebg.egf.common.exception.EBPreCheckException;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.license.EbgLicenseUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.properties.ObjectPropertiesKey;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.note.business.util.LogSubTypeConvert;
import kd.ebg.note.common.framework.properties.SystemPropertyConfig;
import kd.ebg.note.common.framework.utils.CurrencyUtils;
import kd.ebg.note.common.utils.ReflectUtil;
import kd.ebg.note.common.utils.SpringContextUtil;
import kd.ebg.note.mservice.boot.handler.filter.IdentificationCodeHandler;
import net.sf.json.JSONObject;
import org.slf4j.MDC;

public class EBServiceHandlerEnhance<REQ extends EBRequest, RSP extends EBResponse> {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(EBServiceHandlerEnhance.class);
    private static final String REQUEST_SEQ_ID_KEY = "requestSeqID";
    private static final String BIZ_NAME_KEY = "bizName";
    private static final String SUB_BIZ_NAME_KEY = "subBizName";
    private static final String BIZ_SEQ_KEY = "bizSeqID";
    private static final String CUSTOMER_ID = "customerID";
    private static final String BANK_VERSION_ID = "bankVersionID";
    private static final String TYPE = "type";
    private static final String NOTE_BANKS_LOGIN_ID = "NOTE_BANKS_LOGIN_ID";
    private BankAcntRepository bankAcntRepository;
    private BankLoginRepository bankLoginRepository;
    private ObjectPropertyService objectPropertyService;
    private static final List<String> NOT_CHECK_ACCNO_BIZTYPE_LIST = Arrays.asList("listBankLogin", "syncAccount", "register", "apply");
    private static final RateLimiter globalRateLimiter = RateLimiter.create((double)200.0);
    private static final long maxWaitTime = 30L;
    private static final AtomicInteger rateLimiterRejectCount = new AtomicInteger(0);
    private static final ConcurrentHashMap<String, RateLimiter> customRateLimiter = new ConcurrentHashMap();
    private final Class<REQ> requestClass;
    private final Class<RSP> responseClass;
    private final String method;
    private final EBServiceMethod<REQ, RSP> serviceMethod;

    public EBServiceHandlerEnhance(String method, EBServiceMethod<REQ, RSP> serviceMethod, Class<REQ> requestClass, Class<RSP> responseClass) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)method), (Object)ResManager.loadKDString((String)"method \u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"EBServiceHandlerEnhance_0", (String)"ebg-note-mservice", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)Objects.nonNull(serviceMethod), (Object)ResManager.loadKDString((String)"serviceMethod \u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"EBServiceHandlerEnhance_1", (String)"ebg-note-mservice", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)Objects.nonNull(requestClass), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u5b9e\u4f53\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"EBServiceHandlerEnhance_2", (String)"ebg-note-mservice", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)Objects.nonNull(responseClass), (Object)ResManager.loadKDString((String)"\u54cd\u5e94\u5b9e\u4f53\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u503c\u3002", (String)"EBServiceHandlerEnhance_3", (String)"ebg-note-mservice", (Object[])new Object[0]));
        this.method = method;
        this.serviceMethod = serviceMethod;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public RSP handle(String data, String customId) {
        EBRequest req = (EBRequest)JsonUtil.json2Obj((String)data, this.requestClass);
        req.getHeader().setCustomId(customId);
        req.getHeader().setLogBizSeqID(Sequence.gen18Sequence());
        req.getHeader().setLogRequestSeqID(String.valueOf(req.getHeader().getRequestTime()));
        return this.handle(req);
    }

    private RSP getPreErrorResponse(REQ request, String errorMsg) {
        return this.getPreErrorResponse(request, null, errorMsg);
    }

    private RSP getPreErrorResponse(REQ request, String errorCode, String errorMsg) {
        EBResponse response = (EBResponse)ReflectUtil.newInstance(this.responseClass);
        response.setHeader(request.getHeader());
        EBHeader header = response.getHeader();
        if (Objects.nonNull(header)) {
            header.setResponseTime(System.currentTimeMillis());
        }
        EBException ebException = new EBException();
        ebException.setMessage(errorMsg);
        if (StringUtils.isEmpty((String)errorCode)) {
            ebException.setErrorCode("preException");
        } else {
            ebException.setErrorCode(errorCode);
        }
        ebException.setInnerException("preException");
        response.setException(ebException);
        return (RSP)response;
    }

    private RSP getBizErrorResponse(REQ request, Throwable throwable) {
        EBResponse response = (EBResponse)ReflectUtil.newInstance(this.responseClass);
        response.setHeader(request.getHeader());
        EBHeader header = response.getHeader();
        if (Objects.nonNull(header)) {
            header.setResponseTime(System.currentTimeMillis());
        }
        EBException ebException = new EBException();
        String errorMsg = throwable.getMessage();
        if (StringUtils.isEmpty((String)errorMsg)) {
            String string = errorMsg = Objects.isNull(throwable) ? null : throwable.getMessage();
            if (throwable != null && !Objects.isNull(throwable.getCause()) && !throwable.getMessage().contains(throwable.getCause().getMessage())) {
                errorMsg = errorMsg + (Objects.isNull(throwable.getCause()) ? "" : throwable.getCause().getMessage());
            }
        }
        ebException.setMessage(errorMsg);
        ebException.setErrorCode("serviceException");
        ebException.setInnerException("serviceException");
        response.setException(ebException);
        return (RSP)response;
    }

    private synchronized RateLimiter createForCustom(String customId) {
        RateLimiter rateLimiter = customRateLimiter.get(customId);
        if (Objects.isNull(rateLimiter)) {
            rateLimiter = RateLimiter.create((double)100.0);
            customRateLimiter.put(customId, rateLimiter);
        }
        return rateLimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public RSP handle(REQ request) {
        block60: {
            block52: {
                block59: {
                    block57: {
                        block58: {
                            block55: {
                                block56: {
                                    block64: {
                                        block53: {
                                            block54: {
                                                block51: {
                                                    block49: {
                                                        block50: {
                                                            block47: {
                                                                block48: {
                                                                    block45: {
                                                                        block46: {
                                                                            block43: {
                                                                                block44: {
                                                                                    block41: {
                                                                                        block42: {
                                                                                            block37: {
                                                                                                block40: {
                                                                                                    block38: {
                                                                                                        block39: {
                                                                                                            block35: {
                                                                                                                block36: {
                                                                                                                    this.bankAcntRepository = (BankAcntRepository)SpringContextUtil.getBean(BankAcntRepository.class);
                                                                                                                    this.bankLoginRepository = (BankLoginRepository)SpringContextUtil.getBean(BankLoginRepository.class);
                                                                                                                    this.objectPropertyService = (ObjectPropertyService)SpringContextUtil.getBean(ObjectPropertyService.class);
                                                                                                                    currentMs = System.currentTimeMillis();
                                                                                                                    MDC.put((String)"requestSeqID", (String)"");
                                                                                                                    MDC.put((String)"bizSeqID", (String)"");
                                                                                                                    MDC.put((String)"customerID", (String)"");
                                                                                                                    MDC.put((String)"bizName", (String)"");
                                                                                                                    MDC.put((String)"bankVersionID", (String)"");
                                                                                                                    MDC.put((String)"type", (String)"");
                                                                                                                    h = TX.notSupported();
                                                                                                                    tryAcquire = EBServiceHandlerEnhance.globalRateLimiter.tryAcquire(30L, TimeUnit.SECONDS);
                                                                                                                    if (tryAcquire) break block35;
                                                                                                                    EBServiceHandlerEnhance.log.warn("\u89e6\u53d1\u5168\u5c40\u9650\u6d41");
                                                                                                                    EBServiceHandlerEnhance.rateLimiterRejectCount.incrementAndGet();
                                                                                                                    var6_6 = this.getPreErrorResponse(request, ResManager.loadKDString((String)"\u5168\u5c40\u9650\u6d41", (String)"EBServiceHandlerEnhance_4", (String)"ebg-note-mservice", (Object[])new Object[0]));
                                                                                                                    if (h == null) break block36;
                                                                                                                    h.close();
                                                                                                                }
                                                                                                                cost = System.currentTimeMillis() - currentMs;
                                                                                                                EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                                                                                EBContext.destroy();
                                                                                                                return var6_6;
                                                                                                            }
                                                                                                            header = request.getHeader();
                                                                                                            accountNo = header.getAccNo();
                                                                                                            customId = header.getCustomId();
                                                                                                            bankVersion = "";
                                                                                                            bankLogin = header.getBankVersion();
                                                                                                            if (StringUtils.isEmpty((String)bankLogin)) break block37;
                                                                                                            bankLoginInfo = this.bankLoginRepository.findById(bankLogin, customId);
                                                                                                            if (bankLoginInfo != null) break block38;
                                                                                                            var12_15 = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"\u524d\u7f6e\u673a[%s]\u4e0d\u5b58\u5728\u3002", (String)"EBServiceHandlerEnhance_11", (String)"ebg-note-mservice", (Object[])new Object[0]), new Object[]{bankLogin}));
                                                                                                            if (h == null) break block39;
                                                                                                            h.close();
                                                                                                        }
                                                                                                        cost = System.currentTimeMillis() - currentMs;
                                                                                                        EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                                                                        EBContext.destroy();
                                                                                                        return var12_15;
                                                                                                    }
                                                                                                    if (!bankLoginInfo.getEnable().equals("0")) break block37;
                                                                                                    var12_16 = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"\u524d\u7f6e\u673a[%s]\u5df2\u88ab\u5220\u9664\u3002", (String)"EBServiceHandlerEnhance_12", (String)"ebg-note-mservice", (Object[])new Object[0]), new Object[]{bankLogin}));
                                                                                                    if (h == null) break block40;
                                                                                                    h.close();
                                                                                                }
                                                                                                cost = System.currentTimeMillis() - currentMs;
                                                                                                EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                                                                EBContext.destroy();
                                                                                                return var12_16;
                                                                                            }
                                                                                            if (!StringUtils.isEmpty((String)bankVersion) && EBServiceHandlerEnhance.NOT_CHECK_ACCNO_BIZTYPE_LIST.contains(header.getBizType()) || accountNo == null) break block41;
                                                                                            bankAcnt = this.bankAcntRepository.findEnableByAccNo(accountNo);
                                                                                            if (bankAcnt != null) {
                                                                                                bankVersion = bankAcnt.getBankVersionId();
                                                                                                break block41;
                                                                                            }
                                                                                            var12_17 = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"\u8d26\u53f7[%s]\u4e0d\u5b58\u5728\u3002", (String)"EBServiceHandlerEnhance_18", (String)"ebg-note-mservice", (Object[])new Object[0]), new Object[]{accountNo}));
                                                                                            if (h == null) break block42;
                                                                                            h.close();
                                                                                        }
                                                                                        cost = System.currentTimeMillis() - currentMs;
                                                                                        EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                                                        EBContext.destroy();
                                                                                        return var12_17;
                                                                                    }
                                                                                    rateLimiter = EBServiceHandlerEnhance.customRateLimiter.get(customId);
                                                                                    if (Objects.isNull(rateLimiter)) {
                                                                                        rateLimiter = this.createForCustom(customId);
                                                                                    }
                                                                                    if (rateLimiter.tryAcquire(30L, TimeUnit.SECONDS)) break block43;
                                                                                    EBServiceHandlerEnhance.log.warn("\u79df\u6237:{} \u89e6\u53d1\u9650\u6d41", new Object[]{customId});
                                                                                    var12_18 = this.getPreErrorResponse(request, ResManager.loadKDString((String)"\u5355\u79df\u6237\u9650\u6d41", (String)"EBServiceHandlerEnhance_7", (String)"ebg-note-mservice", (Object[])new Object[0]));
                                                                                    if (h == null) break block44;
                                                                                    h.close();
                                                                                }
                                                                                cost = System.currentTimeMillis() - currentMs;
                                                                                EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                                                EBContext.destroy();
                                                                                return var12_18;
                                                                            }
                                                                            logBizSeqID = request.getHeader().getLogBizSeqID();
                                                                            if (StringUtils.isEmpty((String)logBizSeqID)) {
                                                                                logBizSeqID = Sequence.gen18Sequence();
                                                                            }
                                                                            if (StringUtils.isEmpty((String)header.getLogRequestSeqID())) {
                                                                                header.setLogRequestSeqID(String.valueOf(header.getRequestTime()));
                                                                            }
                                                                            extDate = request.getHeader().getExtData();
                                                                            loggerBatchNo = "";
                                                                            loggerDetailNo = "";
                                                                            loggerBankNo = "";
                                                                            if (extDate != null) {
                                                                                object = JSONObject.fromObject((Object)extDate);
                                                                                loggerBatchNo = (String)object.get("loggerBatchNo");
                                                                                loggerDetailNo = (String)object.get("loggerDetailNo");
                                                                                loggerBankNo = (String)object.get("loggerBankNo");
                                                                            }
                                                                            context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customId).logRequestSeqID(header.getLogRequestSeqID()).bizName(header.getBizType()).subBizName(header.getSubBizType()).bankVersionID(bankVersion).logBizSeqID(logBizSeqID).bizSeqID(Sequence.gen18Sequence()).requestSeqID(Sequence.genSequence()).loggerBatchNo(loggerBatchNo).loggerDetailNo(loggerDetailNo).loggerBankNo(loggerBankNo).build();
                                                                            MDCUtil.clearBankMDC();
                                                                            MDCUtil.initMDC((EBContext)context);
                                                                            MDC.put((String)"bussiness_type", (String)"bussiness_process");
                                                                            MDC.put((String)"requestSeqID", (String)context.getRequestSeqID());
                                                                            MDC.put((String)"bizSeqID", (String)context.getBizSeqID());
                                                                            MDC.put((String)"customerID", (String)context.getCustomID());
                                                                            MDC.put((String)"bizName", (String)context.getBizName());
                                                                            MDC.put((String)"bankVersionID", (String)context.getBankVersionID());
                                                                            MDC.put((String)"subBizName", (String)context.getSubBizName());
                                                                            try {
                                                                                loggersubBizType = LogSubTypeConvert.convertLogType((String)header.getBizType(), request);
                                                                                context.setLogger_sub_type(loggersubBizType);
                                                                            }
                                                                            catch (Throwable t) {
                                                                                EBServiceHandlerEnhance.log.warn("\u5b50\u4e1a\u52a1\u7c7b\u578b\u5904\u7406\u5f02\u5e38", new Object[]{t});
                                                                            }
                                                                            if ("ping".equalsIgnoreCase(header.getBizType()) && !StringUtils.isEmpty((String)header.getExtData())) {
                                                                                obj = JSON.parseObject((String)header.getExtData());
                                                                                bankVersion = obj.getString("bankVersionID");
                                                                                bankLogin = obj.getString("bankLoginID");
                                                                                context.setBankLoginID(bankLogin);
                                                                                context.setBankVersionID(bankVersion);
                                                                            }
                                                                            EBContext.setContext((EBContext)context);
                                                                            ipErrorMessage = this.checkIp();
                                                                            if (!StrUtil.isNotBlank((CharSequence)ipErrorMessage)) break block45;
                                                                            var19_31 = this.getPreErrorResponse(request, ipErrorMessage);
                                                                            if (h == null) break block46;
                                                                            h.close();
                                                                        }
                                                                        cost = System.currentTimeMillis() - currentMs;
                                                                        EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                                        EBContext.destroy();
                                                                        return var19_31;
                                                                    }
                                                                    if (!SystemPropertyConfig.isDatacenterCheckOpen()) break block47;
                                                                    identificationCode = header.getIdentificationCode();
                                                                    identificationCodeHandler = IdentificationCodeHandler.build();
                                                                    if (identificationCodeHandler.handleIdentificationCode(customId, header.getClientName(), header.getClientVersion(), identificationCode)) break block47;
                                                                    var21_37 = this.getPreErrorResponse(request, ResManager.loadKDString((String)"\u5ba2\u6237\u8ba4\u8bc1\u6807\u8bc6\u7801\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u786e\u4fdd\u6570\u636e\u4e2d\u5fc3\u914d\u7f6e\u6b63\u786e\uff0c\u4e0b\u4e00\u4ee3\u9700\u8981\u914d\u7f6e\u8d26\u5957ID\u3002", (String)"EBServiceHandlerEnhance_8", (String)"ebg-note-mservice", (Object[])new Object[0]));
                                                                    if (h == null) break block48;
                                                                    h.close();
                                                                }
                                                                cost = System.currentTimeMillis() - currentMs;
                                                                EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                                EBContext.destroy();
                                                                return var21_37;
                                                            }
                                                            allowPay = SystemPropertyConfig.allowPay();
                                                            allowOtherBiz = SystemPropertyConfig.allowOtherBiz();
                                                            if (!"detail".equalsIgnoreCase(this.method) || this.checkQueryDetail(accountNo)) break block49;
                                                            var21_38 = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u53f7\uff1a%s,\u4e0d\u5141\u8bb8\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"EBServiceHandlerEnhance_19", (String)"ebg-note-mservice", (Object[])new Object[0]), new Object[]{accountNo}));
                                                            if (h == null) break block50;
                                                            h.close();
                                                        }
                                                        cost = System.currentTimeMillis() - currentMs;
                                                        EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                        EBContext.destroy();
                                                        return var21_38;
                                                    }
                                                    EBServiceHandlerEnhance.log.info("\u8c03\u7528\u4e86 {} \u65b9\u6cd5", (Object)this.method);
                                                    headerCurrency = request.getHeader().getCurrency();
                                                    mappingCurrency = MappingCurrencyRepository.getInstance().getISOMappingCurrency(headerCurrency);
                                                    if (this.method.contains("ping")) break block51;
                                                    try {
                                                        CurrencyUtils.checkIsoCurrency((String)mappingCurrency);
                                                        request.getHeader().setCurrency(mappingCurrency);
                                                    }
                                                    catch (Exception e) {
                                                        response = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u94f6\u4f01\u652f\u6301\u7684\u6807\u51c6\u5e01\u522b\u3002", (String)"EBServiceHandlerEnhance_20", (String)"ebg-note-mservice", (Object[])new Object[0]), new Object[]{mappingCurrency}));
                                                        response.getHeader().setCurrency(headerCurrency);
                                                        var25_49 = response;
                                                        if (h != null) {
                                                            h.close();
                                                        }
                                                        cost = System.currentTimeMillis() - currentMs;
                                                        EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                                        EBContext.destroy();
                                                        return var25_49;
                                                    }
                                                }
                                                if (!this.serviceMethod.needCheckAccNo()) break block52;
                                                accNo = header.getAccNo();
                                                if (!StringUtils.isEmpty((String)bankLogin)) ** GOTO lbl205
                                                acnt = this.bankAcntRepository.findByAccNoAndCustomID(accNo, customId);
                                                if (null != acnt) break block53;
                                                response = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u4e86\u94f6\u4f01\u4e91\u4e2d\u672a\u7ef4\u62a4\u7684\u8d26\u53f7:%s\u3002", (String)"EBServiceHandlerEnhance_21", (String)"ebg-note-mservice", (Object[])new Object[0]), new Object[]{accNo}));
                                                response.getHeader().setCurrency(headerCurrency);
                                                cost = response;
                                                if (h == null) break block54;
                                                h.close();
                                            }
                                            cost = System.currentTimeMillis() - currentMs;
                                            EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                            EBContext.destroy();
                                            return cost;
                                        }
                                        EBServiceHandlerEnhance.log.info("\u94f6\u4f01\u5e73\u53f0\u4e2d\u6709\u8fd9\u4e2a\u8d26\u53f7: " + acnt.getAccNo());
                                        context.setBankAcnt(acnt);
                                        context.setBankLoginID(acnt.getBankLoginId());
                                        context.setBankVersionID(acnt.getBankVersionId());
                                        break block64;
lbl205:
                                        // 1 sources

                                        context.setBankLoginID(bankLogin);
                                        context.setBankVersionID(bankVersion);
                                    }
                                    bankAcnt = this.bankAcntRepository.findEnableByAccNo(accNo);
                                    key = new ObjectPropertiesKey();
                                    key.setCustomID(EBContext.getContext().getCustomID());
                                    key.setAttrKey("NOTE_BANKS_LOGIN_ID");
                                    key.setObjectID(bankAcnt.getAccNo());
                                    key.setObjectName("BANK_BUSINESS");
                                    note_login_id = this.objectPropertyService.getPropertyValue(key);
                                    if (!StringUtils.isNotEmpty((String)note_login_id)) ** GOTO lbl243
                                    bankLoginInfo = this.bankLoginRepository.findById((String)note_login_id, customId);
                                    if (bankLoginInfo != null) break block55;
                                    var28_60 = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"\u524d\u7f6e\u673a[%s]\u4e0d\u5b58\u5728\u3002", (String)"EBServiceHandlerEnhance_11", (String)"ebg-note-mservice", (Object[])new Object[0]), new Object[]{note_login_id}));
                                    if (h == null) break block56;
                                    h.close();
                                }
                                cost = System.currentTimeMillis() - currentMs;
                                EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                EBContext.destroy();
                                return var28_60;
                            }
                            if (!bankLoginInfo.getEnable().equals("0")) break block57;
                            var28_61 = this.getPreErrorResponse(request, String.format(ResManager.loadKDString((String)"\u524d\u7f6e\u673a[%s]\u5df2\u88ab\u5220\u9664\u3002", (String)"EBServiceHandlerEnhance_12", (String)"ebg-note-mservice", (Object[])new Object[0]), new Object[]{note_login_id}));
                            if (h == null) break block58;
                            h.close();
                        }
                        cost = System.currentTimeMillis() - currentMs;
                        EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                        EBContext.destroy();
                        return var28_61;
                    }
                    EBServiceHandlerEnhance.log.info("\u8be5\u8d26\u53f7:{} \u7ed1\u5b9a\u7684\u524d\u7f6e\u673a:{} \u5b58\u5728\u65b0\u7248\u7968\u636e\u524d\u7f6e\u673a\u7f16\u53f7:{},\u540e\u7eed\u7535\u7968\u4e1a\u52a1\u5c06\u8f6c\u79fb\u81f3\u65b0\u7248\u7968\u636e\u524d\u7f6e\u673a:{}\u4e0a\u8fdb\u884c", new Object[]{bankAcnt.getAccNo(), bankAcnt.getBankLoginId(), note_login_id});
                    context.setBankLoginID((String)note_login_id);
                    bankVersion = note_login_id.split("-")[0];
                    context.setBankVersionID(bankVersion);
lbl243:
                    // 2 sources

                    MDCUtil.initMDC((EBContext)context);
                    if ("queryNoteDetail".equalsIgnoreCase(header.getBizType()) || "queryNoteInfo".equalsIgnoreCase(header.getBizType()) || "notePayable".equalsIgnoreCase(header.getBizType()) || "queryNotePayable".equalsIgnoreCase(header.getBizType()) || "noteReceivable".equalsIgnoreCase(header.getBizType()) || "queryNoteReceivable".equalsIgnoreCase(header.getBizType()) || "noteStatusUpdate".equalsIgnoreCase(header.getBizType())) {
                        EBServiceHandlerEnhance.log.infoIndex("\u5f00\u59cb\u8fdb\u884c\u4e1a\u52a1\u5904\u7406,{}", (Object)header.getBizType());
                    }
                    if (!StrUtil.isNotBlank((CharSequence)(errorMessage = EbgLicenseUtil.checkLicenseValidForNote((String)customId, (String)context.getBankLoginID())))) break block52;
                    response = this.getPreErrorResponse(request, errorMessage);
                    response.getHeader().setCurrency(headerCurrency);
                    var29_65 = response;
                    if (h == null) break block59;
                    h.close();
                }
                cost = System.currentTimeMillis() - currentMs;
                EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                EBContext.destroy();
                return var29_65;
            }
            try {
                EBServiceHandlerEnhance.log.info("\u5f00\u59cb\u6267\u884c\u8bf7\u6c42");
                response /* !! */  = this.serviceMethod.executeClientRequest(request, context);
                EBServiceHandlerEnhance.log.info("\u6267\u884c\u8bf7\u6c42\u5b8c\u6210");
                response /* !! */ .setHeader(header);
                header.setResponseTime(System.currentTimeMillis());
                response /* !! */ .getHeader().setCurrency(headerCurrency);
                bankAcnt = response /* !! */ ;
                if (h == null) break block60;
            }
            catch (IllegalArgumentException | EBPreCheckException preCheckException) {
                block61: {
                    EBServiceHandlerEnhance.log.warn("\u524d\u7f6e\u68c0\u67e5\u5f02\u5e38:", new Object[]{preCheckException});
                    errorCode = null;
                    if (preCheckException instanceof EBPreCheckException) {
                        errorCode = ((EBPreCheckException)preCheckException).getErrorCode();
                    }
                    response /* !! */  = this.getPreErrorResponse(request, errorCode, preCheckException.getMessage());
                    response /* !! */ .getHeader().setCurrency(headerCurrency);
                    note_login_id = response /* !! */ ;
                    if (h == null) break block61;
                    h.close();
                }
                cost = System.currentTimeMillis() - currentMs;
                EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                EBContext.destroy();
                return (RSP)note_login_id;
            }
            catch (Throwable t) {
                block62: {
                    EBServiceHandlerEnhance.log.error("\u94f6\u4f01\u4e2d\u95f4\u4ef6\u629b\u5411\u4e1a\u52a1\u7cfb\u7edf\u7684\u5f02\u5e38:", t);
                    response /* !! */  = this.getBizErrorResponse(request, t);
                    response /* !! */ .getHeader().setCurrency(headerCurrency);
                    var25_51 /* !! */  = response /* !! */ ;
                    if (h == null) break block62;
                    h.close();
                }
                cost = System.currentTimeMillis() - currentMs;
                EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                EBContext.destroy();
                return (RSP)var25_51 /* !! */ ;
                {
                    catch (Exception e) {
                        block63: {
                            try {
                                h.markRollback();
                                EBServiceHandlerEnhance.log.error("handle\u5904\u7406\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                                var6_7 = this.getPreErrorResponse(request, "", e.getMessage());
                                if (h == null) break block63;
                            }
                            catch (Throwable var32_67) {
                                if (h != null) {
                                    h.close();
                                }
                                cost = System.currentTimeMillis() - currentMs;
                                EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                                EBContext.destroy();
                                throw var32_67;
                            }
                            h.close();
                        }
                        cost = System.currentTimeMillis() - currentMs;
                        EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
                        EBContext.destroy();
                        return var6_7;
                    }
                }
            }
            h.close();
        }
        cost = System.currentTimeMillis() - currentMs;
        EBServiceHandlerEnhance.log.info("\u65b9\u6cd5\uff1a{}({})\u6267\u884c\u7ed3\u675f,\u8017\u65f6:{} ms", new Object[]{this.method, request.getHeader().getSubBizType(), cost});
        EBContext.destroy();
        return (RSP)bankAcnt;
    }

    private String checkDatacenter(String name) {
        if (SystemPropertyConfig.isDatacenterCheckOpen()) {
            List datacenterList = SystemPropertyConfig.getDatacenterList();
            if (Objects.nonNull(datacenterList) && !datacenterList.isEmpty()) {
                for (String datacenter : datacenterList) {
                    if (!StrUtil.equals((String)datacenter, (String)name)) continue;
                    return null;
                }
            }
            return String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u63a5\u5165\u7684\u6570\u636e\u4e2d\u5fc3:%s\u3002", (String)"EBServiceHandlerEnhance_22", (String)"ebg-note-mservice", (Object[])new Object[0]), name);
        }
        return null;
    }

    private boolean checkQueryDetail(String accNo) {
        List queryDetailAcntList = SystemPropertyConfig.getQueryDetailList();
        if (queryDetailAcntList != null && queryDetailAcntList.size() > 0) {
            return queryDetailAcntList.contains(accNo);
        }
        return true;
    }

    private String checkIp() {
        String ipAddr = RequestContext.get().getLoginIP();
        if (StringUtils.isEmpty((String)ipAddr)) {
            return null;
        }
        log.info("\u8bf7\u6c42\u7684ip\u4e3a :{}", (Object)ipAddr);
        boolean matchingMode = SystemPropertyConfig.isMatchingMode();
        List configIpList = SystemPropertyConfig.getConfigIpList();
        boolean ipMatch = this.hasMatchConfig(configIpList, ipAddr);
        if (configIpList.isEmpty()) {
            return null;
        }
        if (matchingMode) {
            if (!ipMatch) {
                return String.format(ResManager.loadKDString((String)"%s \u4e0d\u5728\u767d\u540d\u5355\u4e2d\u3002", (String)"EBServiceHandlerEnhance_23", (String)"ebg-note-mservice", (Object[])new Object[0]), ipAddr);
            }
        } else if (ipMatch) {
            return String.format(ResManager.loadKDString((String)"%s \u5728\u9ed1\u540d\u5355\u4e2d\u3002", (String)"EBServiceHandlerEnhance_24", (String)"ebg-note-mservice", (Object[])new Object[0]), ipAddr);
        }
        return null;
    }

    private boolean hasMatchConfig(List<String> configIpList, String ipAddr) {
        for (String allowdIp : configIpList) {
            if (!StrUtil.isNotBlank((CharSequence)(allowdIp = StrUtil.trim((CharSequence)allowdIp)))) continue;
            boolean contains = ipAddr.contains(allowdIp);
            if (contains) {
                return true;
            }
            if (allowdIp.contains("*")) {
                Pattern pattern = Pattern.compile(allowdIp);
                boolean matches = pattern.matcher(ipAddr).matches();
                if (!matches) continue;
                return true;
            }
            if (allowdIp.contains("-")) {
                List allowdIpSplit = StrUtil.split((String)allowdIp, (char)'.');
                List ipAddrSplit = StrUtil.split((String)ipAddr, (char)'.');
                if (Objects.nonNull(allowdIp) && Objects.nonNull(ipAddr) && !allowdIpSplit.isEmpty() && !ipAddrSplit.isEmpty() && allowdIpSplit.size() == ipAddrSplit.size()) {
                    for (int i = 0; i < allowdIpSplit.size(); ++i) {
                        String ipSplit;
                        String configSplit = (String)allowdIpSplit.get(i);
                        if (configSplit.equals(ipSplit = (String)ipAddrSplit.get(i))) continue;
                        if (configSplit.contains("-")) {
                            List ipRanges = StrUtil.split((String)configSplit, (char)'-');
                            if (ipRanges.size() != 2) {
                                return false;
                            }
                            int start = Integer.parseInt(StrUtil.trim((CharSequence)((CharSequence)ipRanges.get(0))));
                            int end = Integer.parseInt(StrUtil.trim((CharSequence)((CharSequence)ipRanges.get(1))));
                            int real = Integer.parseInt(ipSplit);
                            return real >= start && real <= end;
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (!allowdIp.equalsIgnoreCase(ipAddr)) continue;
            return true;
        }
        return false;
    }
}

