/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.citic.dc.service.note.payable.register;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.citic.dc.service.note.ParserProxy;
import kd.ebg.note.banks.citic.dc.service.note.payable.QueryPayablePacker;
import kd.ebg.note.banks.citic.dc.service.note.status.CheckStatus;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryRegisterNotePayableImpl
extends AbstractQueryNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryRegisterNotePayableImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLBCMBDQ";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfoList = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfoList.get(0);
        if (!"true".equals(info.getObssid())) {
            boolean flag = new CheckStatus().checkStatus(info.getBankBatchSeqId());
            info.setObssid(flag + "");
        }
        this.logger.info(String.format(ResManager.loadKDString((String)"\u7968\u53f7\uff1a%s", (String)"QueryRegisterNotePayableImpl_1", (String)"ebg-note-banks-citic-dc", (Object[])new Object[0]), info.getBillNo()));
        if (StringUtils.isEmpty((String)info.getBillNo())) {
            return QueryPayablePacker.packPay(info.getBankBatchSeqId(), "DLBILREG");
        }
        return QueryPayablePacker.packQueryPay(info.getBankBatchSeqId(), "0300", info.getBillNo(), info.getDrawerAccNo());
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfoList = request.getNotePayableInfoList();
        NotePayableInfo notePayableInfo = (NotePayableInfo)notePayableInfoList.get(0);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = ParserProxy.parseResponeCode(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            Element list = root.getChild("list");
            List rows = list.getChildren("row");
            for (Element object : rows) {
                String TRASTAT = object.getChildText("TRASTAT");
                String BILLNO = object.getChildText("BILLNO");
                String BILSTAT = object.getChildText("BILSTAT");
                String statusTxt = object.getChildText("statusTxt");
                notePayableInfo.setBillNo(BILLNO);
                notePayableInfo.setNoteStatus(BILSTAT);
                if ("000".equals(TRASTAT)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.UNKNOWN, (String)BILSTAT, (String)statusTxt);
                    continue;
                }
                if ("1".equals(notePayableInfo.getAutoAccept()) && "1".equals(notePayableInfo.getAutoReceive())) {
                    if ("030006".equals(BILSTAT)) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUCCESS, (String)BILSTAT, (String)statusTxt);
                        continue;
                    }
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)BILSTAT, (String)statusTxt);
                    continue;
                }
                if ("1".equals(notePayableInfo.getAutoAccept())) {
                    if ("020006".equals(BILSTAT)) {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUCCESS, (String)BILSTAT, (String)statusTxt);
                        continue;
                    }
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)BILSTAT, (String)statusTxt);
                    continue;
                }
                if ("010004".equals(BILSTAT)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUCCESS, (String)BILSTAT, (String)statusTxt);
                    continue;
                }
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.SUBMITED, (String)BILSTAT, (String)statusTxt);
            }
        }
        return notePayableInfoList;
    }

    public int getBatchSize() {
        return 0;
    }
}

