/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.codeless.detail;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class EndorseImpl
extends AbstractNoteDetailImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(EndorseImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "PJ24";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u65b0\u7968\u80cc\u9762\u4fe1\u606f\u67e5\u8be2", (String)"EndorseImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return false;
    }

    public String pack(String billNo, String startNo, String endNo, String pageTag) {
        Element root = new Element("body");
        JDomUtils.addChild((Element)root, (String)"transMasterID", (String)BankBusinessConfig.getPayMasterID(EBContext.getContext().getAcnt().getAccNo()));
        JDomUtils.addChild((Element)root, (String)"eBillBusessType", (String)"ET05");
        JDomUtils.addChild((Element)root, (String)"billPackageNo", (String)billNo);
        JDomUtils.addChild((Element)root, (String)"sonBillRngLow", (String)startNo);
        JDomUtils.addChild((Element)root, (String)"sonBillRngHight", (String)endNo);
        JDomUtils.addChild((Element)root, (String)"beginNumber", (String)pageTag);
        JDomUtils.addChild((Element)root, (String)"queryNumber", (String)"50");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("PJ24", signedMsg);
    }

    public String pack(BankNoteDetailRequest bankNoteDetailRequest, String s) {
        return null;
    }

    public List<Detail> parse(BankNoteDetailRequest bankNoteDetailRequest, String s) {
        return null;
    }

    public List<NoteSidesInfo> parseNoteSides(String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = Parser.parseResponse(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            String errorMsg = StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()});
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String rspData = Signature.getInstance().validateSignedData(rspStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        String totalNumber = body.getChildTextTrim("totalNumber");
        ArrayList<NoteSidesInfo> detailInfos = new ArrayList<NoteSidesInfo>(16);
        Element lists = body.getChild("lists");
        if (lists == null) {
            return detailInfos;
        }
        List localList = lists.getChildren("list");
        if (localList == null || localList.size() == 0) {
            return detailInfos;
        }
        for (int i = 0; i < localList.size(); ++i) {
            Element element = (Element)localList.get(i);
            NoteSidesInfo detailInfo = new NoteSidesInfo();
            String busessDate = element.getChildTextTrim("busessDate");
            detailInfo.setSignDate(busessDate);
            detailInfo.setBusinessCode("10");
            String applyName = element.getChildTextTrim("applyName");
            detailInfo.setInitiatorName(applyName);
            String applyAcctNo = element.getChildTextTrim("applyAcctNo");
            detailInfo.setInitiatorAcNo(applyAcctNo);
            String applyBankNo = element.getChildTextTrim("applyBankNo");
            detailInfo.setInitiatorBankCnaps(applyBankNo);
            String ePayeeName = element.getChildTextTrim("ePayeeName");
            detailInfo.setOpponentName(ePayeeName);
            String ePayeeAcctNo = element.getChildTextTrim("ePayeeAcctNo");
            detailInfo.setOpponentAcNo(ePayeeAcctNo);
            String ePayeeBankNo = element.getChildTextTrim("ePayeeBankNo");
            detailInfo.setOpponentBankCnaps(ePayeeBankNo);
            String responseFlag = element.getChildTextTrim("responseFlag");
            if ("SU00".equals(responseFlag)) {
                detailInfos.add(detailInfo);
            }
            detailInfo.setResv1(i + "");
            String responserRemark = element.getChildTextTrim("responserRemark");
            detailInfo.setRemark(responserRemark);
        }
        return detailInfos;
    }

    public List<NoteSidesInfo> getMessage(String billNo, String startNo, String endNo) {
        String rspStr = "";
        ArrayList<NoteSidesInfo> list = new ArrayList<NoteSidesInfo>(16);
        try {
            String tag = this.getFirstPageTag();
            do {
                String rqstStr = this.pack(billNo, startNo, endNo, tag);
                ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
                IConnection conn = factory.createExchangeConnection();
                conn.openConnection();
                try (OutputStream os = conn.getOutputStream();){
                    IOUtils.sendFully((OutputStream)os, (String)rqstStr);
                    try (InputStream is = conn.getInputStream();){
                        rspStr = IOUtils.readFully((InputStream)is);
                        list.addAll(this.parseNoteSides(rspStr));
                        tag = this.getNextPageTag(rspStr, tag);
                        conn.closeConnection();
                    }
                    catch (Exception e) {
                        String errorMsg = ResManager.loadKDString((String)"\u80cc\u9762\u4fe1\u606f\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38", (String)"EndorseImpl_1", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
                        if (!StringUtils.isEmpty((String)e.getMessage())) {
                            errorMsg = String.format(ResManager.loadKDString((String)"\u80cc\u9762\u4fe1\u606f\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38:%s", (String)"EndorseImpl_2", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]), e.getMessage());
                        }
                        throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
                    }
                }
                catch (Exception e) {
                    String errorMsg = ResManager.loadKDString((String)"\u80cc\u9762\u4fe1\u606f\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38", (String)"EndorseImpl_1", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
                    if (!StringUtils.isEmpty((String)e.getMessage())) {
                        errorMsg = String.format(ResManager.loadKDString((String)"\u80cc\u9762\u4fe1\u606f\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38:%s", (String)"EndorseImpl_2", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]), e.getMessage());
                    }
                    throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
                }
            } while (!this.isLastPage(rspStr, tag));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        for (int i = 0; i < list.size(); ++i) {
            NoteSidesInfo info = (NoteSidesInfo)list.get(i);
            info.setResv1(list.size() - i + "");
        }
        return list;
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        return StringUtils.isEmpty((String)pageTag);
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = Parser.parseResponse(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            return null;
        }
        String rspData = Signature.getInstance().validateSignedData(rspStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        String totalNumber = body.getChildTextTrim("totalNumber");
        Integer totalNo = Integer.parseInt(totalNumber);
        Integer page = Integer.parseInt(pageTag);
        if (page + 50 - 1 >= totalNo) {
            return null;
        }
        return page + 50 + "";
    }
}

