/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.note.detail;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import org.jdom2.Element;

public class NoteDetailImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailImpl.class);
    private int curentNum = 0;

    public String pack(BankNoteDetailRequest request, String pageTag) {
        this.logger.info("\u4ee3\u7b7e\u6536\u7968\u636e\u67e5\u8be2\u6253\u5305\u4e2d");
        String subBizType = request.getHeader().getSubBizType();
        if ("hold".equals(subBizType)) {
            if (request.getBody().getTranType().equals("02")) {
                return this.queryAccept("02", pageTag, request);
            }
            if (request.getBody().getTranType().equals("03")) {
                return this.queryAccept("03", pageTag, request);
            }
            if (request.getBody().getTranType().equals("00")) {
                return this.queryAccept("04", pageTag, request);
            }
            if (request.getBody().getTranType().equals("10")) {
                return this.queryAccept("05", pageTag, request);
            }
            if (request.getBody().getTranType().equals("11")) {
                return this.queryAccept("06", pageTag, request);
            }
            if (request.getBody().getTranType().equals("18")) {
                return this.queryAccept("15", pageTag, request);
            }
            if (request.getBody().getTranType().equals("20")) {
                return this.queryAccept("17", pageTag, request);
            }
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684\u56de\u590d\u7c7b\u578b\u3002\u8bf7\u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u3002", (String)"NoteDetailImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
        }
        if ("reply".equals(subBizType)) {
            if (request.getBody().getTranType().equals("02")) {
                return this.reply(request, "02", pageTag);
            }
            if (request.getBody().getTranType().equals("03")) {
                return this.reply(request, "03", pageTag);
            }
            if (request.getBody().getTranType().equals("10")) {
                return this.reply(request, "05", pageTag);
            }
            if (request.getBody().getTranType().equals("11")) {
                return this.reply(request, "06", pageTag);
            }
            if (request.getBody().getTranType().equals("18")) {
                return this.reply(request, "15", pageTag);
            }
            if (request.getBody().getTranType().equals("20")) {
                return this.reply(request, "17", pageTag);
            }
            if (request.getBody().getTranType().equals("19")) {
                return this.reply(request, "16", pageTag);
            }
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684\u56de\u590d\u7c7b\u578b\u3002\u8bf7\u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u3002", (String)"NoteDetailImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684subBiztype\u3002", (String)"NoteDetailImpl_1", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
    }

    public String reply(BankNoteDetailRequest request, String type, String pagetag) {
        Element body = new Element("body");
        String transID = BankBusinessConfig.getPayMasterID(request.getAcnt().getAccNo());
        LocalDate start = request.getBody().getDueDate();
        LocalDate end = request.getBody().getEndIssueDate();
        if (start == null || end == null) {
            JDomUtils.addChild((Element)body, (String)"beginDate");
            JDomUtils.addChild((Element)body, (String)"endDate");
        } else {
            if (start.until(end, ChronoUnit.MONTHS) > 3L) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u8be2\u533a\u95f4\u5927\u4e8e3\u4e2a\u6708\u3002", (String)"NoteDetailImpl_2", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)body, (String)"beginDate", (String)start.format(DateTimeFormatter.BASIC_ISO_DATE));
            JDomUtils.addChild((Element)body, (String)"endDate", (String)end.format(DateTimeFormatter.BASIC_ISO_DATE));
        }
        if (transID == null) {
            RequestContextUtils.getBankParameterValue((String)"masterIds");
        } else {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transID);
        }
        JDomUtils.addChild((Element)body, (String)"eBillBusessType", (String)type);
        JDomUtils.addChild((Element)body, (String)"eBillType");
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)pagetag);
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)"20");
        JDomUtils.addChild((Element)body, (String)"signerAcct");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("EE25", signedMsg);
    }

    public String queryAccept(String type, String tag, BankNoteDetailRequest request) {
        Element body = new Element("body");
        String transID = BankBusinessConfig.getPayMasterID(request.getAcnt().getAccNo());
        if (transID == null) {
            RequestContextUtils.getBankParameterValue((String)"masterIds");
        } else {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transID);
        }
        JDomUtils.addChild((Element)body, (String)"eBillBusessType", (String)type);
        JDomUtils.addChild((Element)body, (String)"eBillType");
        JDomUtils.addChild((Element)body, (String)"beginDate");
        JDomUtils.addChild((Element)body, (String)"endDate");
        JDomUtils.addChild((Element)body, (String)"eBillAmount");
        JDomUtils.addChild((Element)body, (String)"billNo");
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)tag);
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)"20");
        JDomUtils.addChild((Element)body, (String)"recourseType");
        JDomUtils.addChild((Element)body, (String)"billType");
        JDomUtils.addChild((Element)body, (String)"eMaxAmount");
        JDomUtils.addChild((Element)body, (String)"eDrawerName");
        JDomUtils.addChild((Element)body, (String)"beforeCompanyName");
        JDomUtils.addChild((Element)body, (String)"acceptorBankNo");
        JDomUtils.addChild((Element)body, (String)"applyAcct");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("EE23", signedMsg);
    }

    public List<Detail> parse(BankNoteDetailRequest request, String responseStr) {
        BankAcnt ancAcnt = request.getAcnt();
        this.logger.info("\u660e\u7ec6\u8fd4\u56de\u62a5\u6587\uff1a" + responseStr);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        ArrayList<Detail> detailList = new ArrayList<Detail>();
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u5f02\u5e38", (String)"NoteDetailImpl_3", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
        }
        if (-1 != rsp.getResponseMessage().indexOf(ResManager.loadKDString((String)"\u6ca1\u6709\u76f8\u5173\u7684\u4ea4\u6613\u8bb0\u5f55\u3002", (String)"NoteDetailImpl_4", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]))) {
            return detailList;
        }
        String rspData = Signature.getInstance().validateSignedData(responseStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)encoding);
        Element dtlListElement = body.getChild("lists");
        List dtlLists = dtlListElement.getChildren("list");
        String subBizType = request.getHeader().getSubBizType();
        if (subBizType.equals("reply")) {
            return this.parseReply(dtlLists);
        }
        return this.parseAccpect(dtlLists);
    }

    public List<Detail> parseReply(List<Element> list) {
        ArrayList<Detail> detailList = new ArrayList<Detail>(list.size());
        for (Element rs : list) {
            Detail detailInfo = new Detail();
            String transJnlNo = rs.getChildTextTrim("transJnlNo");
            this.logger.info("transJnlNo\u7684\u503c\u4e3a:" + transJnlNo);
            detailInfo.setBankRefKey(transJnlNo);
            String billNo = rs.getChildTextTrim("billNo");
            detailInfo.setNoteNo(billNo);
            String voteDate = rs.getChildTextTrim("voteDate");
            detailInfo.setIssueDate(voteDate);
            String expiryDate = rs.getChildTextTrim("expiryDate");
            detailInfo.setDueDate(expiryDate);
            String eBillType = rs.getChildTextTrim("eBillType");
            detailInfo.setDraftType(eBillType);
            String eBillAmount = rs.getChildTextTrim("eBillAmount");
            detailInfo.setAmount(eBillAmount);
            String canTransferFlag = rs.getChildTextTrim("canTransferFlag");
            detailInfo.setTransferFlag(canTransferFlag);
            String eBillStatus = rs.getChildTextTrim("eBillStatus");
            detailInfo.setNoteStatus(eBillStatus);
            String applyDate = rs.getChildTextTrim("applyDate");
            detailInfo.setApplicationDate(applyDate);
            String applyName = rs.getChildText("applyName");
            detailInfo.setDrawerAccName(applyName);
            String applyAcctNo = rs.getChildText("applyAcctNo");
            detailInfo.setDrawerAccNo(applyAcctNo);
            String applyBankNo = rs.getChildText("applyBankNo");
            detailInfo.setDrawerCnapsCode(applyBankNo);
            String ePayeeAcctName = rs.getChildText("ePayeeAcctName");
            detailInfo.setPayeeAccName(ePayeeAcctName);
            String ePayeeAcctNo = rs.getChildText("ePayeeAcctNo");
            detailInfo.setPayeeAccNo(ePayeeAcctNo);
            String ePayeeBankNo = rs.getChildText("ePayeeBankNo");
            detailInfo.setPayeeCnapsCode(ePayeeBankNo);
            String discountRate = rs.getChildText("discountRate");
            detailInfo.setDisCountRate(discountRate);
            String noPayReason = rs.getChildText("noPayReason");
            detailInfo.setReserved2(noPayReason);
            String noPayRemark = rs.getChildText("noPayRemark");
            detailInfo.setReserved3(noPayRemark);
            detailList.add(detailInfo);
        }
        return detailList;
    }

    public List<Detail> parseAccpect(List<Element> list) {
        ArrayList<Detail> detailList = new ArrayList<Detail>(list.size());
        for (Element rs : list) {
            Detail detailInfo = new Detail();
            String billNo = rs.getChildTextTrim("billNo");
            detailInfo.setNoteNo(billNo);
            String eBillType = rs.getChildTextTrim("eBillType");
            detailInfo.setDraftType(eBillType);
            String canTransferFlag = rs.getChildTextTrim("canTransferFlag");
            detailInfo.setTransferFlag(canTransferFlag);
            String acptDt = rs.getChildText("voteDate");
            String dueDt = rs.getChildText("expiryDate");
            String billMoney = rs.getChildText("eBillAmount");
            String eBillStatus = rs.getChildText("eBillStatus");
            String eDrawerName = rs.getChildText("eDrawerName");
            String remitterCustBankNo = rs.getChildText("eDrawerBankNo");
            String remitterAcct = rs.getChildText("eDrawerAcctNo");
            String payee = rs.getChildText("ePayeeAcctName");
            String payeeBankNo = rs.getChildText("ePayeeBankNo");
            String payeeAcct = rs.getChildText("ePayeeAcctNo");
            String acceptor = rs.getChildText("acceptorName");
            String acceptorBankNo = rs.getChildText("acceptorBankNo");
            detailInfo.setIssueDate(acptDt);
            detailInfo.setDueDate(dueDt);
            if (StringUtils.isEmpty((String)billMoney)) {
                detailInfo.setAmount("0");
            } else {
                detailInfo.setAmount(billMoney);
            }
            detailInfo.setDrawerAccName(eDrawerName);
            detailInfo.setDrawerAccNo(remitterAcct);
            detailInfo.setDrawerCnapsCode(remitterCustBankNo);
            detailInfo.setPayeeAccName(payee);
            detailInfo.setPayeeAccNo(payeeAcct);
            detailInfo.setPayeeCnapsCode(payeeBankNo);
            detailInfo.setAcceptorAccName(acceptor);
            detailInfo.setAcceptorCnapsCode(acceptorBankNo);
            detailInfo.setNoteStatus(eBillStatus);
            detailList.add(detailInfo);
        }
        return detailList;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        int page = Integer.parseInt(pageTag);
        int nextPage = page + 20;
        return "" + nextPage;
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        String rspData = Signature.getInstance().validateSignedData(rspStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        Element dtlListElement = body.getChild("lists");
        List dtlLists = dtlListElement.getChildren("list");
        return dtlLists == null || dtlLists.size() < 20;
    }

    public int getCurentNum() {
        return this.curentNum;
    }

    public void setCurentNum(int curentNum) {
        this.curentNum = curentNum;
    }
}

