/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmbc.dc.services.news.detail;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cmbc.dc.services.news.detail.AbstractCmbcNoteDetailImpl;
import kd.ebg.note.banks.cmbc.dc.services.news.detail.NoteInfoImpl;
import kd.ebg.note.banks.cmbc.dc.services.util.Packer;
import kd.ebg.note.banks.cmbc.dc.services.util.Parser;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.utils.PropertiesConstantsUtils;
import org.jdom2.Element;

public class CodelessNoteDetailImpl
extends AbstractCmbcNoteDetailImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CodelessNoteDetailImpl.class);

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "B2eNbsQryStaySignUpDrafts";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f85\u7b7e\u6536\u7968\u636e\u67e5\u8be2", (String)"CodelessNoteDetailImpl_0", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse bankResponse = Parser.parseResponse(root);
        if (-1 != bankResponse.getResponseMessage().indexOf(PropertiesConstantsUtils.getValue((String)"nothing"))) {
            return true;
        }
        Element xDataBodyElement = root.getChild("xDataBody");
        String allNum = xDataBodyElement.getChildTextTrim("total");
        if (!StringUtils.isEmpty((String)allNum)) {
            int page = Integer.parseInt(pageTag) - 1;
            return page * 100 >= Integer.parseInt(allNum);
        }
        return true;
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        int page = Integer.parseInt(pageTag);
        int nextPage = page + 1;
        return "" + nextPage;
    }

    public String pack(BankNoteDetailRequest bankNoteDetailRequest, String pageTag) {
        BankAcnt acnt = bankNoteDetailRequest.getAcnt();
        BankNoteDetailRequestBody info = bankNoteDetailRequest.getBody();
        Element root = Packer.createMessageWithHead(this.getBizCode());
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.gen16Sequence());
        JDomUtils.addChild((Element)xdataBody, (String)"custAccount", (String)acnt.getAccNo());
        String tranType = info.getTranType();
        if ("02".equals(tranType)) {
            JDomUtils.addChild((Element)xdataBody, (String)"queryType", (String)"01");
        } else if ("03".equals(tranType)) {
            JDomUtils.addChild((Element)xdataBody, (String)"queryType", (String)"02");
        } else if ("10".equals(tranType)) {
            JDomUtils.addChild((Element)xdataBody, (String)"queryType", (String)"03");
        } else if ("18".equals(tranType)) {
            JDomUtils.addChild((Element)xdataBody, (String)"queryType", (String)"04");
        } else if ("20".equals(tranType)) {
            JDomUtils.addChild((Element)xdataBody, (String)"queryType", (String)"06");
        } else {
            if ("21".equals(tranType)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u903e\u671f\u63d0\u793a\u4ed8\u6b3e\u5f85\u7b7e\u6536\u67e5\u8be2\u3002", (String)"CodelessNoteDetailImpl_10", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]));
            }
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684\u56de\u590d\u7c7b\u578b\u3002\u8bf7\u8054\u7cfb\u94f6\u4f01\u5e73\u53f0\u3002", (String)"CodelessNoteDetailImpl_1", (String)"ebg-note-banks-cmbc-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)xdataBody, (String)"pageNo", (String)pageTag);
        JDomUtils.addChild((Element)xdataBody, (String)"pageSize", (String)"100");
        JDomUtils.addChild((Element)xdataBody, (String)"billType", (String)info.getDraftType());
        if (info.getStartIssueDate() != null) {
            JDomUtils.addChild((Element)xdataBody, (String)"beginAcptDt", (String)LocalDateUtil.formatDate((LocalDate)info.getStartIssueDate(), (String)"yyyy-MM-dd"));
        }
        if (info.getEndIssueDate() != null) {
            JDomUtils.addChild((Element)xdataBody, (String)"endAcptDt", (String)LocalDateUtil.formatDate((LocalDate)info.getEndIssueDate(), (String)"yyyy-MM-dd"));
        }
        if (info.getStartDueDate() != null) {
            JDomUtils.addChild((Element)xdataBody, (String)"beginEndDate", (String)LocalDateUtil.formatDate((LocalDate)info.getStartDueDate(), (String)"yyyy-MM-dd"));
        }
        if (info.getEndDueDate() != null) {
            JDomUtils.addChild((Element)xdataBody, (String)"endDate", (String)LocalDateUtil.formatDate((LocalDate)info.getEndDueDate(), (String)"yyyy-MM-dd"));
        }
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public List<Detail> parse(BankNoteDetailRequest bankNoteDetailRequest, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        ArrayList<Detail> detailList = new ArrayList<Detail>(16);
        if (-1 != rsp.getResponseMessage().indexOf(PropertiesConstantsUtils.getValue((String)"noRecord"))) {
            return detailList;
        }
        if (!"0".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)rsp.getResponseMessage());
        }
        Element body = root.getChild("xDataBody");
        Element list = body.getChild("List");
        List map = list.getChildren("Map");
        for (Element info : map) {
            Detail detail = new Detail();
            String billNo = info.getChildTextTrim("billNo");
            detail.setNoteNo(billNo);
            String billRangeStart = info.getChildTextTrim("billRangeStart");
            detail.setStartNo(billRangeStart);
            String billRangeEnd = info.getChildTextTrim("billRangeEnd");
            detail.setEndNo(billRangeEnd);
            String isAllowSplitBill = info.getChildTextTrim("isAllowSplitBill");
            detail.setGrdBag(isAllowSplitBill);
            String billType = info.getChildTextTrim("billType");
            detail.setDraftType(billType);
            String remitDt = info.getChildTextTrim("remitDt");
            detail.setIssueDate(remitDt);
            String dueDt = info.getChildTextTrim("dueDt");
            detail.setDueDate(dueDt);
            String billMoney = info.getChildTextTrim("billMoney");
            detail.setAmount(billMoney);
            String drwrName = info.getChildTextTrim("drwrName");
            detail.setDrawerAccName(drwrName);
            String drwrAcctNo = info.getChildTextTrim("drwrAcctNo");
            detail.setDrawerAccNo(drwrAcctNo);
            String drwrBankName = info.getChildTextTrim("drwrBankName");
            detail.setDrawerBankName(drwrBankName);
            String drwrBankNo = info.getChildTextTrim("drwrBankNo");
            detail.setDrawerCnapsCode(drwrBankNo);
            String pyeeName = info.getChildTextTrim("pyeeName");
            detail.setPayeeAccName(pyeeName);
            String pyeeAcctNo = info.getChildTextTrim("pyeeAcctNo");
            detail.setPayeeAccNo(pyeeAcctNo);
            String pyeeBankName = info.getChildTextTrim("pyeeBankName");
            detail.setPayeeBankName(pyeeBankName);
            String pyeeBankNo = info.getChildTextTrim("pyeeBankNo");
            detail.setPayeeCnapsCode(pyeeBankNo);
            String acptName = info.getChildTextTrim("acptName");
            detail.setAcceptorAccName(acptName);
            String acptAcctNo = info.getChildTextTrim("acptAcctNo");
            detail.setAcceptorAccNo(acptAcctNo);
            String acptBankName = info.getChildTextTrim("acptBankName");
            detail.setAcceptorBankName(acptBankName);
            String acptBankNo = info.getChildTextTrim("acptBankNo");
            detail.setAcceptorCnapsCode(acptBankNo);
            String transFromName = info.getChildTextTrim("transFromName");
            detail.setPreHolderName(transFromName);
            String transFromRmark = info.getChildTextTrim("transFromRmark");
            detail.setRemark(transFromRmark);
            String banEndrsmtMark = info.getChildTextTrim("banEndrsmtMark");
            detail.setTransferFlag(banEndrsmtMark);
            String sttlmMk = info.getChildTextTrim("sttlmMk");
            detail.setSettleWay(sttlmMk);
            String transFromAcctNo = info.getChildTextTrim("transFromAcctNo");
            detail.setHolderAccNo(transFromAcctNo);
            String transFromBankNo = info.getChildTextTrim("transFromBankNo");
            detail.setHolderCnapsCode(transFromBankNo);
            String transFromBankName = info.getChildTextTrim("transFromBankName");
            detail.setHolderBankName(transFromBankName);
            detail.setApplicantAcName(transFromName);
            detail.setApplicantAcNo(transFromAcctNo);
            detail.setApplicantBankName(transFromBankName);
            detail.setApplicantBankCnaps(transFromBankNo);
            detail.setCirStatus("TF0302");
            if (bankNoteDetailRequest.getBody().getTranType().equals("02")) {
                detail.setNoteStatus("CS01");
            } else if (bankNoteDetailRequest.getBody().getTranType().equals("03")) {
                detail.setNoteStatus("CS02");
            } else {
                detail.setNoteStatus("CS03");
            }
            String transId = info.getChildTextTrim("transId");
            detail.setBankRefKey(transId);
            detailList.add(detail);
            if (!bankNoteDetailRequest.getBody().getTranType().equals("10")) continue;
            try {
                BankNoteDetailRequest request = new BankNoteDetailRequest();
                BankHeader header = new BankHeader();
                header.setAcnt(EBContext.getContext().getAcnt());
                header.setSubBizType("reply");
                request.setHeader(header);
                BankNoteDetailRequestBody requestBody = new BankNoteDetailRequestBody();
                requestBody.setStartNo(detail.getStartNo());
                requestBody.setEndNo(detail.getEndNo());
                requestBody.setNoteNo(detail.getNoteNo());
                requestBody.setDraftType(detail.getDraftType());
                request.setBody(requestBody);
                NoteInfoImpl impl = new NoteInfoImpl();
                EBBankDetailResponse response = impl.doBiz(request);
                List noteSidesInfo = ((Detail)response.getDetails().get(0)).getNoteSidesInfo();
                detail.setNoteSidesInfo(noteSidesInfo);
            }
            catch (Exception e) {
                logger.info("\u7968\u53f7\u4e3a{}\u67e5\u8be2\u80cc\u9762\u4fe1\u606f\u5931\u8d25", (Object)billNo);
                detail.setIsNoteSidesError("Y");
            }
        }
        return detailList;
    }
}

