/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.pab.dc.service.note.receivable.discount;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.pab.dc.service.note.receivable.SplideUtil;
import kd.ebg.note.banks.pab.dc.service.note.receivable.discount.QueryDiscountNoteReceivableImpl;
import kd.ebg.note.banks.pab.dc.service.note.util.PackerUtil;
import kd.ebg.note.banks.pab.dc.service.note.util.ParserRateUtils;
import kd.ebg.note.banks.pab.dc.service.note.util.ParserUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class DiscountNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryDiscountNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P70104";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d34\u73b0\u7533\u8bf7(P70104)", (String)"DiscountNoteReceivableImpl_0", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        NoteReceivableInfo[] infos = request.getNotePayableInfosAsArray();
        SplideUtil splideUtil = new SplideUtil();
        String pack4Split = splideUtil.packNoteDetailRequset(infos, "1", "NES.007.20.00P");
        String res4Split = this.doBussiness(pack4Split);
        Map<String, String> result = splideUtil.parseNoteInfoDetail(res4Split);
        NoteReceivableInfo info = infos[0];
        JSONObject root = new JSONObject();
        JSONObject requestDto = new JSONObject();
        requestDto.put("dataSource", (Object)"1");
        requestDto.put("batchNumber", (Object)Sequence.gen16NumSequence());
        root.put("requestDto", (Object)requestDto);
        JSONArray reqInfoList = new JSONArray();
        requestDto.put("reqInfoList", (Object)reqInfoList);
        JSONObject object = new JSONObject();
        reqInfoList.add((Object)object);
        object.put("applAcctNo", (Object)info.getDrawerAccNo());
        object.put("applBankNo", (Object)info.getDrawerBankCnaps());
        String billId_hldrId = info.getBankRefKey();
        if (StringUtils.isEmpty((String)billId_hldrId)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"bankRefKey\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff0c\u65e0\u6cd5\u5904\u7406", (String)"DiscountNoteReceivableImpl_1", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
        }
        String[] bankRefKey = billId_hldrId.split("_");
        if (bankRefKey.length < 4) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"bankRefKey\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff0c\u65e0\u6cd5\u5904\u7406", (String)"DiscountNoteReceivableImpl_1", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
        }
        object.put("billId", (Object)result.get("billId"));
        object.put("hldrId", (Object)result.get("hldrId"));
        object.put("transAmt", (Object)info.getAmount());
        object.put("transNo", (Object)"NES.007.20.00P");
        object.put("reserveFlag", (Object)"0");
        object.put("rmrkByPropsr", (Object)info.getExplanation());
        JSONObject discInfo = new JSONObject();
        object.put("discInfo", (Object)discInfo);
        discInfo.put("discType", (Object)"RM00");
        discInfo.put("rateType", (Object)"360");
        discInfo.put("discRate", (Object)ParserRateUtils.convertCentStr2Yuan(info.getDisCountRate()));
        discInfo.put("discDt", (Object)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        discInfo.put("discAmt", (Object)info.getDisCountAmount());
        discInfo.put("toAcctNo", (Object)"0");
        discInfo.put("toBankNo", (Object)info.getPayeeBankCnaps());
        discInfo.put("toBankName", (Object)info.getPayeeBankName());
        discInfo.put("aoAcctNo", (Object)info.getAcceptorAccNo());
        discInfo.put("aoAcctName", (Object)info.getAcceptorAccName());
        discInfo.put("aoBankNo", (Object)info.getAcceptorBankCnaps());
        discInfo.put("sttlmMk", (Object)"ST01");
        discInfo.put("banEndrsmtMark", (Object)"EM00");
        return PackerUtil.getPackerResult(root.toJSONString(), "P70104");
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rspStr) {
        List infos = bankNoteReceivableRequest.getNoteReceivableInfos();
        ParserUtil.parsePay(infos, rspStr);
        return infos;
    }
}

