/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.pab.dc.service.note.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.pab.dc.service.note.ParserHelper;
import kd.ebg.note.banks.pab.dc.service.note.util.PageUtil;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class ParserUtil {
    public static JSONObject getJsonRoot(String respStr) {
        BankResponse bankRsp = new BankResponse();
        PageUtil pageUtil = ParserHelper.parseResponse(respStr, bankRsp);
        if (!"000000".equals(bankRsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u5f02\u5e38", (String)"ParserUtil_0", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
        }
        Element root = JDomUtils.string2Root((String)pageUtil.getXmlStr(), (String)RequestContextUtils.getCharset());
        String outputRoot = root.getChildText("outputRoot");
        JSONObject request = JSONObject.parseObject((String)outputRoot);
        return request;
    }

    public static void parsePay(List<NoteReceivableInfo> infos, String rspStr) {
        JSONObject retData = ParserUtil.getJsonRoot(rspStr);
        String retCode = retData.getString("retCode");
        if (!"000000".equals(retCode)) {
            String retMsg = retData.getString("retMsg");
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)retCode, (String)retMsg);
        } else {
            JSONObject content = retData.getJSONObject("retData");
            JSONArray list = content.getJSONArray("list");
            for (int i = 0; i < list.size(); ++i) {
                String[] bankRefKey;
                String billId_hldrId;
                JSONObject object = (JSONObject)list.get(i);
                NoteReceivableInfo info = infos.get(0);
                if (info == null) continue;
                String billId = object.getString("billId");
                String hldrId = object.getString("hldrId");
                String transId = object.getString("transId");
                String msgId = object.getString("msgId");
                if (StringUtils.isEmpty((String)transId)) {
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)retCode, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6570\u636e\u4e0d\u5168\uff0c\u65e0\u6cd5\u540c\u6b65\u4ea4\u6613\u7ed3\u679c\uff0c\u8bf7\u7ebf\u4e0b\u786e\u8ba4", (String)"ParserUtil_1", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
                    continue;
                }
                info.setReserved3(transId);
                info.setReserved1(billId);
                info.setReserved2(hldrId);
                if ("note_signin".equals(info.getSubBizType())) {
                    billId_hldrId = info.getBankRefKey();
                    bankRefKey = billId_hldrId.split("_");
                    info.setBankRefKey(bankRefKey[0] + '_' + bankRefKey[2] + '_' + transId + '_' + msgId);
                } else {
                    billId_hldrId = info.getBankRefKey();
                    bankRefKey = billId_hldrId.split("_");
                    info.setBankRefKey(bankRefKey[0] + '_' + bankRefKey[1] + '_' + transId + '_' + msgId);
                }
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u884c\u6210\u529f", (String)"ParserUtil_2", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
            }
        }
    }
}

