/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zjrc.dc.service;

import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.zjrc.dc.service.api.FileCommonUtils;
import kd.ebg.receipt.banks.zjrc.dc.service.api.ZJRCDCCommConfig;
import kd.ebg.receipt.banks.zjrc.dc.service.api.receipt.DownLoadBankReceiptImpl;
import kd.ebg.receipt.banks.zjrc.dc.service.api.receipt.FetchBankReceiptImpl;
import kd.ebg.receipt.banks.zjrc.dc.service.api.receipt.TransformRemoteFileImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    private static final String RECEIPTSEPERATOR = "_";

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String data;
        DownloadListDetail detail;
        BankReceiptResponseEB resp;
        TransformRemoteFileImpl trf;
        BankReceiptRequest req1;
        HashMap<String, String> m1;
        String fileName;
        String subTranFlow;
        String tellerSeqNo;
        String htmlContent;
        BankReceiptResponseEB downResp;
        BankReceiptRequest req2;
        BankReceiptRequest req;
        ArrayList<Map<String, Object>> total;
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String bankLoginId = EBContext.getContext().getBankLoginID();
        String dateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDate + "\n");
        ZJRCDCCommConfig config = (ZJRCDCCommConfig)EBConfigBuilder.getInstance().buildConfig(ZJRCDCCommConfig.class, bankLoginId);
        String warrantType = config.getWarrantType();
        FetchBankReceiptImpl fetchR = new FetchBankReceiptImpl();
        DownLoadBankReceiptImpl downR = new DownLoadBankReceiptImpl();
        String bankVersionId = request.getBankVersionId();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        if (warrantType.contains(PropertiesConstantsUtils.getValue((String)"SETT_RECEIPT"))) {
            total = new ArrayList<Map<String, Object>>(16);
            req = this.buildReq(accNo, transDate, "01", "1", "01");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "01", "1", "02");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "01", "1", "03");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "01", "1", "04");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "01", "1", "05");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "01", "1", "06");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "01", "1", "07");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "01", "2", "01");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "01", "2", "02");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "01", "2", "03");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "01", "2", "04");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "01", "2", "05");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "01", "2", "06");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "01", "2", "07");
            total.addAll(fetchR.process(req));
            logger.info("01\u56de\u5355\u7c7b\u578b\u7684\u83b7\u53d6\u7684\u6570\u91cf" + total.size());
            for (Map map : total) {
                map.put("warrantType", "01");
                req2 = this.buildReq(accNo, transDate, map);
                downResp = downR.doBiz(req2);
                htmlContent = (String)downResp.getData();
                tellerSeqNo = (String)map.get("tellerSeqNo");
                subTranFlow = (String)map.get("subTranFlow");
                fileName = dateStr + RECEIPTSEPERATOR + accNo + RECEIPTSEPERATOR + tellerSeqNo + RECEIPTSEPERATOR + subTranFlow + RECEIPTSEPERATOR + dateStr + ".pdf";
                m1 = new HashMap(2);
                m1.put("fileName", fileName);
                m1.put("fileContent", htmlContent);
                req1 = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap(m1).build();
                trf = new TransformRemoteFileImpl();
                resp = trf.doBiz(req1);
                detail = new DownloadListDetail();
                data = (String)resp.getData();
                FileCommonUtils.base64ToFile(data, bakFilePath + File.separator + fileName);
                detail.setFileName(fileName);
                detail.setFileLink(fileName);
                result.add(detail);
            }
        }
        if (warrantType.contains(PropertiesConstantsUtils.getValue((String)"ONE_RECEIPT"))) {
            total = new ArrayList(16);
            req = this.buildReq(accNo, transDate, "03", "1", "01");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "03", "1", "02");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "03", "2", "01");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "03", "2", "02");
            total.addAll(fetchR.process(req));
            logger.info("03\u56de\u5355\u7c7b\u578b\u7684\u83b7\u53d6\u7684\u6570\u91cf" + total.size());
            for (Map map : total) {
                map.put("warrantType", "03");
                req2 = this.buildReq(accNo, transDate, map);
                downResp = downR.doBiz(req2);
                htmlContent = (String)downResp.getData();
                tellerSeqNo = (String)map.get("tellerSeqNo");
                subTranFlow = (String)map.get("subTranFlow");
                fileName = dateStr + RECEIPTSEPERATOR + accNo + RECEIPTSEPERATOR + tellerSeqNo + RECEIPTSEPERATOR + subTranFlow + RECEIPTSEPERATOR + dateStr + ".pdf";
                m1 = new HashMap(2);
                m1.put("fileName", fileName);
                m1.put("fileContent", htmlContent);
                req1 = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap(m1).build();
                trf = new TransformRemoteFileImpl();
                resp = trf.doBiz(req1);
                detail = new DownloadListDetail();
                data = (String)resp.getData();
                FileCommonUtils.base64ToFile(data, bakFilePath + File.separator + fileName);
                detail.setFileName(fileName);
                detail.setFileLink(fileName);
                result.add(detail);
            }
        }
        if (warrantType.contains(PropertiesConstantsUtils.getValue((String)"CENTER_RECEIPT"))) {
            total = new ArrayList(8);
            req = this.buildReq(accNo, transDate, "04", "1", "01");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "04", "2", "01");
            total.addAll(fetchR.process(req));
            logger.info("04\u56de\u5355\u7c7b\u578b\u7684\u83b7\u53d6\u7684\u6570\u91cf" + total.size());
            for (Map map : total) {
                map.put("warrantType", "04");
                req2 = this.buildReq(accNo, transDate, map);
                downResp = downR.doBiz(req2);
                htmlContent = (String)downResp.getData();
                tellerSeqNo = (String)map.get("tellerSeqNo");
                subTranFlow = (String)map.get("subTranFlow");
                fileName = dateStr + RECEIPTSEPERATOR + accNo + RECEIPTSEPERATOR + tellerSeqNo + RECEIPTSEPERATOR + subTranFlow + RECEIPTSEPERATOR + dateStr + ".pdf";
                m1 = new HashMap<String, String>(2);
                m1.put("fileName", fileName);
                m1.put("fileContent", htmlContent);
                req1 = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap(m1).build();
                trf = new TransformRemoteFileImpl();
                resp = trf.doBiz(req1);
                detail = new DownloadListDetail();
                data = (String)resp.getData();
                FileCommonUtils.base64ToFile(data, bakFilePath + File.separator + fileName);
                detail.setFileName(fileName);
                detail.setFileLink(fileName);
                result.add(detail);
            }
        }
        if (warrantType.contains(PropertiesConstantsUtils.getValue((String)"AMONG_RECEIPT"))) {
            total = new ArrayList(8);
            req = this.buildReq(accNo, transDate, "05", "1", "01");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "05", "2", "01");
            total.addAll(fetchR.process(req));
            logger.info("05\u56de\u5355\u7c7b\u578b\u7684\u83b7\u53d6\u7684\u6570\u91cf" + total.size());
            for (Map map : total) {
                map.put("warrantType", "05");
                req2 = this.buildReq(accNo, transDate, map);
                downResp = downR.doBiz(req2);
                htmlContent = (String)downResp.getData();
                tellerSeqNo = (String)map.get("tellerSeqNo");
                subTranFlow = (String)map.get("subTranFlow");
                fileName = dateStr + RECEIPTSEPERATOR + accNo + RECEIPTSEPERATOR + tellerSeqNo + RECEIPTSEPERATOR + subTranFlow + RECEIPTSEPERATOR + dateStr + ".pdf";
                m1 = new HashMap(2);
                m1.put("fileName", fileName);
                m1.put("fileContent", htmlContent);
                req1 = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap(m1).build();
                trf = new TransformRemoteFileImpl();
                resp = trf.doBiz(req1);
                detail = new DownloadListDetail();
                data = (String)resp.getData();
                FileCommonUtils.base64ToFile(data, bakFilePath + File.separator + fileName);
                detail.setFileName(fileName);
                detail.setFileLink(fileName);
                result.add(detail);
            }
        }
        if (warrantType.contains(PropertiesConstantsUtils.getValue((String)"OTHER_RECEIPT"))) {
            total = new ArrayList(16);
            req = this.buildReq(accNo, transDate, "06", "1", "01");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "06", "1", "02");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "06", "1", "03");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "06", "2", "01");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "06", "2", "02");
            total.addAll(fetchR.process(req));
            req = this.buildReq(accNo, transDate, "06", "2", "03");
            total.addAll(fetchR.process(req));
            logger.info("06\u56de\u5355\u7c7b\u578b\u7684\u83b7\u53d6\u7684\u6570\u91cf" + total.size());
            for (Map map : total) {
                map.put("warrantType", "06");
                req2 = this.buildReq(accNo, transDate, map);
                downResp = downR.doBiz(req2);
                htmlContent = (String)downResp.getData();
                tellerSeqNo = (String)map.get("tellerSeqNo");
                subTranFlow = (String)map.get("subTranFlow");
                fileName = dateStr + RECEIPTSEPERATOR + accNo + RECEIPTSEPERATOR + tellerSeqNo + RECEIPTSEPERATOR + subTranFlow + RECEIPTSEPERATOR + dateStr + ".pdf";
                m1 = new HashMap(2);
                m1.put("fileName", fileName);
                m1.put("fileContent", htmlContent);
                req1 = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap(m1).build();
                trf = new TransformRemoteFileImpl();
                resp = trf.doBiz(req1);
                detail = new DownloadListDetail();
                data = (String)resp.getData();
                FileCommonUtils.base64ToFile(data, bakFilePath + File.separator + fileName);
                detail.setFileName(fileName);
                detail.setFileLink(fileName);
                result.add(detail);
            }
        }
        logger.info("\u6d59\u6c5f\u519c\u4fe1\u8fd4\u56de\u7684\u56de\u5355\u6570\u91cf\u6761\u6570\uff1a{}", (Object)result.size());
        return BankReceiptHandleResponseEB.success(result);
    }

    public BankReceiptRequest buildReq(String accNo, LocalDate localDate, String warrantType, String warrantSign, String businessType) {
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        paramMap.put("warrantType", warrantType);
        paramMap.put("warrantSign", warrantSign);
        paramMap.put("businessType", businessType);
        paramMap.put("tellerSeqNo", "");
        paramMap.put("subTranFlow", "");
        paramMap.put("date", "");
        return BankReceiptRequest.builder().accNo(accNo).transDate(localDate).paramsMap(paramMap).build();
    }

    public BankReceiptRequest buildReq(String accNo, LocalDate localDate, Map<String, Object> paramMap) {
        return BankReceiptRequest.builder().accNo(accNo).transDate(localDate).paramsMap(paramMap).build();
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BOSH_BankReceiptFetchListAndDownloadTheList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_5", (String)"ebg-receipt-banks-zjrc-dc", (Object[])new Object[0]);
    }
}

