/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hfb.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.login.LoginAccess;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.login.LoginAccessManager;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.utils.HFB_Packer;
import kd.ebg.receipt.banks.hfb.dc.service.receipt.utils.HFB_Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.jdom2.Element;

public class ReceiptFileQueryImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptFileQueryImpl.class);

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "NWHD03";
    }

    public String getBizDesc() {
        return "";
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setProtocol("HTTP");
        EBContext.getContext().setCharsetName("GBK");
        factory.setHttpHeader("content-type", "text/xml; charset=GBK");
        LoginAccess la = LoginAccessManager.searchLock();
        String token = la.getToken();
        factory.setUri("/HFYQService/APIReqServlet?dse_sessionId=" + token + "&opName=" + this.getBizCode());
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String logNo = bankReceiptRequest.getRequestStr();
        Element root = HFB_Packer.buildHead(Sequence.gen14Sequence());
        Element opReq = root.getChild("opReq");
        Element reqParam = JDomUtils.addChild((Element)opReq, (String)"reqParam");
        String accNo = bankReceiptRequest.getAccNo();
        JDomUtils.addChild((Element)reqParam, (String)"ACC_NO", (String)accNo);
        JDomUtils.addChild((Element)reqParam, (String)"TX_LOG_NO", (String)logNo);
        JDomUtils.addChild((Element)reqParam, (String)"TRAN_DATE", (String)LocalDateUtil.formatDate((LocalDate)bankReceiptRequest.getTransDate()));
        String rqstStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)"GBK");
        rqstStr = rqstStr.replaceAll("\n", "");
        rqstStr = rqstStr.replaceAll("\r", "");
        rqstStr = rqstStr.replaceAll(" ", "");
        rqstStr = "<?xml version=\"1.0\" encoding=\"GBK\"?>" + rqstStr;
        return rqstStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        String encoding = "GBK";
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = HFB_Parser.parserHead(root);
        if (!"000000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u56de\u5355\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\uff0c%2$s", (String)"ReceiptFileQueryImpl_0", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element txInfo = root.getChild("TX_INFO");
        String file_name = txInfo.getChildText("FILE_NAME");
        String file_success = txInfo.getChildText("FILE_SUCCESS");
        if (Objects.equals(file_success, "0")) {
            return BankReceiptResponseEB.success((Object)file_name);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u56de\u5355\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\uff0c%2$s", (String)"ReceiptFileQueryImpl_0", (String)"ebg-receipt-banks-hfb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
    }
}

