/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.crbc.dc.service.receipt.api;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.jdom2.Element;

public class CommonUtils {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CommonUtils.class);
    private static CommonUtils commonUtils;

    public static synchronized CommonUtils getInstance() {
        if (commonUtils == null) {
            commonUtils = new CommonUtils();
        }
        return commonUtils;
    }

    public String getPackerData(String tranCode, Element body) throws EBServiceException {
        Element head = new Element("HEAD");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        String formatTime = LocalDateTime.now().format(dateTimeFormatter);
        JDomUtils.addChild((Element)head, (String)"TRAN_CODE", (String)tranCode);
        JDomUtils.addChild((Element)head, (String)"TRAN_TIME", (String)formatTime);
        Element element = new Element("CRBANK");
        JDomUtils.addChild((Element)element, (Element)head);
        JDomUtils.addChild((Element)element, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        String requestStr = JDomUtils.root2String((Element)element, (String)encoding);
        return requestStr;
    }
}

