/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.zzb.dc.service.receipt;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.receipt.banks.zzb.dc.service.receipt.ZzbDcCommConfig;
import kd.ebg.receipt.banks.zzb.dc.service.receipt.api.ZzbBankDetailRequestImpl;
import kd.ebg.receipt.banks.zzb.dc.service.receipt.api.ZzbBankReceiptDwonloadRequestImpl;
import kd.ebg.receipt.banks.zzb.dc.service.receipt.api.ZzbBankReceiptNameRequestImpl;
import kd.ebg.receipt.banks.zzb.dc.service.receipt.util.ReponsePars;
import kd.ebg.receipt.banks.zzb.dc.service.receipt.util.RequestPack;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankLoginProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest bankReceiptHandleRequest) {
        this.init(bankReceiptHandleRequest);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        long taskId = bankReceiptHandleRequest.getTaskId();
        DownloadListTask task = this.downloadTaskService.findById(taskId);
        String accNo = task.getAccNo();
        LocalDate transDate = task.getTransDate();
        String transDateStr = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String bankLoginID = EBContext.getContext().getBankLoginID();
        BankLoginProperties loginProperties = (BankLoginProperties)EBConfigBuilder.getInstance().buildConfig(BankLoginProperties.class, bankLoginID);
        String host = loginProperties.getIp();
        int port = loginProperties.getPort();
        ZzbDcCommConfig config = (ZzbDcCommConfig)EBConfigBuilder.getInstance().buildConfig(ZzbDcCommConfig.class, bankLoginID);
        String userPassword = config.getCipher();
        HashMap runningParams = Maps.newHashMapWithExpectedSize((int)16);
        runningParams.put("userPassword", userPassword);
        EBContext.getContext().setRunningParams((Map)runningParams);
        String detailURL = "http://" + host + ":" + port + "/eb2e/B2EActTrsQry.do?userPassword=" + userPassword + "&SIGDATA=0&_locale=zh_CN";
        List<Map<String, String>> receiptDetail_list = ZzbBankDetailRequestImpl.queryDetailList(accNo, transDate);
        DownloadListDetail detail = null;
        for (Map<String, String> receiptDetail : receiptDetail_list) {
            String JnlNo = receiptDetail.get("JnlNo");
            String Amount = receiptDetail.get("Amount");
            String receiptURL = "http://" + host + ":" + port + "/eb2e/B2EDigitalReceiptInfoQuery.do?userPassword=" + userPassword + "&SIGDATA=0&_locale=zh_CN";
            String request = RequestPack.receiptRequest(accNo, transDateStr, JnlNo, Amount);
            ZzbBankReceiptNameRequestImpl zzbBankReceiptNameRequest = new ZzbBankReceiptNameRequestImpl();
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().requestStr(request).accNo(accNo).transDate(transDate).build();
            BankReceiptResponseEB zzbBankReceiptNameResponseEB = (BankReceiptResponseEB)zzbBankReceiptNameRequest.doBiz((BankRequest)bankReceiptRequest);
            String response = (String)zzbBankReceiptNameResponseEB.getData();
            Map<String, String> map = ReponsePars.receiptParser(response);
            String FileName = map.get("FileName");
            String newFileName = accNo + "_" + transDateStr + "_" + JnlNo + "_" + Amount + ".pdf";
            detail = new DownloadListDetail();
            detail.setFileLink(FileName);
            detail.setFileName(newFileName);
            result.add(detail);
            String ERPJnlNo = Sequence.gen18Sequence();
            runningParams.put("fileName", FileName);
            runningParams.put("ERPJNLNO", ERPJnlNo);
            EBContext.getContext().setRunningParams((Map)runningParams);
            ZzbBankReceiptDwonloadRequestImpl zzbBankReceiptDwonloadRequest = new ZzbBankReceiptDwonloadRequestImpl();
            bankReceiptRequest = BankReceiptRequest.builder().requestStr(request).accNo(accNo).transDate(transDate).build();
            BankReceiptResponseEB zzbBankReceiptDwonloadResponseEB = (BankReceiptResponseEB)zzbBankReceiptDwonloadRequest.doBiz((BankRequest)bankReceiptRequest);
            response = (String)zzbBankReceiptDwonloadResponseEB.getData();
            if (ReponsePars.downloadParser(response).booleanValue()) {
                logger.info("\u56de\u5355" + FileName + "\u4e0b\u8f7d\u6210\u529f\u3002\u91cd\u547d\u540d\u4e3a\uff1a" + newFileName);
                continue;
            }
            logger.info("\u56de\u5355" + FileName + "\u4e0b\u8f7d\u5931\u8d25");
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-zzb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "ZZB_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u90d1\u5dde\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-zzb-dc", (Object[])new Object[0]);
    }
}

