/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.spdb.dc.service.receipt.api;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringLength;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.Packer;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.api.Signature;
import kd.ebg.receipt.business.receipt.atom.AbstractProxyReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import org.jdom2.Element;

public class WJ01ProxyImpl
extends AbstractProxyReceiptImpl
implements IBankReceipt {
    public String getDeveloper() {
        return "LW";
    }

    public String getBizCode() {
        return "WJ01";
    }

    public String getBizDesc() {
        return "WJO1";
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String accNo = bankReceiptRequest.getAccNo();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)bankReceiptRequest.getTransDate());
        Element packet = new Element("packet");
        Element buildWJ01Body = Packer.buildWJ01Body(accNo, transDateStr);
        Element buildHeadMessage = Packer.buildHeadMessage("WJ01");
        JDomUtils.addChild((Element)packet, (Element)buildHeadMessage);
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)buildWJ01Body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signMsg = sign.sign(srcSign);
        Element bodySign = new Element("body");
        JDomUtils.addChild((Element)bodySign, (String)"signature", (String)signMsg);
        JDomUtils.addChild((Element)packet, (Element)bodySign);
        String msg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)packet, (String)RequestContextUtils.getCharset());
        String encoding = RequestContextUtils.getCharset();
        String length = Integer.toString(StringLength.getLength4DataWithEncoding((String)msg, (String)encoding) + 6);
        StringBuilder buffer = new StringBuilder();
        buffer.append(StringLength.fixedLength((String)length, (String)" ", (int)6));
        buffer.append(msg);
        return buffer.toString();
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String response) {
        return BankReceiptResponseEB.success((Object)response);
    }

    public String recv(InputStream inputStream) {
        String savePath = RequestContextUtils.getRunningParam((String)"savePath");
        String fileName = RequestContextUtils.getRunningParam((String)"fileName");
        try {
            byte[] getData = this.readInputStream(inputStream);
            String string = new String(getData);
            if (EBGStringUtils.isEmpty((String)string)) {
                throw new ReceiptException(ResManager.loadKDString((String)"WJ01\u63a5\u53e3\u54cd\u5e94\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002", (String)"WJ01ProxyImpl_0", (String)"ebg-receipt-banks-spdb-dc", (Object[])new Object[0]));
            }
            File saveDir = FileCommonUtils.getFileByPath((String)savePath);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            File file = FileCommonUtils.getFileByPath((String)(saveDir + File.separator + fileName));
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(getData);
            }
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        return fileName;
    }

    private byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int len;
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setIp(RequestContextUtils.getBankParameterValue((String)"biSafeIP"));
        factory.setPort(RequestContextUtils.getBankParameterValue((String)"biSafeFilePort"));
        factory.setHttpHeader("sign_ip", RequestContextUtils.getBankParameterValue((String)"biSignIp"));
        factory.setHttpHeader("sign_port", RequestContextUtils.getBankParameterValue((String)"biSignPort"));
        factory.setUri("/fileTransfer/");
    }

    public String setFileType() {
        return ".zip";
    }

    public boolean isRemoveResponseWrite() {
        return true;
    }
}

