/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.jxnsb.cmp.service.receipt.fetch;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.receipt.banks.jxnsb.cmp.service.receipt.api.OneReceiptDownloadImpl;
import kd.ebg.receipt.banks.jxnsb.cmp.service.receipt.api.QueryReceiptDetailImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        Integer status = request.getTaskStatus();
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        HashMap existMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
            existMap.put(downloadListDetail.getFileName(), downloadListDetail);
        }
        String accNo = request.getAccNo();
        String transDateStr = request.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate transDate = request.getTransDate();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        BankHeader bankHeader = request.getHeader();
        bankReceiptRequest.setHeader(bankHeader);
        QueryReceiptDetailImpl queryReceiptDetail = new QueryReceiptDetailImpl();
        BankReceiptResponseEB receiptResponseEB = queryReceiptDetail.doBiz(bankReceiptRequest);
        if (receiptResponseEB.getCode() == BankReceiptResponseEB.ResultEnum.SUCCESS.getCode()) {
            OneReceiptDownloadImpl oneReceiptDownload = new OneReceiptDownloadImpl();
            BankReceiptRequest oneReceiptDownloadRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
            HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
            List details = (List)receiptResponseEB.getData();
            for (DetailInfo detailInfo : details) {
                String receiptName;
                String jsonMap = detailInfo.getJson();
                oneReceiptDownloadRequest.setRequestStr(jsonMap);
                JSONObject jsonObject = JSONObject.parseObject((String)jsonMap);
                String fileName = BankReceiptFetchImpl.packFileName(accNo, transDateStr, jsonObject, countMap);
                if (existMap.containsKey(fileName)) {
                    DownloadListDetail downloadListDetail = (DownloadListDetail)existMap.get(fileName);
                    downloadListDetail.setUploadFlag(Integer.valueOf(UploadStatusEnum.UPLOAD_SUCCESS.getId()));
                    downloadListDetail.setReceiptJson(jsonMap);
                    result.add(downloadListDetail);
                    continue;
                }
                BankReceiptResponseEB oneReceiptDownloadResponseEB = oneReceiptDownload.doBiz(oneReceiptDownloadRequest);
                if (oneReceiptDownloadResponseEB.getCode() != BankReceiptResponseEB.ResultEnum.SUCCESS.getCode() || !EBGStringUtils.isNotEmpty((String)(receiptName = (String)oneReceiptDownloadResponseEB.getData()))) continue;
                DownloadListDetail downloadListDetail = new DownloadListDetail();
                downloadListDetail.setFileName(fileName);
                downloadListDetail.setFileLink(receiptName);
                downloadListDetail.setReceiptJson(jsonMap);
                result.add(downloadListDetail);
            }
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public static String packFileName(String accNo, String transDateStr, JSONObject jsonObject, Map<String, Integer> countMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(accNo).append("_");
        sb.append(transDateStr).append("_");
        String serial_no = jsonObject.getString("serial_no");
        String crdr_flag = jsonObject.getString("crdr_flag");
        String amt = jsonObject.getString("amt");
        String kind = jsonObject.getString("kind");
        sb.append(serial_no).append("_");
        sb.append(crdr_flag).append("_");
        sb.append(amt).append("_");
        sb.append(kind);
        String fileNamePre = sb.toString();
        if (countMap.containsKey(sb.toString())) {
            int count = countMap.get(sb.toString());
            sb.append("_").append(count + 1);
            countMap.put(fileNamePre, count + 1);
        } else {
            countMap.put(fileNamePre, 0);
        }
        sb.append(".pdf");
        return sb.toString();
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean isBreak() {
        return true;
    }
}

