/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cib.dc.services.receipt.api;

import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.cib.dc.services.receipt.CibDcCommConfig;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class TodaySubmitBankReceiptBatchNoApiImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(TodaySubmitBankReceiptBatchNoApiImpl.class);

    public String pack(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        String transDateStr = request.getTransDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String requestXml = this.buildReceiptReq(accNo, transDateStr);
        return requestXml;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        Element fox = this.parseRoot(responseStr);
        Element sec = JDomExtUtils.getChildElement((Element)fox, (String)"SECURITIES_MSGSRSV1");
        Element ele = JDomExtUtils.getChildElement((Element)sec, (String)"DAYELECTRONICRECEIPTTRNRS");
        Element sta = JDomExtUtils.getChildElement((Element)ele, (String)"STATUS");
        String code = JDomExtUtils.getChildElement((Element)sta, (String)"CODE").getTextTrim();
        if ("0".equals(code)) {
            Element rsb = JDomExtUtils.getChildElement((Element)ele, (String)"RSBODY");
            Element clt = JDomExtUtils.getChildElement((Element)rsb, (String)"CLT_REF_NO");
            return BankReceiptResponseEB.success((Object)clt.getTextTrim());
        }
        Element mes = JDomExtUtils.getChildElement((Element)sta, (String)"MESSAGE");
        String message = mes.getText();
        String mark = PropertiesConstantsUtils.getValue((String)"IS_EXIST_BATCH_NO");
        if (message != null && message.startsWith(mark)) {
            message = message.substring(mark.length());
            return BankReceiptResponseEB.success((Object)message);
        }
        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8c03\u7528OPC103090211001000000300\u63a5\u53e3\u83b7\u53d6\u5230\u94f6\u884c\u9519\u8bef\u62a5\u6587\uff0c\u94f6\u884c\u8fd4\u56de\u7801[%1$s]:%2$s\u3002", (String)"TodaySubmitBankReceiptBatchNoApiImpl_0", (String)"ebg-receipt-banks-cib-dc", (Object[])new Object[0]), code, message));
    }

    private Element parseRoot(String response) {
        Document doc = JDomUtils.string2Document((String)response, (String)"GBK");
        return doc.getRootElement();
    }

    private Element buildHeadMessage() {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        CibDcCommConfig config = (CibDcCommConfig)EBConfigBuilder.getInstance().buildConfig(CibDcCommConfig.class, bankLoginId);
        Element cms = new Element("FOX");
        Element eb = JDomUtils.addChild((Element)cms, (String)"SIGNONMSGSRQV1");
        Element pub = JDomUtils.addChild((Element)eb, (String)"SONRQ");
        JDomUtils.addChild((Element)pub, (String)"DTCLIENT", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        JDomUtils.addChild((Element)pub, (String)"CID", (String)config.getReceiptFetchListClientId());
        JDomUtils.addChild((Element)pub, (String)"USERID", (String)config.getReceiptFetchListUserId());
        JDomUtils.addChild((Element)pub, (String)"USERPASS", (String)config.getReceiptFetchListPwd());
        JDomUtils.addChild((Element)pub, (String)"GENUSERKEY", (String)"N");
        JDomUtils.addChild((Element)pub, (String)"LANGUAGE", (String)"CHS");
        JDomUtils.addChild((Element)pub, (String)"APPID", (String)"");
        JDomUtils.addChild((Element)pub, (String)"APPVER", (String)"1.0");
        return cms;
    }

    private String buildReceiptReq(String accNo, String transDate) {
        Element head = this.buildHeadMessage();
        Element sec = JDomUtils.addChild((Element)head, (String)"SECURITIES_MSGSRQV1");
        Element ele = JDomUtils.addChild((Element)sec, (String)"DAYELECTRONICRECEIPTTRNRQ");
        JDomUtils.addChild((Element)ele, (String)"TRNUID", (String)Sequence.genSequence());
        Element rqb = JDomUtils.addChild((Element)ele, (String)"RQBODY");
        JDomUtils.addChild((Element)rqb, (String)"RECEIPT_TYPE", (String)"01");
        JDomUtils.addChild((Element)rqb, (String)"ACCTID", (String)accNo);
        JDomUtils.addChild((Element)rqb, (String)"RECEIPTDATE", (String)transDate);
        return JDomUtils.element2StringPlain((Element)head, (String)"GBK");
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "OPC103090211001000000300";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-fox");
    }
}

