/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.jsb.cmp.service.receipt.api;

import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.jsb.cmp.util.Packer;
import kd.ebg.receipt.banks.jsb.cmp.util.Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.jdom2.Document;
import org.jdom2.Element;

public class BankReceiptImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptImpl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        Element root = Packer.buildHead("0000301T038A9032", Sequence.genSequence());
        Element body = JDomUtils.getUnNullChildElement((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)bankReceiptRequest.getAccNo());
        JDomUtils.addChild((Element)body, (String)"queryDate", (String)bankReceiptRequest.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"reserved", (String)"");
        String xml = JDomUtils.doc2StrGB2312((Document)new Document(root));
        logger.info("\u6b63\u5728\u53d1\u9001\u8bf7\u6c42\u62a5\u6587>>>>>>>>", (Object)xml);
        return BankReceiptImpl.buildCommonMsg(xml);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        logger.info("\u63a5\u6536\u8bf7\u6c42\u62a5\u6587>>>>>>>>{}", (Object)s);
        Element root = JDomUtils.str2Doc((String)s, (String)"GB2312").getRootElement();
        BankResponse bankResponse = Parser.parser(root);
        if (!"0_0000".equalsIgnoreCase(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u8bf7\u6c42\u4e0b\u8f7d\u56de\u5355ZIP\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a%1$s\u9519\u8bef\u4fe1\u606f\uff1a%2$s\u3002", (String)"BankReceiptImpl_3", (String)"ebg-receipt-banks-jsb-cmp", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage()));
        }
        String filename = root.getChild("body").getChildTextTrim("file_name");
        logger.info("\u83b7\u53d6\u5230\u7684\u6587\u4ef6\u540d\u4e3a>>>>>>>>{}", (Object)filename);
        return BankReceiptResponseEB.success((Object)filename);
    }

    public static String buildCommonMsg(String xmlStr) {
        int length = BankReceiptImpl.getLength(xmlStr);
        StringBuilder buffer = new StringBuilder();
        buffer.append(BankReceiptImpl.formatLen(Integer.toString(length + 2), 10));
        buffer.append("00");
        buffer.append(xmlStr);
        return buffer.toString();
    }

    public static String formatLen(String orgStr, int exptecedLength) {
        try {
            String encoding = RequestContextUtils.getCharset();
            return StringFormater.formatLen((String)orgStr, (int)exptecedLength, (boolean)true, (char)'0', (String)encoding);
        }
        catch (Exception e) {
            logger.info("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u51fa\u9519\uff0c", (Object)e);
            return "";
        }
    }

    public static int getLength(String msg) {
        String encoding = RequestContextUtils.getCharset();
        try {
            int length = msg.getBytes(encoding).length;
            return length;
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u62a5\u6587\u5934+\u62a5\u6587\u4f53\u957f\u5ea6\u662f\u51fa\u9519\uff0c", (Object)e);
            return 0;
        }
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "0000301T038A9032";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u4e0b\u8f7d\u56de\u5355ZIP\u6587\u4ef6\u3002", (String)"BankReceiptImpl_2", (String)"ebg-receipt-banks-jsb-cmp", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg(super.recv(inputStream));
    }
}

