/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccb.dc.service.receipt;

import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.ccb.dc.service.receipt.api.BankReceiptDownLoadQueryApiImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.ErrorMsgUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptDownLoadException;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    /*
     * Unable to fully structure code
     */
    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        ftpPath = null;
        sftp = null;
        bankVersionId = request.getBankVersionId();
        accNo = request.getAccNo();
        transDate = request.getTransDate();
        bankLoginId = request.getBankLoginId();
        bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        detailList = this.downloadListDetailService.selectByRefId(request.getTaskId());
        resultList = new ArrayList<DownloadListDetail>(detailList.size());
        isLastFile = false;
        for (i = 0; i < detailList.size(); ++i) {
            block18: {
                block17: {
                    block15: {
                        block16: {
                            if (i == detailList.size() - 1) {
                                isLastFile = true;
                            }
                            if ((detail = (DownloadListDetail)detailList.get(i)).getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                                resultList.add(detail);
                                continue;
                            }
                            newFileName = detail.getFileName();
                            fileName = detail.getFileLink();
                            receiptFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + newFileName));
                            if (receiptFile.exists()) {
                                resultList.add(detail);
                                continue;
                            }
                            paramMap = Maps.newHashMapWithExpectedSize((int)8);
                            paramMap.put("fileLink", detail.getFileLink());
                            receiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap((Map)paramMap).build();
                            iBankReceipt = new BankReceiptDownLoadQueryApiImpl();
                            receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz((BankRequest)receiptRequest);
                            if (receiptResponseEB.getCode() != BankReceiptResponseEB.ResultEnum.SUCCESS.getCode()) break block17;
                            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                                if (SFTPUtils.getInstance().isAbort(sftp)) {
                                    sftp = SFTPUtils.getInstance().getSftp(bankLoginId);
                                    ftpPath = bankFtpProperties.getFtpPath();
                                    ftpPath = EBGStringUtils.isEmpty((String)ftpPath) != false ? "/" : ftpPath;
                                }
                                SFTPUtils.getInstance().downloadSingleFile(ftpPath, detail.getFileLink(), bakFilePath, sftp);
                                file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
                                if (file.exists()) {
                                    FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)newFileName);
                                    break block15;
                                }
                                BankReceiptDownloadImpl.logger.error("\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6587\u4ef6\u540d\uff1a" + fileName);
                                throw new ReceiptDownLoadException(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6587\u4ef6\u540d\uff1a%s\u3002", (String)"BankReceiptDownloadImpl_5", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]), new Object[]{fileName}));
                            }
                            if (!bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) break block15;
                            bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                            bankReceiptApiUtil.downloadReceiptFile(detail.getFileLink());
                            file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
                            if (!file.exists()) ** GOTO lbl69
                            newFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + newFileName));
                            if (!newFile.exists()) break block16;
                            isDelete = file.delete();
                            BankReceiptDownloadImpl.logger.error("\u6587\u4ef6\u540d\u79f0\uff1a{} \u5220\u9664\u7ed3\u679c\uff1a{} ", new Object[]{file.getName(), isDelete});
                            if (!isLastFile) continue;
                            SFTPUtils.getInstance().close(sftp);
                            continue;
                        }
                        try {
                            result = FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)newFileName);
                            if (!result) {
                                BankReceiptDownloadImpl.logger.error("path:{} {} \u8f6c\u79fb\u6587\u4ef6\u5230 {} \u5931\u8d25", new Object[]{bakFilePath, fileName, newFileName});
                                throw new ReceiptDownLoadException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u91cd\u547d\u540d\u5931\u8d25\uff0c\u539f\u6587\u4ef6:%1$s;\u65b0\u6587\u4ef6\u540d\uff1a%2$s\u3002", (String)"BankReceiptDownloadImpl_6", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]), new Object[]{fileName, newFileName}));
                            }
                            break block15;
lbl69:
                            // 1 sources

                            result = false;
                            BankReceiptDownloadImpl.logger.error("\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6587\u4ef6\u540d\uff1a" + fileName);
                            throw new ReceiptDownLoadException(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6587\u4ef6\u540d\uff1a%s\u3002", (String)"BankReceiptDownloadImpl_5", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]), new Object[]{fileName}));
                        }
                        catch (Exception e) {
                            try {
                                msg = ErrorMsgUtil.getSFTPErrorMSG((String)detail.getFileName(), (String)e.getMessage());
                                isLastFile = true;
                                throw new ReceiptException(msg, (Throwable)e);
                            }
                            catch (Throwable var27_28) {
                                if (isLastFile) {
                                    SFTPUtils.getInstance().close(sftp);
                                }
                                throw var27_28;
                            }
                        }
                    }
                    if (isLastFile) {
                        SFTPUtils.getInstance().close(sftp);
                    }
                    break block18;
                }
                throw new ReceiptDownLoadException(ResManager.loadKDString((String)"\u53d1\u9001\u56de\u5355\u4e0b\u8f7d\u8bf7\u6c42\u5931\u8d25", (String)"BankReceiptDownloadImpl_3", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]));
            }
            resultList.add(detail);
        }
        return BankReceiptHandleResponseEB.success(resultList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CCB_DC_DOWNLOAD";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e2d\u56fd\u5efa\u8bbe\u94f6\u884c\u5916\u8054\u7248\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_4", (String)"ebg-receipt-banks-ccb-dc", (Object[])new Object[0]);
    }
}

