/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccqtgb.dc.service.helper;

import java.time.LocalDate;
import java.util.Date;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.ccqtgb.dc.service.helper.BankCode;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.jdom2.Element;

public class DC_RequestPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DC_RequestPacker.class);

    public static Element createCommonHead(String transCode, String serialNumber) {
        Element element = new Element("Head");
        JDomUtils.addChild((Element)element, (String)"TrsCode", (String)transCode);
        JDomUtils.addChild((Element)element, (String)"ERPTrsTimestamp", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (serialNumber != null && !serialNumber.isEmpty()) {
            JDomUtils.addChild((Element)element, (String)"ERPJnlNo", (String)serialNumber);
        }
        return element;
    }

    public static String getDetailsMessageFYI(BankAcnt bankAcnt, LocalDate startDate, LocalDate endDate) {
        Element message = new Element("Message");
        Element head = DC_RequestPacker.createCommonHead(BankCode.DETAIL_CODE, null);
        Element body = new Element("Body");
        Element list = new Element("List");
        Element map = new Element("Map");
        JDomUtils.addChild((Element)message, (Element)head);
        JDomUtils.addChild((Element)message, (Element)body);
        JDomUtils.addChild((Element)map, (String)"AcNo", (String)bankAcnt.getAccNo());
        JDomUtils.addChild((Element)map, (String)"Currency", (String)bankAcnt.getCurrency());
        JDomUtils.addChild((Element)map, (String)"BeginDate", (String)LocalDateUtil.formatDate((LocalDate)startDate, (String)"yyyy-MM-dd"));
        JDomUtils.addChild((Element)map, (String)"EndDate", (String)LocalDateUtil.formatDate((LocalDate)endDate, (String)"yyyy-MM-dd"));
        JDomUtils.addChild((Element)list, (Element)map);
        JDomUtils.addChild((Element)body, (Element)list);
        return JDomUtils.root2String((Element)message, (String)RequestContextUtils.getCharset());
    }

    public static String receiptDownloadMessageFYI(String accNo, LocalDate transDate, String transSN) {
        Element message = new Element("Message");
        Element head = DC_RequestPacker.createCommonHead(BankCode.RECEIPT_DOWNLOAD_CODE, Sequence.gen18Sequence());
        Element body = new Element("Body");
        Element list = new Element("List");
        Element map = new Element("Map");
        JDomUtils.addChild((Element)message, (Element)head);
        JDomUtils.addChild((Element)message, (Element)body);
        JDomUtils.addChild((Element)map, (String)"AcctNo", (String)accNo);
        JDomUtils.addChild((Element)map, (String)"TransDate", (String)LocalDateUtil.formatDate((LocalDate)transDate, (String)"yyyy-MM-dd"));
        JDomUtils.addChild((Element)map, (String)"TransSN", (String)transSN);
        JDomUtils.addChild((Element)list, (Element)map);
        JDomUtils.addChild((Element)body, (Element)list);
        return JDomUtils.root2String((Element)message, (String)RequestContextUtils.getCharset());
    }
}

