/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccqtgb.dc.service.receipt.api;

import java.io.File;
import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.ccqtgb.dc.service.helper.BankCode;
import kd.ebg.receipt.banks.ccqtgb.dc.service.helper.DC_RequestPacker;
import kd.ebg.receipt.banks.ccqtgb.dc.service.helper.DC_ResponseParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class DownloadFileImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DownloadFileImpl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String accNo = bankReceiptRequest.getAccNo();
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String transNo = bankReceiptRequest.getRequestStr();
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return DC_RequestPacker.receiptDownloadMessageFYI(accNo, transDate, transNo);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String rspStr) {
        EBContext.getContext().setRemoveWriteResponseLog(false);
        String accNo = bankReceiptRequest.getAccNo();
        LocalDate transDate = bankReceiptRequest.getTransDate();
        String transNo = bankReceiptRequest.getRequestStr();
        if (StringUtils.isNotEmpty((String)rspStr) && rspStr.length() < 1000) {
            logger.info("B2EElectronicReceiptDownload\u63a5\u53e3-\u8d26\u53f7\uff1a{}-\u65e5\u671f\uff1a{}-\u6d41\u6c34\u53f7\uff1a{}-\u54cd\u5e94\u6570\u636e:{}", new Object[]{accNo, LocalDateUtil.formatDate((LocalDate)transDate), transNo, rspStr});
        }
        return BankReceiptResponseEB.success((Object)DC_ResponseParser.parserReceiptMessage(rspStr));
    }

    public String getDeveloper() {
        return "LW";
    }

    public String getBizCode() {
        return BankCode.RECEIPT_DOWNLOAD_CODE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u4e0b\u8f7d", (String)"DownloadFileImpl_0", (String)"ebg-receipt-banks-ccqtgb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public static boolean downloadReceiptFile(String bakFilePath, String fileName, String transNo, String accNo, LocalDate transDate) {
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr(transNo).build();
        DownloadFileImpl downloadFile = new DownloadFileImpl();
        BankReceiptResponseEB receiptResponseEB = downloadFile.doBiz(bankReceiptRequest);
        String base64Str = (String)receiptResponseEB.getData();
        StringBuilder fullFilePath = new StringBuilder();
        fullFilePath.append(bakFilePath).append(File.separator).append(fileName);
        return FileCommonUtils.base64ToFile((String)base64Str, (String)fullFilePath.toString());
    }
}

