/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.crcb.dc.service.helper;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class JDOMHelper {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(JDOMHelper.class);
    public static final String XML_HEAR = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public static List<Map<String, Object>> transDetailXmlToList(String resultXml) {
        ArrayList<Map<String, Object>> resDataList = new ArrayList<Map<String, Object>>();
        if (!StringUtils.isEmpty((String)resultXml)) {
            StringReader read = new StringReader(resultXml);
            SAXBuilder builder = new SAXBuilder();
            try {
                Document doc = builder.build((Reader)read);
                Element opResultElement = doc.getRootElement();
                List opResultList = opResultElement.getChildren();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (Element e : opResultList) {
                    if (e == null) continue;
                    if (StringUtils.equals((String)"list", (String)e.getName().toLowerCase())) {
                        Element listElement = opResultElement.getChild(e.getName());
                        List recordList = listElement.getChildren();
                        ArrayList resList = new ArrayList(16);
                        for (Element r : recordList) {
                            HashMap<String, String> rMap = new HashMap<String, String>();
                            List recordChildrenList = r.getChildren();
                            if (recordChildrenList != null) {
                                for (Element c : recordChildrenList) {
                                    rMap.put(c.getName(), c.getText());
                                }
                            }
                            resList.add(rMap);
                        }
                        map.put("resDatas", resList);
                        continue;
                    }
                    map.put(e.getName(), e.getText());
                }
                resDataList.add(map);
            }
            catch (Exception e) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(baos));
                logger.error("" + baos.toString());
            }
        }
        return resDataList;
    }

    public static Map<String, Object> getBodyData(String data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> datas = JDOMHelper.subString(data, "|");
        if (datas.size() >= 4) {
            map.put("sessionId", datas.get(0));
            map.put("serialNo", datas.get(1));
            map.put("retCode", datas.get(2));
            map.put("errorMsg", datas.get(3));
        } else if (datas.size() > 2) {
            map.put("sessionId", datas.get(0));
            map.put("retCode", datas.get(1));
            map.put("errorMsg", datas.get(2));
        }
        if (data.indexOf("opResult") == -1) {
            return map;
        }
        String subXML = XML_HEAR + data.substring(data.indexOf("<opResult>"), data.indexOf("</opResult>") + 11);
        List<Map<String, Object>> resDataList = JDOMHelper.transDetailXmlToList(subXML);
        map.put("res", resDataList);
        return map;
    }

    public static ArrayList<String> subString(String data, String delim) {
        String target = data;
        int end = 0;
        ArrayList<String> list = new ArrayList<String>(16);
        while ((end = target.indexOf(delim)) != -1) {
            list.add(target.substring(0, end));
            target = target.substring(end + 1);
        }
        return list;
    }

    public static String requestMessageFYIEncrypt(Map<String, Object> map, String reuqestNo) {
        XMLOutputter out = new XMLOutputter();
        Element rootElement = new Element("ReqParam");
        Document document = new Document(rootElement);
        String xmlStr = "";
        if (!StringUtils.isEmpty((String)reuqestNo) && map != null) {
            if (StringUtils.equals((String)"CL0001", (String)reuqestNo)) {
                Element sIdElement = new Element("systemId").setText("");
                rootElement.addContent((Content)sIdElement);
                for (Map.Entry<String, Object> h : map.entrySet()) {
                    rootElement.addContent((Content)new Element(h.getKey()).addContent(h.getValue() != null ? h.getValue().toString() : ""));
                }
            } else {
                for (Map.Entry<String, Object> h : map.entrySet()) {
                    rootElement.addContent((Content)new Element(h.getKey()).addContent(h.getValue() != null ? h.getValue().toString() : ""));
                }
            }
            xmlStr = out.outputString(document);
            xmlStr = xmlStr.substring(xmlStr.indexOf("<ReqParam>"), xmlStr.indexOf("</ReqParam>") + "</ReqParam>".length());
            return xmlStr;
        }
        return null;
    }

    public static String requestHttpMessage(String header, String encryptStr, String reqMessage) {
        String xmlStr = "";
        try {
            XMLOutputter out = new XMLOutputter();
            Element rootElement = new Element("CQRCBBankData");
            Document document = new Document(rootElement);
            if (!(StringUtils.isEmpty((String)header) || StringUtils.isEmpty((String)encryptStr) || StringUtils.isEmpty((String)reqMessage))) {
                Element opReqElement = new Element("opReq");
                rootElement.addContent((Content)opReqElement);
                Element signDataElement = new Element("signData");
                signDataElement.addContent(encryptStr);
                rootElement.addContent((Content)signDataElement);
            }
            xmlStr = out.outputString(document);
            xmlStr = xmlStr.replace("<opReq />", "<opReq></opReq>");
            StringBuilder tmp = new StringBuilder(xmlStr);
            tmp.insert(xmlStr.indexOf("<opReq>") + "<opReq>".length(), reqMessage);
            xmlStr = tmp.toString();
            xmlStr = xmlStr.replaceAll("\r\n", "");
            xmlStr = header + xmlStr;
        }
        catch (Exception e) {
            logger.error("\u7ec4\u88c5\u62a5\u6587\u5931\u8d25", (Throwable)e);
        }
        return xmlStr;
    }
}

