/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bod.cmp.service;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.receipt.banks.bod.cmp.service.api.DetailImpl;
import kd.ebg.receipt.banks.bod.cmp.service.api.ReceiptRequestImpl;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    private static final String RECEIPTSEPERATOR = "_";

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDate + "\n");
        BankAcnt acnt = new BankAcnt();
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        acnt.setAccNo(accNo);
        acnt.setCurrency(bankCurrency);
        BankDetailRequest req = this.buildDetailRequest(acnt, transDate);
        EBBankDetailResponse detailResponse = new DetailImpl().doBiz(req);
        List details = detailResponse.getDetails();
        for (DetailInfo detail : details) {
            BankReceiptResponseEB responseEB = new ReceiptRequestImpl().doBiz(this.buildReceiptRequest(accNo, transDate, detail.getReceiptNo()));
            if (!Objects.nonNull(responseEB.getData())) continue;
            String fileName = (String)responseEB.getData();
            String newFileName = accNo + RECEIPTSEPERATOR + transDateStr + RECEIPTSEPERATOR + detail.getReceiptNo() + ".pdf";
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileName(newFileName);
            downloadListDetail.setFileLink(fileName);
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public BankDetailRequest buildDetailRequest(BankAcnt acnt, LocalDate localDate) {
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        header.setAcnt(acnt);
        request.setHeader(header);
        request.setStartDate(localDate);
        request.setEndDate(localDate);
        return request;
    }

    public BankReceiptRequest buildReceiptRequest(String accNo, LocalDate localDate, String serialNo) {
        return BankReceiptRequest.builder().accNo(accNo).transDate(localDate).requestStr(serialNo).build();
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BankReceiptFetchListAndDownloadTheList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-arcu-dc", (Object[])new Object[0]);
    }
}

