/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bod.cmp.service.api;

import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.bod.cmp.service.api.ProxyDownload;
import kd.ebg.receipt.banks.bod.cmp.service.utils.Packer;
import kd.ebg.receipt.banks.bod.cmp.service.utils.Parser;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);
    private static final String CIRCLE_STR = "|";

    public String pack(BankDetailRequest request) {
        Element root = Packer.createHead("200110");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getAcnt().getCurrency());
        JDomUtils.addChild((Element)body, (String)"start_date", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String xmlMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlMessage);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        String data;
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(16);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parserHead(root);
        if (!"0".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u54cd\u5e94\u7801\uff1a%1$s\uff0c\u54cd\u5e94\u4fe1\u606f\uff1a%2$s\u3002", (String)"DetailImpl_0", (String)"ebg-receipt-banks-bod-cmp", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element head = root.getChild("head");
        Element body = root.getChild("body");
        if (null == body || null == body.getChildren() || body.getChildren().isEmpty()) {
            return new EBBankDetailResponse(totalList);
        }
        String file_flag = head.getChildTextTrim("file_flag");
        log.info("\u4ea4\u6613\u660e\u7ec6\u8fd4\u56defile_flag:\u4e3a" + file_flag);
        int record_num = Integer.parseInt(body.getChildTextTrim("record_num"));
        int field_num = Integer.parseInt(body.getChildTextTrim("field_num"));
        if (0 == record_num) {
            return new EBBankDetailResponse(totalList);
        }
        if ("0".equalsIgnoreCase(file_flag)) {
            data = body.getChildTextTrim("serial_record");
        } else {
            String fileName = body.getChildTextTrim("file_name");
            String charsetName = EBContext.getContext().getCharsetName();
            EBContext.getContext().setCharsetName("UTF-8");
            BankReceiptResponseEB responseEB = new ProxyDownload().doBiz(BankReceiptRequest.builder().accNo(request.getAcnt().getAccNo()).transDate(request.getStartDate()).requestStr(fileName).build());
            data = (String)responseEB.getData();
            EBContext.getContext().setCharsetName(charsetName);
        }
        String[] fields = StringUtils.split((String)data, (String)CIRCLE_STR);
        for (int i = 1; i <= record_num; ++i) {
            DetailInfo detailInfo = new DetailInfo();
            String serialNo = fields[i * field_num];
            detailInfo.setReceiptNo(serialNo);
            totalList.add(detailInfo);
        }
        return new EBBankDetailResponse(totalList);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "200110";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_1", (String)"ebg-receipt-banks-bod-cmp", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
        factory.setUri("/e2bproxy/service.action");
    }

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg(super.recv(inputStream));
    }
}

