/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.fjnxs.dc.service.api;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.fjnxs.dc.BankBusinessConfig;
import kd.ebg.receipt.banks.fjnxs.dc.utils.EBUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import org.jdom2.Element;

public class B2EBillList
extends AbstractBankReceiptImpl
implements IBankReceipt {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EBillList";
    }

    public String getBizDesc() {
        return "";
    }

    public String pack(BankReceiptRequest rqst) {
        String accNo = rqst.getAccNo();
        Element message = new Element("Message");
        JDomUtils.addChild((Element)message, (Element)EBUtils.buildPackerHead(this.getBizCode(), Sequence.gen18Sequence()));
        Element body = JDomUtils.addChild((Element)message, (String)"Body");
        String groupAccount = BankBusinessConfig.getGroupAccount(accNo);
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)groupAccount);
        JDomUtils.addChild((Element)body, (String)"QryAcNo", (String)accNo);
        String txDate = rqst.getTransDate().format(EBUtils.dateTimeFormatter);
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)txDate);
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)txDate);
        JDomUtils.addChild((Element)body, (String)"TransType", (String)rqst.getRequestStr());
        return JDomUtils.root2String((Element)message, (String)RequestContextUtils.getCharset());
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        Element ebenk = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse rsp = EBUtils.parserResponseInfo(ebenk);
        if ("000000".equals(rsp.getResponseCode())) {
            Element body = ebenk.getChild("Body");
            Element list = body.getChild("List");
            if (Objects.isNull(list)) {
                return BankReceiptResponseEB.success();
            }
            List data = list.getChildren("Map");
            if (CollectionUtil.isEmpty((Collection)data)) {
                return BankReceiptResponseEB.success();
            }
            ArrayList<JSONObject> bills = new ArrayList<JSONObject>(8);
            for (Element datum : data) {
                JSONObject bill = new JSONObject();
                String billNo = datum.getChildText("BillNo");
                String transSeqNo = datum.getChildText("TransSeqNo");
                String subTranNo = datum.getChildText("SubTranNo");
                String amount = datum.getChildText("Amount");
                bill.put("BillNo", (Object)billNo);
                bill.put("TransSeqNo", (Object)transSeqNo);
                bill.put("SubTranNo", (Object)subTranNo);
                bill.put("Amount", (Object)amount);
                bills.add(bill);
            }
            return BankReceiptResponseEB.success(bills);
        }
        throw EBExceiptionUtil.serviceException((String)(rsp.getResponseMessage() + (StringUtils.isNotEmpty((String)rsp.getResponseMessage()) ? "\uff0c" : "") + rsp.getResponseCode()));
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eweb/B2EBillList.do?userPassword=" + RequestContextUtils.getBankParameterValue((String)"cif") + "&SIGDATA=1";
        factory.setUri(s);
    }
}

