/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.njb.dc.service.receipt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.receipt.banks.njb.dc.service.receipt.NjbDcFileParser;
import kd.ebg.receipt.banks.njb.dc.service.receipt.api.DownloadBankReceiptImpl;
import kd.ebg.receipt.banks.njb.dc.service.receipt.api.SearchBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean isBreak() {
        return true;
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        logger.info("\u5f53\u524d\u4f4d\u7f6e\u5357\u4eac\u94f6\u884cFecthList");
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDate + "\n");
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        if (downloadListDetails.size() > 0) {
            DownloadListDetail downloadListDetail = (DownloadListDetail)downloadListDetails.get(0);
            NjbDcFileParser njbDcFileParser = new NjbDcFileParser();
            njbDcFileParser.setFileName(downloadListDetail.getFileName());
            int length = njbDcFileParser.getFileSplitLength();
            if (length == 5) {
                List ids = downloadListDetails.stream().map(o -> o.getId()).collect(Collectors.toList());
                this.downloadListDetailService.deleteAll(ids);
            }
        }
        try {
            BankAcnt acnt = new BankAcnt();
            BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
            String currency = mainAcnt.getCurrency();
            String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
            acnt.setAccNo(accNo);
            acnt.setCurrency(bankCurrency);
            JSONArray jsonArray = this.sendAndReceiveReceipt(accNo, transDate, acnt);
            if (jsonArray.isEmpty()) {
                throw new ReceiptException(ResManager.loadKDString((String)"800190\u63a5\u53e3\u83b7\u53d6\u7684\u56de\u5355\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-njb-dc", (Object[])new Object[0]));
            }
            for (int i = 0; i < jsonArray.size(); ++i) {
                StringBuilder fileName = new StringBuilder();
                JSONObject item = jsonArray.getJSONObject(i);
                DownloadListDetail downloadListDetail = new DownloadListDetail();
                String bankReceiptFileName = this.sendCreateReceiptReq(item, acnt, transDate);
                logger.info("\u7b2c" + i + "\u6761\u94f6\u884c\u8fd4\u56de\u7684\u56de\u5355\u540d\u662f" + bankReceiptFileName);
                String hostSerialNo = item.getString("host_serial_no");
                String trans_amt = item.getString("trans_amt");
                String crdr_flag = item.getString("crdr_flag");
                String trans_no = item.getString("trans_no");
                fileName.append(hostSerialNo).append("_").append(transDate).append("_").append(accNo).append("_").append(trans_amt).append("_").append(crdr_flag).append("_").append(trans_no).append(".pdf");
                downloadListDetail.setFileName(fileName.toString());
                downloadListDetail.setFileLink(bankReceiptFileName);
                result.add(downloadListDetail);
            }
            logger.info(">>>>>>>>>>>>\u5357\u4eac\u94f6\u884c{}-{}-\u56de\u5355\u8bb0\u5f55\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, result.size()});
            if (result.isEmpty()) {
                throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-njb-dc", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.info("\u5357\u4eac\u94f6\u884c\u83b7\u53d6\u56de\u5355\u5217\u8868\u51fa\u73b0\u5f02\u5e38{}", (Object)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        logger.info(">>>>>>>>>\u5357\u4eac\u94f6\u884c-FETCH-{}-{}-\u56de\u5355\u8bb0\u5f55\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, result.size()});
        return BankReceiptHandleResponseEB.success(result);
    }

    private JSONArray sendAndReceiveReceipt(String accNo, LocalDate localDate, BankAcnt acnt) {
        String bankLoginID = EBContext.getContext().getBankLoginID();
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(accNo).transDate(localDate).build();
        BankHeader bankHeader = new BankHeader();
        bankHeader.setAcnt(acnt);
        bankHeader.setBankLoginID(bankLoginID);
        request.setHeader(bankHeader);
        SearchBankReceiptImpl bankReceipt = new SearchBankReceiptImpl();
        return bankReceipt.process(request);
    }

    private String sendCreateReceiptReq(JSONObject obj, BankAcnt acnt, LocalDate transDate) {
        logger.info("\u5373\u5c06\u7528\u4e8e\u8bf7\u6c42\u7684\u56de\u5355\u6570\u636e\u662f" + obj.toJSONString());
        String bankLoginID = EBContext.getContext().getBankLoginID();
        Map paramMap = (Map)obj.toJavaObject(Map.class);
        BankReceiptRequest req = BankReceiptRequest.builder().accNo(acnt.getAccNo()).transDate(transDate).paramsMap(paramMap).build();
        BankHeader bankHeader = new BankHeader();
        bankHeader.setAcnt(acnt);
        bankHeader.setBankLoginID(bankLoginID);
        req.setHeader(bankHeader);
        DownloadBankReceiptImpl download = new DownloadBankReceiptImpl();
        BankReceiptResponseEB resp = download.doBiz(req);
        return (String)resp.getData();
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "NJB_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-njb-dc", (Object[])new Object[0]);
    }
}

