/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.dlb.dc.service.receipt.util;

import com.jcraft.jsch.ChannelSftp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.ErrorMsgUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import org.jdom2.Element;

public class ReceiptParser {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(ReceiptParser.class);

    public static List<String> detailParser(DownloadListTask task, String response) {
        if ("".equals(response)) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a", (String)"ReceiptParser_0", (String)"ebg-receipt-banks-dlb-dc", (Object[])new Object[0]));
        }
        ArrayList<String> host_serial_no_list = new ArrayList(16);
        Element root = JDomExtUtils.str2DocGBK((String)response.substring(12)).getRootElement();
        Element head = JDomExtUtils.getChildElement((Element)root, (String)"head");
        String succ_flag = JDomUtils.getUnNullChildElement((Element)head, (String)"succ_flag").getTextTrim();
        if (!"0".equalsIgnoreCase(succ_flag)) {
            if ("8".equalsIgnoreCase(succ_flag)) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u672a\u77e5\uff0c\u9700\u8981\u67e5\u8bc1\u5904\u7406\uff1a%s\u3002", (String)"ReceiptParser_9", (String)"ebg-receipt-banks-dlb-dc", (Object[])new Object[0]), response));
            }
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff1a", (String)"ReceiptParser_2", (String)"ebg-receipt-banks-dlb-dc", (Object[])new Object[0]), response));
        }
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"body");
        String file_name = JDomUtils.getUnNullChildElement((Element)body, (String)"file_name").getTextTrim();
        host_serial_no_list = ReceiptParser.fileDownloadAndparse(task, file_name);
        return host_serial_no_list;
    }

    public static Map<String, String> receiptParser(String response) {
        if (response.equals("")) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a", (String)"ReceiptParser_0", (String)"ebg-receipt-banks-dlb-dc", (Object[])new Object[0]));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Element root = JDomExtUtils.str2DocGBK((String)response.substring(12)).getRootElement();
        Element head = JDomExtUtils.getChildElement((Element)root, (String)"head");
        String succ_flag = JDomUtils.getUnNullChildElement((Element)head, (String)"succ_flag").getTextTrim();
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"body");
        String pay_acno = JDomUtils.getUnNullChildElement((Element)body, (String)"pay_acno").getTextTrim();
        String tr_acdt = JDomUtils.getUnNullChildElement((Element)body, (String)"tr_acdt").getTextTrim();
        String host_serial_no = JDomUtils.getUnNullChildElement((Element)body, (String)"host_serial_no").getTextTrim();
        String rcv_acno = JDomUtils.getUnNullChildElement((Element)body, (String)"rcv_acno").getTextTrim();
        String amt = JDomUtils.getUnNullChildElement((Element)body, (String)"amt").getTextTrim();
        String crdr_flag = JDomUtils.getUnNullChildElement((Element)body, (String)"crdr_flag").getTextTrim();
        String ReportFileFlag = JDomUtils.getUnNullChildElement((Element)body, (String)"ReportFileFlag").getTextTrim();
        String ErrInfo = JDomUtils.getUnNullChildElement((Element)body, (String)"ErrInfo").getTextTrim();
        String ReportFileName = JDomUtils.getUnNullChildElement((Element)body, (String)"ReportFileName").getTextTrim();
        if ("0".equalsIgnoreCase(succ_flag)) {
            if ("0".equalsIgnoreCase(ReportFileFlag)) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u751f\u6210\u6587\u4ef6\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"ReceiptParser_10", (String)"ebg-receipt-banks-dlb-dc", (Object[])new Object[0]), ErrInfo));
            }
        } else {
            if ("8".equalsIgnoreCase(succ_flag)) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u672a\u77e5\uff0c\u9700\u8981\u67e5\u8bc1\u5904\u7406\uff1a%s\u3002", (String)"ReceiptParser_9", (String)"ebg-receipt-banks-dlb-dc", (Object[])new Object[0]), response));
            }
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff1a%s\u3002", (String)"ReceiptParser_11", (String)"ebg-receipt-banks-dlb-dc", (Object[])new Object[0]), response));
        }
        map.put("pay_acno", pay_acno);
        map.put("tr_acdt", tr_acdt);
        map.put("host_serial_no", host_serial_no);
        map.put("rcv_acno", rcv_acno);
        map.put("amt", amt);
        map.put("crdr_flag", crdr_flag);
        map.put("ReportFileName", ReportFileName);
        return map;
    }

    public static List<String> fileDownloadAndparse(DownloadListTask task, String file_name) {
        List<String> host_serial_no_list = new ArrayList<String>();
        boolean downloadFlag = false;
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, task.getBankLoginId());
        String ftpPath = bankFtpProperties.getFtpPath();
        String localPath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"DLB_DC", (String)task.getAccNo(), (String)task.getTransDate().toString());
        String tempPath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"DLB_DC", (String)task.getAccNo(), (String)task.getTransDate().toString());
        log.info("\u5927\u8fde\u94f6\u884c\u51c6\u5907\u53bb\u670d\u52a1\u5668\u4e0b\u8f7d\u6982\u8981\u6587\u4ef6:" + file_name);
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            downloadFlag = ReceiptParser.ftpDownload(StringUtils.isEmpty((String)ftpPath) ? "/" : ftpPath, file_name, tempPath, task.getBankLoginId());
        } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
            BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(task.getAccNo(), task.getTransDate());
            downloadFlag = bankReceiptApiUtil.downloadReceiptFile(file_name, tempPath);
        }
        if (downloadFlag) {
            log.info("\u4e0b\u8f7d\u6587\u4ef6" + file_name + "\u6210\u529f..");
            File sourceFile = FileCommonUtils.getFileByPath((String)(tempPath + File.separator + file_name));
            host_serial_no_list = ReceiptParser.parseFileContent(sourceFile);
        }
        return host_serial_no_list;
    }

    private static boolean ftpDownload(String ftpPath, String orgFileName, String destFolder, String bankLogin) {
        ChannelSftp sftp = null;
        boolean downloadFlag = false;
        try {
            Vector vector = new Vector();
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp(bankLogin);
                vector = sftp.ls(ftpPath);
            }
            if (Objects.nonNull(vector) && vector.size() > 0) {
                for (Object o : vector) {
                    ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)o;
                    if (!file.getFilename().equals(orgFileName)) continue;
                    downloadFlag = SFTPUtils.getInstance().downloadSingleFile(ftpPath, orgFileName, destFolder, sftp);
                }
            }
        }
        catch (Exception e) {
            try {
                String msg = ErrorMsgUtil.getSFTPErrorMSG((String)"", (String)e.getMessage());
                throw new ReceiptException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                SFTPUtils.getInstance().close(sftp);
                throw throwable;
            }
        }
        SFTPUtils.getInstance().close(sftp);
        return downloadFlag;
    }

    private static List<String> parseFileContent(File sourceFile) {
        ArrayList<String> list;
        block22: {
            list = new ArrayList<String>(16);
            String fileContent = "";
            if (sourceFile.exists()) {
                try (FileInputStream totalFileStream = new FileInputStream(sourceFile);){
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)totalFileStream, "GBK"));
                    int index = 0;
                    while ((fileContent = bufferedReader.readLine()) != null) {
                        if (index == 0) {
                            ++index;
                            continue;
                        }
                        String host_serial_no = fileContent.split("\\|")[6];
                        list.add(host_serial_no);
                    }
                    log.info("\u8bfb\u53d6\u6982\u8981\u6587\u4ef6" + sourceFile + "\u5b8c\u6210");
                    break block22;
                }
                catch (Exception e) {
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u6982\u8981\u6587\u4ef6%s\u5f02\u5e38", (String)"ReceiptParser_12", (String)"ebg-receipt-banks-dlb-dc", (Object[])new Object[0]), sourceFile), (Throwable)e);
                }
                finally {
                    boolean delete = sourceFile.delete();
                    if (!sourceFile.exists() && delete) {
                        log.info("\u6982\u8981\u6587\u4ef6" + sourceFile + "\u5220\u9664\u6210\u529f");
                    }
                }
            }
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6982\u8981\u6587\u4ef6%s\u4e0d\u5b58\u5728\u3002\u8bf7\u548c\u94f6\u884c\u786e\u8ba4\u63a8\u9001\u8def\u5f84\uff0c\u548c\u94f6\u884c\u662f\u5426\u63a8\u9001\u6587\u4ef6\u3002", (String)"ReceiptParser_13", (String)"ebg-receipt-banks-dlb-dc", (Object[])new Object[0]), sourceFile));
        }
        if (list.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u6982\u8981\u6587\u4ef6\u4e3a\u7a7a,\u65e0\u4ea4\u6613\u660e\u7ec6.", (String)"ReceiptParser_8", (String)"ebg-receipt-banks-dlb-dc", (Object[])new Object[0]));
        }
        return list;
    }
}

