/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cdb.ccip.service.receipt.api;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.receipt.banks.cdb.ccip.service.util.CDBBankResponse;
import kd.ebg.receipt.banks.cdb.ccip.service.util.CommonPacker;
import kd.ebg.receipt.banks.cdb.ccip.service.util.CommonParser;
import kd.ebg.receipt.banks.cdb.ccip.service.util.LoginUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class BankReceiptDownloadRequestImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadRequestImpl.class);

    public String pack(BankReceiptRequest bankReceiptRequest) {
        LoginUtils.getInstance().doBiz();
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader(this.getBizCode(), Sequence.genSequence());
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity("O0220001", Sequence.genSequence());
        body.addContent((Content)request);
        JDomExtUtils.addChildCDData((Element)request, (String)"Pgg_Seq_TpCd", (String)"0000000002");
        List downloadReceiptNos = (List)bankReceiptRequest.getParamsMap().get("downloadReceiptNos");
        for (String receiptNo : downloadReceiptNos) {
            Element vchIdGrp = new Element("Hd_Prt_Grp");
            Element vchID = new Element("VchID");
            vchID.addContent(receiptNo);
            vchIdGrp.addContent((Content)vchID);
            request.addContent((Content)vchIdGrp);
        }
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        responseStr = CommonParser.preParse(responseStr);
        logger.info("(P1CCMS006)\u56de\u5355\u8bb0\u5f55\u67e5\u8be2\u8fd4\u56de\u62a5\u6587\uff1a" + responseStr);
        CDBBankResponse bankResp = CommonParser.getBankPreResponse(responseStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u94f6\u884c\u8fd4\u56de\u5931\u8d25\u3002%s", (String)"BankReceiptDownloadRequestImpl_0", (String)"ebg-receipt-banks-cdb-ccip", (Object[])new Object[0]), bankResp.getResponseCode(), bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        Element fileListPack = JDomExtUtils.getChildElement((Element)response, (String)"FILE_LIST_PACK");
        String fileNumStr = JDomExtUtils.getChildText((Element)fileListPack, (String)"FILE_NUM");
        List fileInfo = fileListPack.getChildren("FILE_INFO");
        String acctulySize = fileInfo.size() + "";
        if (!acctulySize.equals(fileNumStr)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u6587\u4ef6\u4fe1\u606f\u8282\u70b9\u683c\u5f0f\u4e0d\u5339\u914d\uff0c\u63cf\u8ff0\u4e3a\uff1a%1$s\u4e2a\uff0c\u5b9e\u9645\u4e3a\uff1a%2$s\u4e2a\u3002", (String)"BankReceiptDownloadRequestImpl_1", (String)"ebg-receipt-banks-cdb-ccip", (Object[])new Object[0]), fileNumStr, acctulySize));
        }
        ArrayList<ReceiptInfo> fileNames = new ArrayList<ReceiptInfo>(1);
        for (Element node : fileInfo) {
            String fileName = JDomExtUtils.getChildText((Element)node, (String)"FILE_NAME");
            ReceiptInfo receiptInfo = new ReceiptInfo();
            receiptInfo.setFilePath(fileName);
            fileNames.add(receiptInfo);
        }
        return BankReceiptResponseEB.success(fileNames);
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "P1CCMS006";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56de\u5355\u4e0b\u8f7d\u63a5\u53e3\u8bf7\u6c42", (String)"BankReceiptDownloadRequestImpl_2", (String)"ebg-receipt-banks-cdb-ccip", (Object[])new Object[0]);
    }
}

