/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ccb.ccip.service.receipt;

import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.CCBCCIPCommConfig;
import kd.ebg.receipt.banks.ccb.ccip.service.receipt.message.RequestUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String bankLoginId = request.getBankLoginId();
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        boolean isLastFile = false;
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            DownloadListDetail downloadListDetail;
            if (i == downloadListDetails.size() - 1) {
                isLastFile = true;
            }
            if ((downloadListDetail = (DownloadListDetail)downloadListDetails.get(i)).getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                result.add(downloadListDetail);
                continue;
            }
            List<DownloadListDetail> details = this.download(downloadListDetail, isLastFile, bankLoginId);
            result.addAll(details);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> download(DownloadListDetail detail, boolean isLastFile, String bankLoginId) {
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        boolean isPushed = ((CCBCCIPCommConfig)EBConfigBuilder.getInstance().buildConfig(CCBCCIPCommConfig.class, bankLoginId)).getCcipPushMode().equals("true");
        if (!isPushed) {
            result.addAll(this.download_proxyMode(detail));
        } else {
            result.add(detail);
        }
        return result;
    }

    public List<DownloadListDetail> download_proxyMode(DownloadListDetail detail) {
        ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>(16);
        String bankVersionId = detail.getBankVersionId();
        String accNo = detail.getAccNo();
        LocalDate transDate = detail.getTransDate();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        boolean flag = false;
        String filePath = bakFilePath + File.separator + detail.getFileName();
        if (!FileCommonUtils.getFileByPath((String)filePath).exists()) {
            String requestStr = RequestUtil.getDownloadFileRequestStr(detail.getFileLink());
            String rsp = RequestUtil.sendFileReq2Proxy(requestStr);
            if (rsp != null && !rsp.isEmpty()) {
                byte[] fileBytes = RequestUtil.hexStr2Byte(rsp);
                flag = FileCommonUtils.write2File((byte[])fileBytes, (String)filePath);
                logger.info("\u5efa\u8bbe\u94f6\u884c\u73b0\u91d1\u76f4\u8fde\u7248\u56de\u5355\u4e0b\u8f7d\u4fdd\u5b58\u662f\u5426\u6210\u529f\uff1a{} \u6587\u4ef6\u76ee\u5f55\uff1a{}", new Object[]{flag, filePath});
                if (flag) {
                    detail.setBankFilePath(filePath);
                    detailList.add(detail);
                }
            }
        } else {
            detail.setBankFilePath(filePath);
            detailList.add(detail);
        }
        return detailList;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CCB_CCIP_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5efa\u8bbe\u94f6\u884c\u73b0\u91d1\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-ccb-ccip", (Object[])new Object[0]);
    }
}

