/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.bank.meta.template;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.constant.PropertiesOptions;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.model.bank.ShowByFieldAndVal;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.receipt.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.receipt.common.framework.bank.meta.BankMetaDataInfo;
import kd.ebg.receipt.common.framework.bank.meta.BankVersionMetaInfo;
import kd.ebg.receipt.common.framework.properties.BankPropertyConfig;
import kd.sdk.annotation.SdkDeprecated;

public abstract class OPAMetaDataTemplate
extends BankMetaDataInfo
implements BankMetaDataCollector {
    private String protocol = "https";
    private int timeout = 3;
    private String charset = "GBK";
    private String uri = "";
    public static String ZBankCipher = "z_bank_pwd";
    public static String PrivateKey = "private_key";
    public static String PrivateKeySecret = "private_key_secret";
    public static String PublicKey = "public_key";
    public static String PublicKeySecret = "public_key_secret";

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public BankVersionMetaInfo getBankVersionMetaInfo() {
        this.metaDataInit();
        String key = this.bankShortName + "_concurrentCount";
        int concurrentCount = 0;
        try {
            int temp;
            if (!StringUtils.isEmpty((String)ConfigurationUtil.getString((String)key)) && (temp = Integer.parseInt(ConfigurationUtil.getString((String)key))) != concurrentCount) {
                concurrentCount = temp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BankVersionMetaInfo.builder().bankShortName(this.bankShortName).bankName(this.bankName).bankVersionID(this.bankVersionID).bankVersionName(this.bankVersionName).description(this.description).keyNames(this.keyNames).isSupportReconciliation(this.isSupportReconciliation).isReconciliationOfAccNo(this.isReconciliationOfAccNo).concurrentCount(concurrentCount).build();
    }

    @Override
    @SdkDeprecated
    public List<BankLoginConfig> getBankLoginConfig() {
        this.baseConfigInit();
        ArrayList<BankLoginConfig> bankLoginConfig = new ArrayList<BankLoginConfig>(16);
        List<BankLoginConfig> configs = this.getBankFrontConfig();
        for (BankLoginConfig bankLoginConfig2 : configs) {
            bankLoginConfig2.setType(MetaDataConfigType.BASE_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getBankLoginExtraConfig();
        for (BankLoginConfig bankLoginConfig3 : configs) {
            bankLoginConfig3.setType(MetaDataConfigType.EXTRA_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getBankPGPConfig();
        for (BankLoginConfig bankLoginConfig4 : configs) {
            bankLoginConfig4.setType(MetaDataConfigType.PGP_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getBankLoginReceiptBaseConfig();
        boolean isShowOFDSignConfig = false;
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.RECEIPT_CONFIG.getName());
            if (!Objects.equals(config.getKey().getBankConfigId(), "isCheckOFDSign")) continue;
            isShowOFDSignConfig = true;
        }
        if (this.isSupportProxyDownload) {
            BankLoginConfig bankLoginConfig5 = BankLoginConfigUtil.getMlBankLoginConfig((String)"receipt_proxy_download_switch", (MultiLangEnumBridge)new MultiLangEnumBridge("\u662f\u5426\u901a\u8fc7\u524d\u7f6e\u673a\u4ee3\u7406\u83b7\u53d6", "OPAMetaDataTemplate_29", "ebg-receipt-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5efa\u8bae\u516c\u6709\u4e91\u5ba2\u6237\u4f7f\u7528\uff0c\u9700\u8981\u5728\u524d\u7f6e\u673a\u670d\u52a1\u5668\u4e0a\u90e8\u7f72\u91d1\u8776\u4ee3\u7406\u7a0b\u5e8f\u3002", "OPAMetaDataTemplate_30", "ebg-receipt-common"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{PropertiesOptions.YES_NAME, PropertiesOptions.NO_NAME}), (List)Lists.newArrayList((Object[])new String[]{"true", "false"}), (String)"false", (boolean)false, (boolean)false, (boolean)false);
            bankLoginConfig5.setType(MetaDataConfigType.RECEIPT_CONFIG.getName());
            bankLoginConfig.add(bankLoginConfig5);
            BankLoginConfig receiptProxyFileConfig = BankLoginConfigUtil.getMlBankLoginConfig((String)"receipt_proxy_file_port", (MultiLangEnumBridge)new MultiLangEnumBridge("\u7535\u5b50\u56de\u5355\u6587\u4ef6\u670d\u52a1\u7aef\u53e3", "OPAMetaDataTemplate_31", "ebg-receipt-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u91d1\u8776\u4ee3\u7406\u7a0b\u5e8f\u4e2d\u7684\u7535\u5b50\u56de\u5355\u6587\u4ef6\u670d\u52a1\u7aef\u53e3\uff0c\u9700\u8981\u9996\u5148\u5728\u524d\u7f6e\u673a\u4e0a\u5b89\u88c5\u91d1\u8776\u4ee3\u7406\u7a0b\u5e8f\u3002", "OPAMetaDataTemplate_32", "ebg-receipt-common"), (String)this.port, (boolean)false, (boolean)false).set2Integer().set2MaxValueNum(65535);
            receiptProxyFileConfig.setShowByFieldAndVal(new ShowByFieldAndVal("receipt_proxy_download_switch", "true"));
            bankLoginConfig.add(receiptProxyFileConfig);
        }
        if (this.isShowOFDSignConfig() && !isShowOFDSignConfig) {
            BankLoginConfig bankLoginConfig6 = BankLoginConfigUtil.getMlBankLoginConfig((String)"isCheckOFDSign", (MultiLangEnumBridge)new MultiLangEnumBridge("\u662f\u5426\u5bf9OFD\u56de\u5355\u53ca\u5bf9\u8d26\u5355\u6587\u4ef6\u9a8c\u7b7e", "OPAMetaDataTemplate_26", "ebg-receipt-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u9ed8\u8ba4\u9700\u8981\u9a8c\u7b7e\uff0c\u9009\u62e9\u5426\u65f6\u5173\u95ed\u9a8c\u7b7e\u529f\u80fd\u3002", "OPAMetaDataTemplate_27", "ebg-receipt-common"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{PropertiesOptions.YES_NAME, PropertiesOptions.NO_NAME}), (List)Lists.newArrayList((Object[])new String[]{"true", "false"}), (String)"true", (boolean)false, (boolean)false, (boolean)false);
            bankLoginConfig6.setType(MetaDataConfigType.RECEIPT_CONFIG.getName());
            configs.add(bankLoginConfig6);
        }
        bankLoginConfig.addAll(configs);
        if (this.isSupportReconciliation) {
            configs = this.getReconciliationConfig();
            for (BankLoginConfig config : configs) {
                config.setType(MetaDataConfigType.RECONCILIATION_CONFIG.getName());
            }
            bankLoginConfig.addAll(configs);
        }
        return bankLoginConfig;
    }

    public List<BankLoginConfig> getBankFrontConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getBankLoginConfig((String)"ip", (String)ResManager.loadKDString((String)"\u670d\u52a1\u7f51\u5173\u5730\u5740", (String)"OPAMetaDataTemplate_0", (String)"ebg-receipt-common", (Object[])new Object[0]), (String)this.host, (boolean)false, (boolean)false), BankLoginConfigUtil.getBankLoginConfig((String)"exchangePort", (String)ResManager.loadKDString((String)"\u670d\u52a1\u7aef\u53e3", (String)"OPAMetaDataTemplate_1", (String)"ebg-receipt-common", (Object[])new Object[0]), (String)this.port, (boolean)false, (boolean)false), BankLoginConfigUtil.getBankLoginConfig((String)"exchangeUri", (String)ResManager.loadKDString((String)"\u670d\u52a1uri\u5730\u5740", (String)"OPAMetaDataTemplate_2", (String)"ebg-receipt-common", (Object[])new Object[0]), (String)this.uri, (boolean)false, (boolean)true), BankLoginConfigUtil.getBankLoginConfig((String)"exchangeProtocol", (String)ResManager.loadKDString((String)"\u901a\u8baf\u534f\u8bae", (String)"OPAMetaDataTemplate_3", (String)"ebg-receipt-common", (Object[])new Object[0]), (String)this.protocol).set2ReadOnly(), BankLoginConfigUtil.getBankLoginConfig((String)"timeout", (String)ResManager.loadKDString((String)"\u8d85\u65f6\u8bbe\u7f6e(min)", (String)"OPAMetaDataTemplate_4", (String)"ebg-receipt-common", (Object[])new Object[0]), (String)String.valueOf(this.timeout)), BankLoginConfigUtil.getBankLoginConfig((String)"charset", (String)ResManager.loadKDString((String)"\u5b57\u7b26\u96c6", (String)"OPAMetaDataTemplate_5", (String)"ebg-receipt-common", (Object[])new Object[0]), (String)this.charset).set2ReadOnly()});
    }

    public List<BankLoginConfig> getBankLoginExtraConfig() {
        return Lists.newArrayList();
    }

    private List<BankLoginConfig> getBankPGPConfig() {
        if (this.isUseBankPGPConfig()) {
            return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getBankLoginConfig((String)PrivateKey, (String)ResManager.loadKDString((String)"\u79c1\u94a5\u6587\u4ef6", (String)"OPAMetaDataTemplate_6", (String)"ebg-receipt-common", (Object[])new Object[0]), (String)"", (boolean)false, (boolean)false, (String)"upload"), BankLoginConfigUtil.getBankLoginConfig((String)PrivateKeySecret, (String)ResManager.loadKDString((String)"\u79c1\u94a5\u5bc6\u7801", (String)"OPAMetaDataTemplate_7", (String)"ebg-receipt-common", (Object[])new Object[0]), (String)"", (boolean)false, (boolean)true, (boolean)true), BankLoginConfigUtil.getBankLoginConfig((String)PublicKey, (String)ResManager.loadKDString((String)"\u516c\u94a5\u6587\u4ef6", (String)"OPAMetaDataTemplate_8", (String)"ebg-receipt-common", (Object[])new Object[0]), (String)"", (boolean)false, (boolean)false, (String)"upload"), BankLoginConfigUtil.getBankLoginConfig((String)PublicKeySecret, (String)ResManager.loadKDString((String)"\u516c\u94a5\u5bc6\u7801", (String)"OPAMetaDataTemplate_9", (String)"ebg-receipt-common", (Object[])new Object[0]), (String)"", (boolean)false, (boolean)true, (boolean)true), BankLoginConfigUtil.getBankLoginConfig((String)ZBankCipher, (String)ResManager.loadKDString((String)"\u901a\u4fe1\u5bc6\u7801", (String)"OPAMetaDataTemplate_10", (String)"ebg-receipt-common", (Object[])new Object[0]), (String)"", (boolean)false, (boolean)true, (boolean)true)});
        }
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getBankLoginReceiptBaseConfig() {
        return Lists.newArrayList();
    }

    public boolean isUseBankPGPConfig() {
        return true;
    }

    @Override
    public List<Class<? extends IBankService>> getBizImplClasses() {
        return null;
    }

    @Override
    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    @Override
    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    @Override
    public BankPropertyConfig getPropertyConfig() {
        return null;
    }

    @Override
    public boolean showInJdy() {
        return true;
    }

    public List<BankLoginConfig> getReconciliationConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)"isSupportReconciliation", (MultiLangEnumBridge)new MultiLangEnumBridge("\u662f\u5426\u9700\u8981\u5bf9\u8d26\u5355\u3002", "FBEMetaDataTemplate_7", "ebg-receipt-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u662f\u5426\u9700\u8981\u5bf9\u8d26\u5355\uff0c\u9ed8\u8ba4\u4e3a\u5426\u3002", "FBEMetaDataTemplate_8", "ebg-receipt-common"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{PropertiesOptions.YES_NAME, PropertiesOptions.NO_NAME}), (List)Lists.newArrayList((Object[])new String[]{"true", "false"}), (String)"false", (boolean)false, (boolean)false, (boolean)false)});
    }
}

