/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.receipt.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.util.Properties;
import java.util.Vector;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.constant.RetryErrorEnum;
import kd.ebg.receipt.common.framework.receipt.exception.ConnectionException;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.sdk.annotation.SdkDeprecated;

public class SFTPUtils {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SFTPUtils.class);
    private static SFTPUtils instance = null;
    private String bankLoginId;

    @SdkDeprecated
    public static synchronized SFTPUtils getInstance() {
        if (instance == null) {
            instance = new SFTPUtils();
        }
        return instance;
    }

    private SFTPUtils() {
    }

    public boolean isAbort(ChannelSftp sftp) {
        return !this.isWorking(sftp);
    }

    public boolean isWorking(ChannelSftp sftp) {
        return sftp != null && sftp.isConnected() && !sftp.isClosed();
    }

    public void setBankLoginId(String loginId) {
        this.bankLoginId = loginId;
    }

    public ChannelSftp getSftp(String loginId) {
        this.bankLoginId = loginId;
        return this.getSftp();
    }

    @SdkDeprecated
    public ChannelSftp getSftp() {
        ChannelSftp sftp = null;
        try {
            this.bankLoginId = EBContext.getContext().getBankLoginID();
            BankFtpProperties ftpProperties = EBGStringUtils.isEmpty(this.bankLoginId) ? EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class) : EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, this.bankLoginId);
            if (EBGStringUtils.isEmpty(ftpProperties.getBankFtpIP())) {
                throw new ReceiptException(RetryErrorEnum.BANK_FTP_IP_IS_EMPTY.getMsg());
            }
            if (ftpProperties.getBankFtpPort() == 0) {
                throw new ReceiptException(RetryErrorEnum.BANK_FTP_PORT_IS_EMPTY.getMsg());
            }
            if (EBGStringUtils.isEmpty(ftpProperties.getUserName())) {
                throw new ReceiptException(RetryErrorEnum.FTP_USER_NAME_IS_EMPTY.getMsg());
            }
            sftp = this.connect(ftpProperties.getBankFtpIP(), ftpProperties.getBankFtpPort(), ftpProperties.getUserName(), ftpProperties.getPassword(), ftpProperties.getCertPath());
            logger.info("\u5efa\u7acbSFTP\u8fde\u63a5\u6210\u529f\u3002");
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"SFTP\u670d\u52a1\u5f02\u5e38\uff1a", (String)"SFTPUtils_0", (String)"ebg-receipt-common", (Object[])new Object[0]);
            msg = e.getMessage().toLowerCase().contains("auth fail") ? ResManager.loadKDString((String)"\u5efa\u7acbSFTP\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff1a\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u7684SFTP\u7684\u8d26\u53f7\u548c\u5bc6\u7801\u662f\u5426\u6b63\u786e\u3002", (String)"SFTPUtils_1", (String)"ebg-receipt-common", (Object[])new Object[0]) : (e.getMessage().toLowerCase().contains("connection refused") ? ResManager.loadKDString((String)"\u5efa\u7acbSFTP\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff1a\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6eSFTP\u7684IP\u548c\u7aef\u53e3\u662f\u5426\u6b63\u786e\u3002", (String)"SFTPUtils_2", (String)"ebg-receipt-common", (Object[])new Object[0]) : msg + e.getMessage());
            logger.info(msg, e);
            throw new ConnectionException(msg, e.getCause());
        }
        return sftp;
    }

    public ChannelSftp connect(String host, int port, String username, String ftpPassword, String ftpCertPath) throws Exception {
        ChannelSftp sftp = null;
        try {
            JSch jsch = new JSch();
            logger.info("\u51c6\u5907\u5efa\u7acbFTP\u8fde\u63a5\u3002");
            if (!EBGStringUtils.isEmpty(ftpCertPath)) {
                jsch.addIdentity(ftpCertPath);
            }
            Session session = jsch.getSession(username, host, port);
            session.setTimeout(60000);
            Properties config = new Properties();
            config.setProperty("StrictHostKeyChecking", "no");
            session.setConfig(config);
            if (!EBGStringUtils.isEmpty(ftpPassword)) {
                session.setPassword(ftpPassword);
            }
            session.connect();
            Channel channel = session.openChannel("sftp");
            channel.connect(60000);
            sftp = (ChannelSftp)channel;
            logger.info("Connected to " + host + ".");
        }
        catch (Exception e) {
            logger.error("SFTP\u670d\u52a1\u5f02\u5e38:\u5efa\u7acbFTP\u8fde\u63a5\u51fa\u9519\u3002", e);
            throw e;
        }
        return sftp;
    }

    @SdkDeprecated
    public void close(ChannelSftp sftp) {
        try {
            if (this.isWorking(sftp)) {
                this.clear(sftp.getSession());
                sftp.disconnect();
            }
            logger.info("\u5173\u95edsftp\u8fde\u63a5\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("sftp.disconnect()-\u5173\u95edSFTP\u8fde\u63a5\u51fa\u9519", e);
        }
    }

    @SdkDeprecated
    public boolean downloadSingleFile(String directory, String downloadFile, String saveFile, ChannelSftp sftp) {
        try {
            File file;
            if (!EBGStringUtils.isEmpty(directory)) {
                logger.info("\u5207\u6362\u5230ftp\u76ee\u5f55\uff1a" + directory);
                sftp.cd(directory);
            }
            if (!(file = FileCommonUtils.getFileByPath(saveFile)).exists()) {
                file.mkdirs();
            }
            sftp.get(downloadFile, saveFile);
            logger.info("\u4e0b\u8f7d\u6587\u4ef6" + downloadFile + "\u5230" + saveFile + "\u6210\u529f");
        }
        catch (SftpException e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6" + downloadFile + "\u5931\u8d25\uff1a", e);
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"SFTP\u670d\u52a1\u5f02\u5e38\uff1a%s\u3002", (String)"SFTPUtils_4", (String)"ebg-receipt-common", (Object[])new Object[0]), e.getMessage()), e);
        }
        return true;
    }

    public Vector listFiles(String directory, ChannelSftp sftp) throws SftpException {
        return sftp.ls(directory);
    }

    public Vector listFile(String directory, String fileName, ChannelSftp sftp) {
        if (!EBGStringUtils.isEmpty(directory) && !directory.endsWith("/")) {
            fileName = directory + "/" + fileName;
        }
        logger.info("SFTP\u904d\u5386\u6587\u4ef6\u76ee\u5f55\uff1a{}", fileName);
        try {
            return sftp.ls(fileName);
        }
        catch (Exception e) {
            throw new ReceiptException(ResManager.loadKDString((String)"SFTP\u670d\u52a1\u5f02\u5e38:", (String)"SFTPUtils_3", (String)"ebg-receipt-common", (Object[])new Object[0]), e);
        }
    }

    public boolean isDirExist(String directory, ChannelSftp sftp) {
        boolean isDirExistFlag = false;
        try {
            SftpATTRS sftpATTRS = sftp.lstat(directory);
            return sftpATTRS.isDir();
        }
        catch (Exception exception) {
            return isDirExistFlag;
        }
    }

    public long getFileSize(String fileName, ChannelSftp sftp) throws SftpException {
        return this.getFileSize("", fileName, sftp);
    }

    public long getFileSize(String directory, String fileName, ChannelSftp sftp) throws SftpException {
        long size = 0L;
        Vector files = this.listFile(directory, fileName, sftp);
        if (files.size() != 0) {
            ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)files.get(0);
            size = file.getAttrs().getSize();
        }
        return size;
    }

    private void clear(Session session) {
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
    }
}

