/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.model.repository;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.constant.CertType;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.CipherCertUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.model.CertInfo;
import kd.sdk.annotation.SdkDeprecated;

@Component
public class UserCertRepository {
    private static final String ENTITY_NAME = "aqap_bd_cert";

    @SdkDeprecated
    public CertInfo findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(String bankConfigId, String bankLoginID, String customID) {
        String selectProperties = "id, bank_config_id, bank_config_value_tag, bank_config_name, bank_login_id, bank_version_id, acnt_no, type, custom_id, file_name, source,cert_password";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ENTITY_NAME, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bank_config_id", "=", (Object)bankConfigId), new QFilter("bank_login_id", "=", (Object)bankLoginID), new QFilter("custom_id", "=", (Object)customID), new QFilter("type", "=", (Object)CertType.BANKLOGIN_CER)});
        if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            CertInfo certInfo = new CertInfo();
            try {
                certInfo.setFileName(dynamicObject.getString("file_name"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            certInfo.setFileContent(dynamicObject.getString("bank_config_value_tag"));
            certInfo.setCustomID(customID);
            certInfo.setCertID(Long.toString(dynamicObject.getLong("id")));
            try {
                certInfo.setCertPassword(CipherCertUtil.desEncrypt((String)dynamicObject.getString("cert_password"), (Long)dynamicObject.getLong("id")));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return certInfo;
        }
        return null;
    }

    public DynamicObject[] getBankLoginCerDatas(String bankLoginID, String customID) {
        String selectProperties = "id, bank_config_id, bank_config_value_tag, bank_config_name, bank_login_id, bank_version_id, acnt_no, type, custom_id, file_name,expire_time,source";
        return BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bank_login_id", "=", (Object)bankLoginID), new QFilter("custom_id", "=", (Object)customID), new QFilter("type", "=", (Object)CertType.BANKLOGIN_CER.getType())});
    }

    public OperationResult addBankLoginCert(String bankConfigId, String bankConfigName, String bankVersion, String bankLogin, String customID, String value, String fileName) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        dataEntity.set("bank_config_id", (Object)bankConfigId);
        dataEntity.set("bank_config_value_tag", (Object)value);
        dataEntity.set("bank_config_name", (Object)bankConfigName);
        dataEntity.set("bank_login_id", (Object)bankLogin);
        dataEntity.set("bank_version_id", (Object)bankVersion);
        dataEntity.set("custom_id", (Object)customID);
        dataEntity.set("type", (Object)CertType.BANKLOGIN_CER.getType());
        dataEntity.set("file_name", (Object)fileName);
        dataEntity.set("expire_time", (Object)DateUtil.string2Date((String)"20991231000000", (String)"yyyyMMddHHmmss"));
        String formId = this.getFormId();
        if (StringUtils.isNotEmpty((String)formId)) {
            dataEntity.set("source", (Object)formId);
        }
        OperationResult result = SaveServiceHelper.saveOperate((String)ENTITY_NAME, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
        return result;
    }

    public void updateBankLoginCert(DynamicObject cerData, String bankConfigId, String bankConfigName, String bankVersion, String bankLogin, String customID, String value, String fileName) {
        cerData.set("bank_config_id", (Object)bankConfigId);
        if (StrUtil.isNotBlank((CharSequence)value)) {
            cerData.set("bank_config_value_tag", (Object)value);
        }
        cerData.set("bank_config_name", (Object)bankConfigName);
        cerData.set("bank_login_id", (Object)bankLogin);
        cerData.set("bank_version_id", (Object)bankVersion);
        cerData.set("custom_id", (Object)customID);
        cerData.set("type", (Object)CertType.BANKLOGIN_CER.getType());
        cerData.set("file_name", (Object)fileName);
        cerData.set("expire_time", (Object)DateUtil.string2Date((String)"20991231000000", (String)"yyyyMMddHHmmss"));
        String formId = this.getFormId();
        if (StringUtils.isNotEmpty((String)formId)) {
            cerData.set("source", (Object)formId);
        }
        SaveServiceHelper.save((IDataEntityType)cerData.getDataEntityType(), (Object[])new DynamicObject[]{cerData});
    }

    private String getFormId() {
        EBContext ebContext = EBContext.getContext();
        String formId = "";
        if (ebContext != null) {
            formId = ebContext.getFormId();
        }
        return formId;
    }
}

