/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.model.repository.receipt;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.model.receipt.EBCBdMatchRule;

@Component
public class EBCMatchRuleRepository {
    private static final String DETAILINFO_ENTITY = "receipt_bd_match_rule";
    private static final String SELECT_ALL_PROPERTIES = "id,number,name,match_rule,bank_version,modifytime,createtime";

    public void save(EBCBdMatchRule info) {
        DynamicObject dynamicObject = this.packEBCBdMatchRule(null, info);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void update(EBCBdMatchRule info) {
        DynamicObject dynamicObject = this.findOneById(info.getId());
        dynamicObject = this.packEBCBdMatchRule(dynamicObject, info);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void deleteById(Long id) {
        if (id != null) {
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)DETAILINFO_ENTITY, (QFilter[])filter.toArray());
        }
    }

    public void delete(EBCBdMatchRule info) {
        long id = info.getId();
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DeleteServiceHelper.delete((String)DETAILINFO_ENTITY, (QFilter[])filter.toArray());
    }

    public EBCBdMatchRule findById(long id) {
        DynamicObject dynamicObject = this.findOneById(id);
        if (dynamicObject != null) {
            EBCBdMatchRule info = this.toEBCBdMatchRule(dynamicObject);
            return info;
        }
        return null;
    }

    public DynamicObject findOneById(long id) {
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public EBCBdMatchRule findByBankVersion(String bankVersionId) {
        QFilter filter;
        DynamicObject dynamicObject;
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>(16);
        if (!EBGStringUtils.isEmpty(bankVersionId)) {
            expression.append("and bank_version=?").append(' ');
            paramsList.add(bankVersionId);
        }
        if (!EBGStringUtils.isEmpty(expressionStr = expression.toString())) {
            expressionStr = expression.toString().substring(3);
        }
        if ((dynamicObject = BusinessDataServiceHelper.loadSingle((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])(filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray())).toArray())) == null) {
            return this.findCommonRule();
        }
        EBCBdMatchRule info = this.toEBCBdMatchRule(dynamicObject);
        return info;
    }

    public EBCBdMatchRule findCommonRule() {
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>(16);
        expression.append("number=?").append(' ');
        paramsList.add("common");
        String expressionStr = expression.toString();
        QFilter filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        EBCBdMatchRule info = this.toEBCBdMatchRule(dynamicObject);
        return info;
    }

    private EBCBdMatchRule toEBCBdMatchRule(DynamicObject dynamicObject) {
        EBCBdMatchRule info = new EBCBdMatchRule();
        info.setId(dynamicObject.getLong("id"));
        info.setModifytime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("modifytime")));
        info.setCreatetime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("createtime")));
        info.setBankVersionId(dynamicObject.getString("bank_version"));
        info.setMatchRule(dynamicObject.getString("match_rule"));
        info.setName(dynamicObject.getString("name"));
        info.setNumber(dynamicObject.getString("number"));
        return info;
    }

    private DynamicObject packEBCBdMatchRule(DynamicObject dynamicObject, EBCBdMatchRule info) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)DETAILINFO_ENTITY);
            dynamicObject.set("createtime", (Object)new Date());
        } else {
            dynamicObject.set("id", (Object)info.getId());
        }
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("bank_version", (Object)info.getBankVersionId());
        dynamicObject.set("match_rule", (Object)info.getMatchRule());
        dynamicObject.set("name", (Object)info.getName());
        dynamicObject.set("number", (Object)info.getNumber());
        return dynamicObject;
    }
}

