/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.model.repository.reconciliation;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.constant.UploadTaskStatusEnum;

@Component
public class ReconciliationDownloadTaskRepository {
    private static final String ENTITY_NAME = "reconcilia_download_task";
    private static final String SELECT_ALL_PROPERTIES = "id,bank_login.number,acc_no.number,bank_version.number,trans_date,status,complete_time,exp_msg,redo,custom_id,modifytime,createtime,upload_flag,reconcilia_num,upload_num";

    public DynamicObjectCollection selectByBankVersionAndAccnoAndTransDateBetween(String bankVersion, String accno, Date transStartDate, Date transEndDate, String bankLoginId) {
        QFilter[] qFilters = null;
        qFilters = accno != null ? new QFilter[]{new QFilter("bank_version.number", "=", (Object)bankVersion), new QFilter("acc_no.number", "=", (Object)accno), new QFilter("trans_date", ">=", (Object)transStartDate), new QFilter("bank_login.number", ">=", (Object)bankLoginId), new QFilter("trans_date", "<=", (Object)transEndDate)} : new QFilter[]{new QFilter("bank_version.number", "=", (Object)bankVersion), new QFilter("bank_login.number", ">=", (Object)bankLoginId), new QFilter("trans_date", ">=", (Object)transStartDate), new QFilter("trans_date", "<=", (Object)transEndDate)};
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)ENTITY_NAME, (String)"acc_no, trans_date, bank_login, bank_version", (QFilter[])qFilters);
        return dynamicObjectCollection;
    }

    public DynamicObject selectById(Long id) {
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    public DynamicObject[] findByComplexCondition(String accNo, String bankVersionID, String bankLoginID, LocalDate startDate, LocalDate endDate, Integer status, String customId) {
        QFilter filter;
        DynamicObjectCollection collection;
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<Object> paramsList = new ArrayList<Object>(16);
        if (StringUtils.isNotEmpty((String)accNo)) {
            expression.append("and acc_no.number=?").append(' ');
            paramsList.add(accNo);
        }
        if (StringUtils.isNotEmpty((String)bankVersionID)) {
            expression.append("and bank_version.number=?").append(' ');
            paramsList.add(bankVersionID);
        }
        if (StringUtils.isNotEmpty((String)bankLoginID)) {
            expression.append("and bank_login.number=?").append(' ');
            paramsList.add(bankLoginID);
        }
        if (startDate != null) {
            expression.append("and trans_date>=?").append(' ');
            paramsList.add(LocalDateUtil.localDate2Date((LocalDate)startDate));
        }
        if (endDate != null) {
            expression.append("and trans_date<=?").append(' ');
            paramsList.add(LocalDateUtil.localDate2Date((LocalDate)endDate));
        }
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and custom_id=?").append(' ');
            paramsList.add(customId);
        }
        if (status != null) {
            expression.append("and status=?").append(' ');
            paramsList.add(status.toString());
        }
        if (StringUtils.isNotEmpty((String)(expressionStr = expression.toString()))) {
            expressionStr = expression.toString().substring(3);
        }
        if ((collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])(filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray())).toArray())) != null && !collection.isEmpty()) {
            DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                dynamicObjects[i] = (DynamicObject)collection.get(i);
            }
            return dynamicObjects;
        }
        return null;
    }

    public DynamicObject[] findByBankVersionIDAndTransDateAndCustomId(String bankVersionID, LocalDate transDate, String customId) {
        return this.findByComplexCondition(null, bankVersionID, null, transDate, transDate, null, customId);
    }

    public DynamicObject[] findByStatus(Integer status) {
        return this.findByComplexCondition(null, null, null, null, null, status, null);
    }

    public DynamicObject[] findByBankVersionIDAndBankLoginIdAndTransDateAndCustomId(String bankVersionID, String bankLoginId, LocalDate transDate, String customId) {
        return this.findByComplexCondition(null, bankVersionID, bankLoginId, transDate, transDate, null, customId);
    }

    public DynamicObject[] findByAccNoAndBankVersionIDAndTransDateBetween(String accNo, String bankVersionID, String bankLoginID, LocalDate startDate, LocalDate endDate) {
        return this.findByComplexCondition(accNo, bankVersionID, bankLoginID, startDate, endDate, null, null);
    }

    public DynamicObject[] findByAccNoAndCoustomId(String accNo, String customId) {
        return this.findByComplexCondition(accNo, null, null, null, null, null, customId);
    }

    public DynamicObject[] findByAccNoAndCoustomIdAndBankVersionAndBankLoginAndStatusList(String accNo, String customId, String bankVersion, String bankLogin, List<Integer> statusArray) {
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>(16);
        if (StringUtils.isNotEmpty((String)accNo)) {
            expression.append("and acc_no.number=?").append(' ');
            paramsList.add(accNo);
        }
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and custom_id=?").append(' ');
            paramsList.add(customId);
        }
        if (StringUtils.isNotEmpty((String)bankVersion)) {
            expression.append("and bank_version.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        if (StringUtils.isNotEmpty((String)bankLogin)) {
            expression.append("and bank_login.number=?").append(' ');
            paramsList.add(bankLogin);
        }
        if (StringUtils.isNotEmpty((String)(expressionStr = expression.toString()))) {
            expressionStr = expression.toString().substring(3);
        }
        QFilter filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray());
        if (statusArray != null && statusArray.size() > 0) {
            List<String> statusList = statusArray.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
            QFilter filterStatus = QFilter.of((String)this.packInOfStrByList("status", statusList), (Object[])new Object[0]);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter, filterStatus});
            if (collection != null && !collection.isEmpty()) {
                DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
                for (int i = 0; i < collection.size(); ++i) {
                    dynamicObjects[i] = (DynamicObject)collection.get(i);
                }
                return dynamicObjects;
            }
            return null;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (collection != null && !collection.isEmpty()) {
            DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                dynamicObjects[i] = (DynamicObject)collection.get(i);
            }
            return dynamicObjects;
        }
        return null;
    }

    public DynamicObject[] findTodayByCoustomIdAndStatusListAndBankVersionAndTransDate(String customId, List<Integer> statusArray, String bankVersion, LocalDate transDate) {
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<Object> paramsList = new ArrayList<Object>(16);
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and custom_id=?").append(' ');
            paramsList.add(customId);
        }
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and bank_version.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        if (transDate != null) {
            expression.append("and trans_date=?").append(' ');
            paramsList.add(LocalDateUtil.localDate2Date((LocalDate)transDate));
        }
        if (StringUtils.isNotEmpty((String)(expressionStr = expression.toString()))) {
            expressionStr = expression.toString().substring(3);
        }
        QFilter filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray());
        if (statusArray != null && statusArray.size() > 0) {
            List<String> statusList = statusArray.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
            QFilter filterStatus = QFilter.of((String)this.packInOfStrByList("status", statusList), (Object[])new Object[0]);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter, filterStatus});
            if (collection != null && !collection.isEmpty()) {
                DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
                for (int i = 0; i < collection.size(); ++i) {
                    dynamicObjects[i] = (DynamicObject)collection.get(i);
                }
                return dynamicObjects;
            }
            return null;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter});
        if (collection != null && !collection.isEmpty()) {
            DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                dynamicObjects[i] = (DynamicObject)collection.get(i);
            }
            return dynamicObjects;
        }
        return null;
    }

    public DynamicObject[] findByCoustomIdAndStatusListAndBankVersion(String customId, List<Integer> statusArray, String bankVersion) {
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and custom_id=?").append(' ');
            paramsList.add(customId);
        }
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and bank_version.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        if (StringUtils.isNotEmpty((String)(expressionStr = expression.toString()))) {
            expressionStr = expression.toString().substring(3);
        }
        QFilter filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray());
        if (statusArray != null && statusArray.size() > 0) {
            List<String> statusList = statusArray.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
            QFilter filterStatus = QFilter.of((String)this.packInOfStrByList("status", statusList), (Object[])new Object[0]);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter, filterStatus});
            if (collection != null && !collection.isEmpty()) {
                DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
                for (int i = 0; i < collection.size(); ++i) {
                    dynamicObjects[i] = (DynamicObject)collection.get(i);
                }
                return dynamicObjects;
            }
            return null;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter});
        if (collection != null && !collection.isEmpty()) {
            DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                dynamicObjects[i] = (DynamicObject)collection.get(i);
            }
            return dynamicObjects;
        }
        return null;
    }

    public DynamicObject[] findTodayByCoustomIdAndStatusListAndBankVersionAndTransDateAndBankLogin(String customId, List<Integer> statusArray, String bankVersion, LocalDate transDate, String bankLogin) {
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<Object> paramsList = new ArrayList<Object>(16);
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and custom_id=?").append(' ');
            paramsList.add(customId);
        }
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and bank_version.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        if (StringUtils.isNotEmpty((String)bankLogin)) {
            expression.append("and bank_login.number=?").append(' ');
            paramsList.add(bankLogin);
        }
        if (transDate != null) {
            expression.append("and trans_date=?").append(' ');
            paramsList.add(LocalDateUtil.localDate2Date((LocalDate)transDate));
        }
        if (StringUtils.isNotEmpty((String)(expressionStr = expression.toString()))) {
            expressionStr = expression.toString().substring(3);
        }
        QFilter filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray());
        if (statusArray != null && statusArray.size() > 0) {
            List statusList = statusArray.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
            QFilter filterStatus = new QFilter("status", "in", statusList);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter, filterStatus});
            if (collection != null && !collection.isEmpty()) {
                DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
                for (int i = 0; i < collection.size(); ++i) {
                    dynamicObjects[i] = (DynamicObject)collection.get(i);
                }
                return dynamicObjects;
            }
            return null;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter});
        if (collection != null && !collection.isEmpty()) {
            DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                dynamicObjects[i] = (DynamicObject)collection.get(i);
            }
            return dynamicObjects;
        }
        return null;
    }

    public DynamicObject[] findUnUploadCompleteTaskByBankVersionAndCustomId(String customId, String bankVersion, LocalDate startDate, LocalDate endDate) {
        QFilter filter1;
        QFilter filter;
        DynamicObjectCollection collection;
        StringBuilder expression = new StringBuilder();
        ArrayList<Object> paramsList = new ArrayList<Object>(16);
        if (StringUtils.isNotEmpty((String)customId)) {
            expression.append("and custom_id=?").append(' ');
            paramsList.add(customId);
        }
        if (startDate != null) {
            expression.append("and trans_date>=?").append(' ');
            paramsList.add(startDate);
        }
        if (endDate != null) {
            expression.append("and trans_date<=?").append(' ');
            paramsList.add(endDate);
        }
        if (StringUtils.isNotEmpty((String)bankVersion)) {
            expression.append("and bank_version.number=?").append(' ');
            paramsList.add(bankVersion);
        }
        expression.append("and status=?").append(' ');
        paramsList.add(String.valueOf(TaskStatusEnum.FINISH.getId()));
        String expressionStr = expression.toString();
        if (StringUtils.isNotEmpty((String)expressionStr)) {
            expressionStr = expression.toString().substring(3);
        }
        if ((collection = QueryServiceHelper.query((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray()), filter1 = new QFilter("upload_flag", "in", Arrays.asList(String.valueOf(UploadTaskStatusEnum.UN_UPLOAD.getId()), String.valueOf(UploadTaskStatusEnum.UPLOAD_PROCESSING.getId())))})) != null && !collection.isEmpty()) {
            DynamicObject[] dynamicObjects = new DynamicObject[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                dynamicObjects[i] = (DynamicObject)collection.get(i);
            }
            return dynamicObjects;
        }
        return null;
    }

    public DynamicObject findById(long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObjects = BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObjects;
    }

    public void save(DynamicObject dynamicObject) {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void batchSave(DynamicObject[] dynamicObjects) {
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    public void batchUpdate(DynamicObject[] dynamicObjects) {
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    public void update(DynamicObject dynamicObject) {
        if (dynamicObject != null) {
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public void delete(String id) {
        if (!StringUtils.isEmpty((String)id)) {
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])filter.toArray());
        }
    }

    public void batchDelete(String[] ids) {
        if (ids != null && ids.length > 0) {
            DynamicObjectType dynamicObjectType = new DynamicObjectType(ENTITY_NAME);
            DeleteServiceHelper.delete((IDataEntityType)dynamicObjectType, (Object[])ids);
        }
    }

    public boolean exitsByBankVersionAndAccnoAndTransDate(String bankVersion, String accno, Date transDate) {
        return QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("bank_version.number", "=", (Object)bankVersion), new QFilter("acc_no.number", "=", (Object)accno), new QFilter("trans_date", "=", (Object)transDate)});
    }

    public String packInOfStrByList(String filed, List<String> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(filed).append(" in (");
        for (int i = 0; i < arrayList.size(); ++i) {
            String str = arrayList.get(i);
            stringBuilder.append("'");
            stringBuilder.append(str);
            stringBuilder.append("'");
            if (i >= arrayList.size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void update(String accountID, String newAccountID) {
        DynamicObject[] dynamicObject;
        for (DynamicObject dynamicObject1 : dynamicObject = this.findOneById(accountID)) {
            dynamicObject1.set("custom_id", (Object)newAccountID);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObject);
    }

    public DynamicObject[] findOneById(String customID) {
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{customID});
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }
}

