/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.utils.ofd;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.OFDProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.ofd.Base64Util;
import kd.ebg.receipt.common.utils.ofd.CompressHelper;
import kd.ebg.receipt.common.utils.ofd.HexUtil;
import kd.ebg.receipt.common.utils.ofd.OfdErrorType;
import kd.ebg.receipt.common.utils.ofd.OfdReadUtil;
import kd.ebg.receipt.common.utils.ofd.SM3Util;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLSet;
import org.jdom2.Element;

public class OfdSignUtil {
    private static final EBGLogger LOGGER = EBGLogger.getInstance().getLogger(OfdSignUtil.class);

    public static boolean verifySignAndGetCerInfo(String filePath, boolean fullFlag, boolean taxFlag) {
        try {
            LOGGER.info("\u9a8c\u7b7e:{}\u6587\u4ef6\u3002", filePath);
            byte[] fileBytes = OfdSignUtil.getBytesByFile(filePath);
            Map<String, byte[]> decompressFileMap = CompressHelper.decompress(fileBytes);
            if (decompressFileMap == null) {
                LOGGER.info("{}-OFD\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff01", filePath);
                return false;
            }
            byte[] ofdMainByte = decompressFileMap.get("OFD.xml");
            String signaturesPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/Signatures");
            LOGGER.info("\u7b7e\u7ae0\u8def\u5f84: " + signaturesPath);
            byte[] signaturesByte = decompressFileMap.get(signaturesPath);
            Element signaturesEle = OfdReadUtil.getElementByByte(signaturesByte);
            String maxSignId = signaturesEle.getChildTextTrim("MaxSignId", signaturesEle.getNamespace());
            LOGGER.info("\u7b7e\u7ae0\u6807\u8bc6MaxSignId: " + maxSignId);
            String signaturePath = OfdSignUtil.getSignaturePath(maxSignId, signaturesEle);
            signaturePath = OfdReadUtil.getDirPath(signaturePath, signaturesPath);
            byte[] signatureByte = decompressFileMap.get(signaturePath);
            Element signatureEle = OfdReadUtil.getElementByByte(signatureByte);
            Element signedInfoEle = signatureEle.getChild("SignedInfo", signatureEle.getNamespace());
            Element referencesEle = signedInfoEle.getChild("References", signatureEle.getNamespace());
            String checkMethod = referencesEle.getAttributeValue("CheckMethod");
            OfdSignUtil.checkHashValue(referencesEle, checkMethod, decompressFileMap);
            String signedValuePath = signatureEle.getChildText("SignedValue", signatureEle.getNamespace());
            signedValuePath = OfdReadUtil.getDirPath(signedValuePath, signaturePath);
            byte[] signedValueByte = decompressFileMap.get(signedValuePath);
            LOGGER.info("\u5f00\u59cb\u9a8c\u8bc1\u7b7e\u7ae0\u4fe1\u606f");
            boolean isCheck = OfdSignUtil.checkSignValue(filePath, signedValueByte, SM3Util.doDigestToBase64Str(signatureByte), fullFlag, taxFlag);
            LOGGER.info("\u9a8c\u7b7e\u7ed3\u679c\uff1a" + isCheck);
            return isCheck;
        }
        catch (Exception e) {
            LOGGER.info(filePath + OfdErrorType.CHECK_SIGN_ERROR.getErrcode(), "\u9a8c\u7b7e\u5931\u8d25:" + e.getMessage());
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] getBytesByFile(String pathStr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean verifySign(String filePath, boolean taxFlag) {
        return OfdSignUtil.verifySignAndGetCerInfo(filePath, false, taxFlag);
    }

    private static String getSignaturePath(String maxSignId, Element signaturesEle) {
        String signaturePath = null;
        if (maxSignId != null && !"".equals(maxSignId.trim())) {
            List signaturesEleList = signaturesEle.getChildren("Signature", signaturesEle.getNamespace());
            for (Element signatureEle : signaturesEleList) {
                if (!maxSignId.equals(signatureEle.getAttributeValue("ID"))) continue;
                signaturePath = signatureEle.getAttributeValue("BaseLoc");
                break;
            }
        }
        if (signaturePath == null && signaturesEle != null) {
            signaturePath = signaturesEle.getChild("Signature", signaturesEle.getNamespace()).getAttributeValue("BaseLoc");
        }
        if (signaturePath != null && signaturePath.startsWith("/")) {
            signaturePath = signaturePath.substring(1);
        }
        return signaturePath;
    }

    private static boolean checkHashValue(Element referencesEle, String checkMethod, Map<String, byte[]> decompressFileMap) {
        List elementList = referencesEle.getChildren("Reference", referencesEle.getNamespace());
        for (Element referenceEle : elementList) {
            String filePath = referenceEle.getAttributeValue("FileRef");
            String checkValue = referenceEle.getChildText("CheckValue", referenceEle.getNamespace());
            if (filePath.startsWith("/")) {
                filePath = filePath.substring(1);
            }
            LOGGER.info("CheckValue:{}-FileRef\u8def\u5f84-{}-SM3\u7b97\u6cd5\u9a8c\u8bc1\u7ed3\u679c\uff1atrue", new Object[]{checkValue, filePath});
            byte[] fileByte = decompressFileMap.get(filePath);
            String hashValue = null;
            if ("1.2.156.10197.1.401".equals(checkMethod) || "sm3".equalsIgnoreCase(checkMethod)) {
                hashValue = SM3Util.doDigestToBase64Str(fileByte);
            }
            if (hashValue == null || hashValue.equals(checkValue)) continue;
            LOGGER.info(OfdErrorType.HASH_NOT_CORRECT.getDescription());
            return false;
        }
        return true;
    }

    private static boolean checkSignValue(String filePath, byte[] signFileByte, String signFileHash, boolean fullFlag, boolean taxFlag) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(signFileByte);
            ASN1StreamParser asn1StreamParser = new ASN1StreamParser((InputStream)inputStream);
            ASN1Encodable asn1Encodable = asn1StreamParser.readObject();
            ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Encodable.toASN1Primitive();
            if (asn1Sequence.getObjectAt(0) instanceof ASN1ObjectIdentifier) {
                return OfdSignUtil.checkStandardSignValue(asn1Sequence, signFileHash, fullFlag, taxFlag);
            }
            ASN1Sequence sealInfoSeq = (ASN1Sequence)asn1Sequence.getObjectAt(0);
            try {
                ASN1Encodable cerObject = asn1Sequence.getObjectAt(1);
                DEROctetString cerStr = cerObject instanceof DEROctetString ? (DEROctetString)cerObject : (DEROctetString)sealInfoSeq.getObjectAt(5);
                boolean checkCert = OfdSignUtil.checkCertIsTrue(cerStr.getOctets(), fullFlag, taxFlag);
                if (!checkCert) {
                    LOGGER.info(filePath + "\u83b7\u53d6\u7b7e\u7ae0\u8bc1\u4e66\u5931\u8d25");
                    return false;
                }
            }
            catch (Exception e) {
                LOGGER.info(filePath + "\u83b7\u53d6\u7b7e\u7ae0\u8bc1\u4e66\u51fa\u73b0\u5f02\u5e38", e);
            }
            DERBitString hashDer = (DERBitString)sealInfoSeq.getObjectAt(3);
            String originalHash = Base64Util.base64encoder(hashDer.getBytes());
            if (!originalHash.equals(signFileHash)) {
                LOGGER.info(filePath + OfdErrorType.HASH_NOT_CORRECT.getDescription());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.info(filePath + OfdErrorType.CHECK_SIGN_ERROR.getDescription());
            return false;
        }
    }

    private static boolean checkStandardSignValue(ASN1Sequence asn1Sequence, String signFileHash, boolean fullFlag, boolean taxFlag) {
        DLSequence signedDataSeq = (DLSequence)asn1Sequence.getObjectAt(1);
        DLSequence signerInfoSeq = (DLSequence)((DLSet)signedDataSeq.getObjectAt(4)).getObjectAt(0);
        DLSequence hashDataSeq = (DLSequence)signerInfoSeq.getObjectAt(3);
        DLSet hashDataSet = (DLSet)((DLSequence)hashDataSeq.getObjectAt(2)).getObjectAt(1);
        byte[] hashDataBytes = ((DEROctetString)hashDataSet.getObjectAt(0)).getOctets();
        String hashDataBase64 = Base64Util.base64encoder(hashDataBytes);
        if (!hashDataBase64.equals(signFileHash)) {
            LOGGER.info(OfdErrorType.HASH_NOT_CORRECT.getDescription());
            return false;
        }
        return true;
    }

    private static Map<String, Object> getCertInfo(byte[] signFileByte, boolean fullFlag) throws IOException, ParseException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(signFileByte);
        ASN1StreamParser asn1StreamParser = new ASN1StreamParser((InputStream)inputStream);
        ASN1Encodable asn1Encodable = asn1StreamParser.readObject();
        ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Encodable.toASN1Primitive();
        ASN1Sequence asn1Sequence0 = (ASN1Sequence)asn1Sequence.getObjectAt(0);
        if (asn1Sequence0.size() < 7) {
            return null;
        }
        ASN1Sequence extSeq = (ASN1Sequence)asn1Sequence0.getObjectAt(7);
        String issuedStr = null;
        if (extSeq != null) {
            ASN1Sequence issuedSeq = null;
            issuedSeq = extSeq.size() == 13 ? (ASN1Sequence)extSeq.getObjectAt(2) : (ASN1Sequence)extSeq.getObjectAt(4);
            if (issuedSeq == null || !"2.5.29.35".equals(issuedSeq.getObjectAt(0))) {
                for (int i = 0; i < extSeq.size(); ++i) {
                    String identifiesStr = ((ASN1Sequence)extSeq.getObjectAt(i)).getObjectAt(0).toString();
                    if (!"2.5.29.35".equals(identifiesStr)) continue;
                    issuedSeq = (ASN1Sequence)extSeq.getObjectAt(i);
                    break;
                }
            }
            if (issuedSeq != null) {
                issuedStr = HexUtil.encodeHexStr(((ASN1OctetString)issuedSeq.getObjectAt(1)).getOctets()).substring(8);
            }
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, String> issuedMap = new HashMap<String, String>();
        issuedMap.put("FINGER_PRINT", issuedStr);
        if (fullFlag) {
            ASN1Sequence issuedSeq = (ASN1Sequence)asn1Sequence0.getObjectAt(3);
            String inssuedCStr = OfdSignUtil.getCertInfoStrBySeq(issuedSeq, 0);
            String inssuedOUStr = OfdSignUtil.getCertInfoStrBySeq(issuedSeq, 1);
            String inssuedCNStr = OfdSignUtil.getCertInfoStrBySeq(issuedSeq, 2);
            issuedMap.put("C", inssuedCStr);
            issuedMap.put("OU", inssuedOUStr);
            issuedMap.put("CN", inssuedCNStr);
            ASN1Sequence validitySeq = (ASN1Sequence)asn1Sequence0.getObjectAt(4);
            Date certStartDate = ((ASN1UTCTime)validitySeq.getObjectAt(0)).getDate();
            Date certEndDate = ((ASN1UTCTime)validitySeq.getObjectAt(1)).getDate();
            issuedMap.put("START_TIME", String.valueOf(certStartDate.getTime()));
            issuedMap.put("END_TIME", String.valueOf(certEndDate.getTime()));
            ASN1Sequence useSeq = (ASN1Sequence)asn1Sequence0.getObjectAt(5);
            String useCStr = OfdSignUtil.getCertInfoStrBySeq(useSeq, 0);
            String useOUStr = OfdSignUtil.getCertInfoStrBySeq(useSeq, 1);
            String useCNStr = OfdSignUtil.getCertInfoStrBySeq(useSeq, 2);
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("C", useCStr);
            userMap.put("OU", useOUStr);
            userMap.put("CN", useCNStr);
            String userStr = HexUtil.encodeHexStr(((ASN1OctetString)((ASN1Sequence)extSeq.getObjectAt(3)).getObjectAt(1)).getOctets()).substring(4);
            userMap.put("FINGER_PRINT", userStr);
            paramMap.put("userInfo", userMap);
        }
        paramMap.put("issuedInfo", issuedMap);
        return paramMap;
    }

    private static boolean checkCertIsTrue(byte[] signFileByte, boolean fullFlag, boolean taxFlag) {
        Map issuedInfoMap;
        String issuedStr;
        Map<String, Object> certInfoMap;
        try {
            certInfoMap = OfdSignUtil.getCertInfo(signFileByte, fullFlag);
        }
        catch (IOException | ParseException e) {
            LOGGER.info(OfdErrorType.SIGN_READ_CERT_ERROR.getDescription());
            return false;
        }
        if (taxFlag && !"b8b09a6007ea05b7b0b7e7cb42763129971576b3".equals(issuedStr = (String)(issuedInfoMap = (Map)certInfoMap.get("issuedInfo")).get("FINGER_PRINT")) && !"1fe6cfd48fc5222a974a298a15e716c99234c4b6".equals(issuedStr)) {
            LOGGER.info(OfdErrorType.SIGN_CERT_NOT_CORRECT.getDescription());
            return false;
        }
        return true;
    }

    private static String getCertInfoStrBySeq(ASN1Sequence issuedSeq, int index) {
        String str = null;
        if (issuedSeq != null && issuedSeq.size() > index) {
            str = ((ASN1Sequence)((ASN1Set)issuedSeq.getObjectAt(index)).getObjectAt(0)).getObjectAt(1).toString();
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean checkOFDFile(String ofdFileName, String bakFilePath) {
        block28: {
            boolean bl;
            Throwable throwable;
            ZipFile ofdZipFile;
            boolean isCheck;
            File receiptFile;
            block27: {
                block25: {
                    block26: {
                        String bankLogin = EBContext.getContext().getBankLoginID();
                        String isCheckOFDSign = RequestContextUtils.getRunningParam((String)"isCheckOFDSign");
                        if (EBGStringUtils.isEmpty(isCheckOFDSign)) {
                            OFDProperties ofdProperties = EBConfigBuilder.getInstance().buildConfig(OFDProperties.class, bankLogin);
                            isCheckOFDSign = ofdProperties.getIsCheckOFDSign();
                            RequestContextUtils.setRunningParam((String)"isCheckOFDSign", (String)isCheckOFDSign);
                        }
                        receiptFile = FileCommonUtils.getFileByPath(bakFilePath + File.separator + ofdFileName);
                        if (!ofdFileName.endsWith(".ofd") && !ofdFileName.endsWith(".OFD") || !Objects.equals(isCheckOFDSign, "true") || !receiptFile.exists()) break block28;
                        boolean isCheckSuccess = OfdSignUtil.verifySign(bakFilePath + File.separator + ofdFileName, false);
                        if (!isCheckSuccess) {
                            FileCommonUtils.moveFile(receiptFile, bakFilePath + File.separator + "uncheck", receiptFile.getName());
                            if (receiptFile.exists()) {
                                boolean isDelete = receiptFile.delete();
                                LOGGER.info("\u5220\u9664\u672a\u9a8c\u8bc1\u901a\u8fc7OFD\u6587\u4ef6\uff1a{},\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{ofdFileName, isDelete});
                            }
                            return false;
                        }
                        isCheck = false;
                        ofdZipFile = new ZipFile(receiptFile);
                        throwable = null;
                        Enumeration entries = ofdZipFile.getEntries();
                        while (entries.hasMoreElements()) {
                            ZipEntry entry = (ZipEntry)entries.nextElement();
                            if (entry.isDirectory() || !entry.getName().contains("bkrs_issuer_") && !entry.getName().contains("bker_issuer_") || !entry.getName().toLowerCase(Locale.ENGLISH).endsWith(".xml")) continue;
                            isCheck = true;
                        }
                        bl = isCheck;
                        if (ofdZipFile == null) break block25;
                        if (throwable == null) break block26;
                        try {
                            ofdZipFile.close();
                        }
                        catch (Throwable entry) {
                            throwable.addSuppressed(entry);
                        }
                        break block25;
                    }
                    ofdZipFile.close();
                }
                if (isCheck) break block27;
                String uncheckPath = bakFilePath + File.separator + "uncheck";
                FileCommonUtils.moveFile(receiptFile, uncheckPath, receiptFile.getName());
                LOGGER.info("OFD\u56de\u5355\u6587\u4ef6:{} \u4e0d\u5408\u89c4\uff0c\u65e0\u6cd5\u89e3\u6790\uff0c\u8df3\u8fc7\u5904\u7406\uff0c\u6587\u4ef6\u8f6c\u79fb\u5230\uff1a{}", new Object[]{receiptFile.getName(), uncheckPath});
                if (receiptFile.exists()) {
                    boolean isDelete = receiptFile.delete();
                    LOGGER.info("\u5220\u9664\u672a\u9a8c\u8bc1\u901a\u8fc7OFD\u6587\u4ef6\uff1a{},\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{ofdFileName, isDelete});
                }
            }
            return bl;
            {
                catch (Throwable throwable2) {
                    try {
                        try {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (ofdZipFile != null) {
                                    if (throwable != null) {
                                        try {
                                            ofdZipFile.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable.addSuppressed(throwable4);
                                        }
                                    } else {
                                        ofdZipFile.close();
                                    }
                                }
                                throw throwable3;
                            }
                        }
                        catch (Throwable e) {
                            LOGGER.monitorError("OfdSignUtil#checkOFDFile:error" + e.getMessage(), e);
                            if (!isCheck) {
                                String uncheckPath2 = bakFilePath + File.separator + "uncheck";
                                FileCommonUtils.moveFile(receiptFile, uncheckPath2, receiptFile.getName());
                                LOGGER.info("OFD\u56de\u5355\u6587\u4ef6:{} \u4e0d\u5408\u89c4\uff0c\u65e0\u6cd5\u89e3\u6790\uff0c\u8df3\u8fc7\u5904\u7406\uff0c\u6587\u4ef6\u8f6c\u79fb\u5230\uff1a{}", new Object[]{receiptFile.getName(), uncheckPath2});
                                if (receiptFile.exists()) {
                                    boolean isDelete2 = receiptFile.delete();
                                    LOGGER.info("\u5220\u9664\u672a\u9a8c\u8bc1\u901a\u8fc7OFD\u6587\u4ef6\uff1a{},\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{ofdFileName, isDelete2});
                                }
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (!isCheck) {
                            String uncheckPath3 = bakFilePath + File.separator + "uncheck";
                            FileCommonUtils.moveFile(receiptFile, uncheckPath3, receiptFile.getName());
                            LOGGER.info("OFD\u56de\u5355\u6587\u4ef6:{} \u4e0d\u5408\u89c4\uff0c\u65e0\u6cd5\u89e3\u6790\uff0c\u8df3\u8fc7\u5904\u7406\uff0c\u6587\u4ef6\u8f6c\u79fb\u5230\uff1a{}", new Object[]{receiptFile.getName(), uncheckPath3});
                            if (receiptFile.exists()) {
                                boolean isDelete3 = receiptFile.delete();
                                LOGGER.info("\u5220\u9664\u672a\u9a8c\u8bc1\u901a\u8fc7OFD\u6587\u4ef6\uff1a{},\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{ofdFileName, isDelete3});
                            }
                        }
                        throw throwable5;
                    }
                }
            }
        }
        return true;
    }
}

