/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gzcb.dc.service.api;

import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.gzcb.dc.service.GZCBEBankDataHelper;
import kd.ebg.receipt.banks.gzcb.dc.service.api.ReceiptInfo;
import kd.ebg.receipt.banks.gzcb.dc.service.helper.DomHelper;
import kd.ebg.receipt.banks.gzcb.dc.service.loginout.LoginAndOut;
import kd.ebg.receipt.banks.gzcb.dc.service.sign.SignService;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import org.jdom2.Document;
import org.jdom2.Element;

public class Srv024_ReceiptInfoQuery
extends AbstractBankReceiptImpl
implements IBankReceipt {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        String sessionId = LoginAndOut.getLoginAndOut().loginSessionId4Query();
        Element GZCBEBankData = new Element("GZCBEBankData");
        Element opReq = JDomUtils.addChild((Element)GZCBEBankData, (String)"opReq");
        String serialNo = Sequence.genSequence();
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)serialNo);
        String date = DateUtil.formatDateTime((Date)new Date());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)date);
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        String hdRQ = bankReceiptRequest.getTransDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        JDomUtils.addChild((Element)ReqParam, (String)"ZHHA", (String)bankReceiptRequest.getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"YWLX", (String)"BPRV");
        JDomUtils.addChild((Element)ReqParam, (String)"QSRQ", (String)hdRQ);
        JDomUtils.addChild((Element)ReqParam, (String)"ZZRQ", (String)hdRQ);
        JDomUtils.addChild((Element)ReqParam, (String)"HDLX", (String)"1");
        JDomUtils.addChild((Element)ReqParam, (String)"JYLX", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"BIZH", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"QUDAO", (String)"");
        ArrayList signList = Lists.newArrayList((Object[])new String[]{serialNo, date, bankReceiptRequest.getAccNo(), "BPRV", hdRQ, hdRQ, "1", "", "", ""});
        String signData = String.join((CharSequence)"|", signList) + "|";
        Element signInfo = JDomUtils.addChild((Element)GZCBEBankData, (String)"signInfo");
        SignService signService = new SignService();
        JDomUtils.addChild((Element)signInfo, (String)"signed_data", (String)signService.sign(signData));
        Document document = new Document(GZCBEBankData);
        String xml = DomHelper.doc2StringPlain(document, RequestContextUtils.getCharset());
        String saq = GZCBEBankDataHelper.add(xml, sessionId, "srv024_receiptInfoQuery");
        try {
            int contentLength = saq.getBytes(RequestContextUtils.getCharset()).length;
            RequestContextUtils.setRunningParam((String)"contentLength", (String)(contentLength + ""));
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return saq;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        Element opRep = GZCBEBankDataHelper.checkHead(s);
        Element opResultSet = DomHelper.getChildElementNotNull(opRep, "opResultSet");
        List rows = opResultSet.getChildren("opResult");
        ArrayList<ReceiptInfo> receiptInfos = new ArrayList<ReceiptInfo>(8);
        for (int i = 0; i < rows.size(); ++i) {
            Element row = (Element)rows.get(i);
            String YWLS = DomHelper.getChildTextNotNull(row, "YWLS", "YWLS");
            String JYLS = DomHelper.getChildTextNotNull(row, "JYLS", "JYLS");
            String SKZH = DomHelper.getChildTextNotNull(row, "SKZH", "SKZH");
            String JDFX = DomHelper.getChildTextNotNull(row, "JDFX", "JDFX");
            String JYJE = DomHelper.getChildTextNotNull(row, "JYJE", "JYJE");
            ReceiptInfo receiptInfo = new ReceiptInfo();
            receiptInfo.setYwls(YWLS);
            receiptInfo.setJyls(JYLS);
            receiptInfo.setZhao(bankReceiptRequest.getAccNo());
            receiptInfo.setSkzh(SKZH);
            receiptInfo.setJyje(JDFX);
            receiptInfo.setJdfx(JYJE);
            receiptInfo.setTranDate(bankReceiptRequest.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            receiptInfos.add(receiptInfo);
        }
        return BankReceiptResponseEB.success(receiptInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        String encoding = RequestContextUtils.getCharset();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"uri"));
        String contentLength = RequestContextUtils.getRunningParam((String)"contentLength");
        factory.setHttpHeader("Content-Length", contentLength);
        factory.setHttpHeader("Content-Type", "text/xml; charset=" + encoding);
    }
}

