/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cus;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.receipt.banks.cus.BankBusinessConfig;
import kd.ebg.receipt.banks.cus.service.receipt.download.ReceiptDownloadImpl;
import kd.ebg.receipt.banks.cus.service.receipt.fetch.ReceiptFetchImpl;
import kd.ebg.receipt.business.receipt.query.FileReceiptImpl;
import kd.ebg.receipt.common.cache.CUSMetaDataCache;
import kd.ebg.receipt.common.framework.bank.meta.template.CUSMetaDataTemplate;
import kd.ebg.receipt.common.framework.properties.BankPropertyConfig;
import kd.sdk.ebg.cus.api.ISDKBankReceiptMetaData;
import kd.sdk.ebg.cus.bean.SDKBankBean;
import kd.sdk.ebg.cus.bean.SDKBankLoginConfigBean;
import kd.sdk.ebg.cus.bean.SDKDetailNoBean;
import kd.sdk.ebg.cus.bean.SDKMultiLangBean;

public class CusBankMetaDataImpl
extends CUSMetaDataTemplate {
    public void baseConfigInit() {
        ISDKBankReceiptMetaData bankMetaData = this.getBankSDKMetaData();
        if (bankMetaData != null) {
            SDKBankBean bankBean = bankMetaData.getBankBean();
            this.setExchangeProtocol(bankBean.getProtocol().getName());
            this.setCharSet(bankBean.getCharSet().getName());
            this.setTimeOut(bankBean.getTimeout_minute());
        } else {
            this.setExchangeProtocol("TCP");
            this.setCharSet("GB18030");
            this.setTimeOut(3);
        }
    }

    public void metaDataInit() {
        this.setBankName("CUS");
        this.setBankVersionID("CUS");
        this.setBankShortName("CUS");
        this.setBankVersionName("CUS Chinese");
        this.setDescription("CUS Chinese");
        this.setKeyNames(Lists.newArrayList((Object[])new String[]{"CUS"}));
    }

    public List<BankLoginConfig> getBankLoginReceiptBaseConfig() {
        ArrayList<BankLoginConfig> list = new ArrayList<BankLoginConfig>(1);
        ISDKBankReceiptMetaData bankMetaData = this.getBankSDKMetaData();
        if (bankMetaData != null) {
            List bankLoginConfigBeanList = bankMetaData.getBankLoginReceiptConfigBean();
            for (SDKBankLoginConfigBean bean : bankLoginConfigBeanList) {
                list.add(this.getBankLoginConfig(bean));
            }
        }
        return list;
    }

    public boolean isSupportTodayReceipt() {
        ISDKBankReceiptMetaData bankMetaData = this.getBankSDKMetaData();
        if (bankMetaData != null) {
            return bankMetaData.isSupportTodayReceipt();
        }
        return false;
    }

    public boolean showAchieveWay() {
        ISDKBankReceiptMetaData bankMetaData = this.getBankSDKMetaData();
        if (bankMetaData != null) {
            return bankMetaData.showAchieveWay();
        }
        return false;
    }

    private ISDKBankReceiptMetaData getBankSDKMetaData() {
        EBContext ebContext = EBContext.getContext();
        if (ebContext != null) {
            String bankVersionID = ebContext.getBankVersionID();
            ISDKBankReceiptMetaData bankMetaData = CUSMetaDataCache.getInstance().getCUSMetaDataImpl(bankVersionID);
            return bankMetaData;
        }
        return null;
    }

    private BankLoginConfig getBankLoginConfig(SDKBankLoginConfigBean bean) {
        BankLoginConfig bankLoginConfig = BankLoginConfigUtil.getMlBankLoginConfig((String)bean.getId(), (MultiLangEnumBridge)this.getMultiLangEnumBridge(bean.getMultiLangName()), (MultiLangEnumBridge)this.getMultiLangEnumBridge(bean.getMultiLangDesc()), (String)bean.getDefaultValue(), (boolean)bean.isReadonly(), (boolean)bean.isNullable(), (boolean)bean.isPassword());
        if (bean.getInputType() != null) {
            bankLoginConfig.setInputType(bean.getInputType().getInputType());
        }
        return bankLoginConfig;
    }

    private MultiLangEnumBridge getMultiLangEnumBridge(SDKMultiLangBean bean) {
        return new MultiLangEnumBridge(bean.getDescription(), bean.getDescription(), bean.getSystemType());
    }

    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList((Object[])new Class[]{FileReceiptImpl.class, ReceiptDownloadImpl.class, ReceiptFetchImpl.class});
    }

    public BankPropertyConfig getPropertyConfig() {
        return new BankBusinessConfig();
    }

    public Map<String, Map<String, String>> getDetailNoRule() {
        HashMap result = Maps.newHashMapWithExpectedSize((int)1);
        HashMap ruleMap = Maps.newHashMapWithExpectedSize((int)1);
        result.put("receipt_default", ruleMap);
        ISDKBankReceiptMetaData bankMetaData = this.getBankSDKMetaData();
        if (bankMetaData != null) {
            SDKDetailNoBean bean = bankMetaData.getDetailNoBean();
            ruleMap.put("accNo", bean.getAccNoMapping());
            ruleMap.put("oppAccNo", bean.getOppAccNoMapping());
            ruleMap.put("transDate", bean.getTransDateMapping());
            ruleMap.put("Amount", bean.getAmountMapping());
            ruleMap.put("cdFlag", bean.getCdFlagMapping());
            ruleMap.put("serialNo", bean.getSerialNoMapping());
        } else {
            ruleMap.put("accNo", "accNo");
            ruleMap.put("oppAccNo", "oppAccNo");
            ruleMap.put("transDate", "transDate");
            ruleMap.put("Amount", "Amount");
            ruleMap.put("cdFlag", "cdFlag");
            ruleMap.put("serialNo", "serialNo");
        }
        return result;
    }
}

