/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gxnx.cmp.service.receipt;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.gxnx.cmp.service.receipt.detail.ReceiptDetailImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IReceipt;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.ReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.ReceiptResponseEB;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.framework.receipt.bank.BankLoginReceiptProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.model.DetailInfo;

public class ReceiptImpl
extends AbstractReceiptImpl
implements IReceipt {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(ReceiptRequest receiptRequest) {
        return null;
    }

    public ReceiptResponseEB queryReceipt(ReceiptRequest request) {
        ArrayList<ReceiptInfo> receiptInfos = new ArrayList<ReceiptInfo>();
        ReceiptResponseEB receiptResponse = new ReceiptResponseEB();
        String accNo = request.getAcnt().getAccNo();
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        ReceiptDetailImpl detail = new ReceiptDetailImpl();
        List<DetailInfo> detailInfos = detail.queryTransDetail(accNo, startDate, endDate);
        if (detailInfos != null && detailInfos.size() > 0) {
            for (int i = 0; i < detailInfos.size(); ++i) {
                DetailInfo detailInfo = detailInfos.get(i);
                ReceiptInfo info = new ReceiptInfo();
                info.setAccNo(detailInfo.getAccNo());
                info.setAccName(detailInfo.getAccName());
                info.setBankName(detailInfo.getBankName());
                info.setDebitAmount(detailInfo.getDebitAmount().toString());
                info.setCreditAmount(detailInfo.getCreditAmount().toString());
                info.setOppAccNo(detailInfo.getOppAccNo());
                info.setOppAccName(detailInfo.getOppAccName());
                info.setOppBankName(detailInfo.getOppAccName());
                if (detailInfo.getTransDate() != null) {
                    info.setTransDate(LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate()));
                }
                info.setExplanation(detailInfo.getExplanation());
                info.setRemark(detailInfo.getUseCn());
                String billKey = detailInfo.getReceiptNo();
                info.setEbillKey(billKey);
                info.setTranSerialNo(detailInfo.getBizRefNo());
                if (detailInfo.getCreditAmount().compareTo(BigDecimal.ZERO) > 0) {
                    info.setAmount(detailInfo.getCreditAmount().toString());
                } else {
                    info.setAmount(detailInfo.getDebitAmount().toString());
                }
                String jsonStr = detailInfo.getJson();
                JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                jsonObject.put("oppAccNo", (Object)detailInfo.getOppAccNo());
                jsonStr = jsonObject.toJSONString();
                info.setJson(jsonStr);
                String receiptNo = MatchRule.getInstance().getReceiptMatchNo(request.getAcnt().getAccNo(), info.getTransDate(), jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                info.setReceiptNo(receiptNo);
                receiptInfos.add(info);
            }
            receiptResponse.setFileFlag(0);
            receiptResponse.setCompleteFlag(0);
            receiptResponse.setReceiptInfos(receiptInfos);
        }
        return receiptResponse;
    }

    public ReceiptResponseEB parse(ReceiptRequest receiptRequest, String s) {
        return null;
    }

    public boolean match(ReceiptRequest request) {
        if (request.getHeader() != null) {
            String bankLoginId = request.getHeader().getBankLoginID();
            BankLoginReceiptProperties bankLoginReceiptProperties = (BankLoginReceiptProperties)EBConfigBuilder.getInstance().buildConfig(BankLoginReceiptProperties.class, bankLoginId);
            if (Objects.equals(bankLoginReceiptProperties.getIsNSyncDownloadReceipt(), "off")) {
                return true;
            }
            return Objects.equals(request.getHeader().getClientName(), "SYSTEM_RECEIPT_API");
        }
        return false;
    }
}

