/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gxnx.cmp.service.receipt.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.gxnx.cmp.service.receipt.utils.Packer;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.atomic.IHisDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class ReceiptDetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/corporbank/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        String currentPage = this.getCurrentPage();
        String page = currentPage.equalsIgnoreCase("0") ? "1" : currentPage;
        String detailStr = Packer.packDetail(bankDetailRequest, page);
        return "CBE023|#" + detailStr;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        String currentPage = this.getCurrentPage();
        int nextPage = Integer.parseInt(currentPage) + 20;
        this.setCurrentPage(String.valueOf(nextPage));
        int index = rspStr.indexOf("#");
        String[] split = rspStr.substring(0, index).split("\\|");
        String responseCode = split[0];
        if (!"0000".equalsIgnoreCase(responseCode)) {
            String responseMsg = split[1];
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u67e5\u8be2\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s \u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"DetailImpl_0", (String)"ebg-receipt-banks-gxnx-cmp", (Object[])new Object[0]), responseCode, responseMsg));
        }
        String body = rspStr.substring(index + 1);
        body = Packer.decodeResponse(body);
        Element root = JDomUtils.string2Root((String)body, (String)RequestContextUtils.getCharset());
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        String turnPageTotalQnt = JDomUtils.getChildText((Element)opRep, (String)"turnPageTotalQnt");
        if (nextPage >= Integer.parseInt(turnPageTotalQnt)) {
            this.setLastPage(true);
        } else {
            this.setLastPage(false);
        }
        BankAcnt acnt = bankDetailRequest.getAcnt();
        Element list = JDomUtils.getChildElementNotNull((Element)opResult, (String)"list");
        List row = list.getChildren();
        ArrayList<DetailInfo> results = new ArrayList<DetailInfo>(20);
        for (int i = 0; i < row.size(); ++i) {
            Element element = (Element)row.get(i);
            String retNo = JDomUtils.getChildText((Element)element, (String)"retNo");
            String tranStan = JDomUtils.getChildText((Element)element, (String)"tranStan");
            String payAccount = JDomUtils.getChildText((Element)element, (String)"payAccount");
            String payAccountName = JDomUtils.getChildText((Element)element, (String)"payAccountName");
            String openNodeName = JDomUtils.getChildText((Element)element, (String)"openNodeName");
            String recAccount = JDomUtils.getChildText((Element)element, (String)"recAccount");
            String recAccountName = JDomUtils.getChildText((Element)element, (String)"recAccountName");
            String recAccountOpenBank = JDomUtils.getChildText((Element)element, (String)"recAccountOpenBank");
            String payAmount = JDomUtils.getChildText((Element)element, (String)"payAmount");
            String remark = JDomUtils.getChildText((Element)element, (String)"sPostS");
            String payUse = JDomUtils.getChildText((Element)element, (String)"payUse");
            String orderSubmitTime = JDomUtils.getChildText((Element)element, (String)"orderSubmitTime");
            DetailInfo info = new DetailInfo();
            info.setReceiptNo(retNo);
            if (Objects.equals(acnt.getAccNo(), payAccount)) {
                info.setDebitAmount(new BigDecimal(payAmount));
                info.setCreditAmount(BigDecimal.ZERO);
                info.setAccNo(payAccount);
                info.setAccName(payAccountName);
                info.setBankName(openNodeName);
                info.setOppAccNo(recAccount);
                info.setOppAccName(recAccountName);
                info.setOppBankName(recAccountOpenBank);
            } else {
                info.setCreditAmount(new BigDecimal(payAmount));
                info.setDebitAmount(BigDecimal.ZERO);
                info.setAccNo(recAccount);
                info.setAccName(recAccountName);
                info.setBankName(recAccountOpenBank);
                info.setOppAccNo(payAccount);
                info.setOppAccName(payAccountName);
                info.setOppBankName(openNodeName);
            }
            if (EBGStringUtils.isNotEmpty((String)orderSubmitTime) && orderSubmitTime.length() >= 8) {
                info.setTransDate(LocalDate.parse(orderSubmitTime.substring(0, 8), DateTimeFormatter.ofPattern("yyyyMMdd")));
            }
            info.setExplanation(remark);
            info.setUseCN(payUse);
            info.setBizRefNo(tranStan);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(element);
            info.setJson(jsonStr);
            results.add(info);
        }
        return new EBBankDetailResponse(results);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE023";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u67e5\u8be2", (String)"DetailImpl_3", (String)"ebg-receipt-banks-gxnx-cmp", (Object[])new Object[0]);
    }

    public List<DetailInfo> queryTransDetail(String accNo, LocalDate startDate, LocalDate endDate) {
        BankAcnt acnt = new BankAcnt();
        acnt.setAccNo(accNo);
        BankHeader header = new BankHeader();
        header.setAcnt(acnt);
        BankDetailRequest bankDetailRequest = new BankDetailRequest();
        bankDetailRequest.setStartDate(startDate);
        bankDetailRequest.setEndDate(endDate);
        bankDetailRequest.setHeader(header);
        this.setCurrentPage("0");
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        boolean lastPage = false;
        this.setLastPage(false);
        while (!lastPage) {
            EBBankDetailResponse response = this.doBiz(bankDetailRequest);
            List receiveItems = response.getDetails();
            if (Objects.nonNull(response) && Objects.nonNull(receiveItems)) {
                detailInfos.addAll(receiveItems);
            }
            lastPage = this.isLastPage();
        }
        return detailInfos;
    }
}

