/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hsb.dc.service.receipt.fetch;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.banks.hsb.dc.service.receipt.api.DetailImpl;
import kd.ebg.receipt.banks.hsb.dc.service.receipt.api.GetBankReceiptFileNameImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        DownloadListTask task = this.downloadTaskService.findById(taskId);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        HashMap existMap = Maps.newHashMapWithExpectedSize((int)1);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
            existMap.put(downloadListDetail.getFileName(), downloadListDetail);
        }
        String accNo = task.getAccNo();
        String transDateStr = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate transDate = task.getTransDate();
        DetailImpl bankReceiptQuery = new DetailImpl();
        List detailInfoList = bankReceiptQuery.queryTransDetail(accNo, transDate, transDate);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        GetBankReceiptFileNameImpl getBankReceiptFile = new GetBankReceiptFileNameImpl();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        for (DetailInfo detail : detailInfoList) {
            String fileName = BankReceiptFetchListImpl.packFileName(accNo, transDateStr, detail, countMap);
            if (existMap.containsKey(fileName)) {
                DownloadListDetail downloadListDetail = (DownloadListDetail)existMap.get(fileName);
                downloadListDetail.setReceiptJson(detail.getJson());
                result.add(downloadListDetail);
                continue;
            }
            try {
                HashMap paramMap = Maps.newHashMapWithExpectedSize((int)3);
                String tr_acdt = detail.getReversed1();
                String serial_no = detail.getReversed2();
                String account_seq = detail.getReversed3();
                paramMap.put("tr_acdt", tr_acdt);
                paramMap.put("serial_no", serial_no);
                paramMap.put("account_seq", account_seq);
                bankReceiptRequest.setParamsMap((Map)paramMap);
                BankReceiptResponseEB receiptResponseEB = getBankReceiptFile.doBiz(bankReceiptRequest);
                if (receiptResponseEB.getCode() != BankReceiptResponseEB.ResultEnum.SUCCESS.getCode()) continue;
                String receiptFileName = (String)receiptResponseEB.getData();
                DownloadListDetail downloadListDetail = new DownloadListDetail();
                downloadListDetail.setFileName(fileName);
                downloadListDetail.setFileLink(receiptFileName);
                downloadListDetail.setReceiptJson(detail.getJson());
                result.add(downloadListDetail);
            }
            catch (Throwable e) {
                logger.error("\u8c03\u7528\u56de\u5355\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage(), e);
            }
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-hsb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public static String packFileName(String accNo, String transDateStr, DetailInfo detail, Map<String, Integer> countMap) {
        String tr_acdt = detail.getReversed1();
        String serial_no = detail.getReversed2();
        String account_seq = detail.getReversed3();
        StringBuilder sb = new StringBuilder();
        sb.append(accNo).append("_");
        sb.append(transDateStr).append("_");
        sb.append(tr_acdt).append("_");
        sb.append(serial_no).append("_");
        sb.append(account_seq);
        String orderNo = sb.toString();
        if (countMap.containsKey(orderNo)) {
            int serial = countMap.get(orderNo) + 1;
            countMap.put(orderNo, serial);
            sb.append("_").append(String.format("%04d", serial));
        } else {
            countMap.put(orderNo, 0);
        }
        sb.append(".pdf");
        return sb.toString();
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean isBreak() {
        return true;
    }
}

