/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cbhb.dc.service.receipt;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.cbhb.dc.BankBusinessConfig;
import kd.ebg.receipt.banks.cbhb.dc.service.receipt.CbhbDcCommConfig;
import kd.ebg.receipt.banks.cbhb.dc.service.receipt.CbhbDcFileParser;
import kd.ebg.receipt.banks.cbhb.dc.service.receipt.utils.RequestPacker;
import kd.ebg.receipt.banks.cbhb.dc.service.receipt.utils.ResponseParser;
import kd.ebg.receipt.banks.cbhb.dc.service.receipt.utils.SocketUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankLoginProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest bankReceiptHandleRequest) {
        this.init(bankReceiptHandleRequest);
        long taskId = bankReceiptHandleRequest.getTaskId();
        DownloadListTask task = this.downloadTaskService.findById(taskId);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        DownloadListDetail detail = null;
        BankLoginProperties loginProperties = (BankLoginProperties)EBConfigBuilder.getInstance().buildConfig(BankLoginProperties.class, task.getBankLoginId());
        String host = loginProperties.getIp();
        int port = loginProperties.getPort();
        List listDetails = this.downloadListDetailService.selectByRefId(bankReceiptHandleRequest.getTaskId());
        HashMap existFileName = Maps.newHashMapWithExpectedSize((int)1);
        for (DownloadListDetail downloadListDetail : listDetails) {
            CbhbDcFileParser cbhbDcFileParser = new CbhbDcFileParser();
            cbhbDcFileParser.setFileName(downloadListDetail.getFileName());
            int length = cbhbDcFileParser.getFileSplitLength();
            if (length < 5) {
                List ids = listDetails.stream().map(o -> o.getId()).collect(Collectors.toList());
                this.downloadListDetailService.deleteAll(ids);
                continue;
            }
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
            existFileName.put(downloadListDetail.getFileName(), downloadListDetail);
        }
        CbhbDcCommConfig config = (CbhbDcCommConfig)EBConfigBuilder.getInstance().buildConfig(CbhbDcCommConfig.class, task.getBankLoginId());
        String cifNo = config.getCifNo();
        String userId = config.getUserID();
        int receiptFilePort = config.getReceiptFilePort();
        String acNo = task.getAccNo();
        String transDate = LocalDateUtil.formatDate((LocalDate)task.getTransDate());
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>(16);
        boolean isSubAccNo = BankBusinessConfig.isSubAccNo(acNo);
        String detailRequest = RequestPacker.detailPack(transDate, cifNo, userId, isSubAccNo, acNo);
        String detailResponse = SocketUtils.sendRequest(detailRequest, host, port);
        ResponseParser.detailParser(detailResponse, mapList);
        if (mapList.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u6e24\u6d77\u94f6\u884c\u54cd\u5e94\u56de\u5355\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8be5\u65e5\u671f\u662f\u5426\u6709\u4ea4\u6613\u660e\u7ec6\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-cbhb-dc", (Object[])new Object[0]));
        }
        Map map = null;
        for (int i = 0; i < mapList.size(); ++i) {
            map = (Map)mapList.get(i);
            String printTaskId = (String)map.get("printTaskId");
            String amount = (String)map.get("amount");
            String vouch_Type = (String)map.get("vouch_Type");
            if (Objects.equals("BH001", vouch_Type)) continue;
            try {
                String newFileName;
                String receiptRequest = RequestPacker.receiptPack(cifNo, printTaskId, vouch_Type, userId, isSubAccNo, acNo);
                String receiptResponse = SocketUtils.sendRequest(receiptRequest, host, port);
                Map<String, String> map1 = ResponseParser.receiptParser(receiptResponse);
                String HLOGN = map1.get("HLOGN");
                String PDFUrl = map1.get("PDFUrl");
                if (!EBGStringUtils.isNotEmpty((String)PDFUrl)) continue;
                String receiptFileType = ".pdf";
                if (PDFUrl.toLowerCase(Locale.ENGLISH).endsWith(".ofd")) {
                    receiptFileType = ".ofd";
                }
                if (!existFileName.containsKey(newFileName = task.getAccNo() + "_" + task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE) + "_" + HLOGN + "_" + amount + "_" + printTaskId + receiptFileType)) {
                    String respondCode = SocketUtils.sendDownloadRequest(PDFUrl, host, receiptFilePort);
                    if ("000000".equals(respondCode)) {
                        log.info("\u6e24\u6d77\u94f6\u884c\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f");
                    } else {
                        if ("999999".equals(respondCode)) {
                            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7801\uff1a%s\u56de\u5355\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"BankReceiptFetchListImpl_6", (String)"ebg-receipt-banks-cbhb-dc", (Object[])new Object[0]), respondCode));
                        }
                        if ("E20001".equals(respondCode)) {
                            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7801\uff1a%s\u6587\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"BankReceiptFetchListImpl_7", (String)"ebg-receipt-banks-cbhb-dc", (Object[])new Object[0]), respondCode));
                        }
                    }
                    detail = new DownloadListDetail();
                    detail.setFileLink(PDFUrl);
                    detail.setFileName(newFileName);
                } else {
                    detail = (DownloadListDetail)existFileName.get(newFileName);
                }
                result.add(detail);
                continue;
            }
            catch (Throwable e) {
                log.error("download-error:" + e.getMessage(), e);
            }
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_4", (String)"ebg-receipt-banks-cbhb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBHB_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u6e24\u6d77\u94f6\u884c\u76f4\u8fde\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_5", (String)"ebg-receipt-banks-cbhb-dc", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return true;
    }
}

