/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmb.dc.service.receipt;

import com.google.common.collect.Maps;
import com.jcraft.jsch.ChannelSftp;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.cmb.dc.service.CMBDCCommConfig;
import kd.ebg.receipt.banks.cmb.dc.service.receipt.api.BankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.bank.ReceiptSystemProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.utils.ReceiptCommonAipUtil;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.repository.DetailInfoRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    private String reciptTypeList;
    public DownloadListDetailService downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public boolean isOnlyBySyncRecord() {
        ReceiptSystemProperties receiptSystemProperties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        String isOnlyBySyncRecord = receiptSystemProperties.getIsOnlyBySyncRecord();
        return Objects.equals(isOnlyBySyncRecord, "true");
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        long taskId = request.getTaskId();
        String customId = EBContext.getContext().getCustomID();
        Object sftp = null;
        String clientId = null;
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bankLoginId = request.getBankLoginId();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        BankFtpProperties ftpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        String sftp_path = ftpProperties.getFtpPath();
        sftp_path = EBGStringUtils.isNotEmpty((String)sftp_path) ? sftp_path : "/";
        String frontProxyPath = ftpProperties.getFrontProxyPath();
        IParameter parameter = EBContext.getContext().getParameter();
        clientId = parameter.getBankParameter("LGNNAM");
        CMBDCCommConfig config = (CMBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(CMBDCCommConfig.class, bankLoginId);
        this.reciptTypeList = config.getReceiptTypeList();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        DownloadListDetail detail = null;
        String date = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        DetailInfoRepository detailInfoRepository = (DetailInfoRepository)SpringContextUtil.getBean(DetailInfoRepository.class);
        int detailCount = detailInfoRepository.countDetailByAccNoAndTransDate(accNo, transDate);
        long diffDays = ChronoUnit.DAYS.between(transDate, LocalDate.now());
        boolean isBeforeThreeMonth = diffDays > 90L;
        boolean isPullDetail = ReceiptCommonAipUtil.isPullRecordByCustomIdTransDateAndAccNo((String)customId, (LocalDate)transDate, (String)accNo);
        boolean isNeedQuery = false;
        if ((!this.isOnlyBySyncRecord() && !isBeforeThreeMonth || isPullDetail && !isBeforeThreeMonth) && detailCount > 0) {
            isNeedQuery = true;
        }
        if (this.isOnlyBySyncRecord() && !isPullDetail) {
            isNeedQuery = true;
        }
        if (isBeforeThreeMonth) {
            isNeedQuery = true;
        }
        if (isNeedQuery) {
            this.sendAndReceiveReceipt(accNo, transDate, clientId);
            detail = new DownloadListDetail();
            detail.setFileName(String.format("%s_%s.zip", accNo, transDate.toString()));
            detail.setFileLink(String.format("%s_%s.zip", accNo, transDate.toString()));
            result.add(detail);
        }
        if (!isNeedQuery && detailCount == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-cmb-dc", (Object[])new Object[0]));
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-cmb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    private List<String> getFileByName(String matchString, String accNo, LocalDate transDate) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.getFileByName(matchString);
    }

    private long getDataSize(String matchString, String accNo, LocalDate transDate) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.getFileSize(matchString);
    }

    private long getDataSize(String matchString, Vector ls) {
        long dataSize = 0L;
        for (Object l : ls) {
            ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)l;
            if (file.getAttrs().isDir() || !file.getFilename().startsWith(matchString)) continue;
            dataSize += file.getAttrs().getSize();
        }
        return dataSize;
    }

    private void sendAndReceiveReceipt(String accNo, LocalDate date, String clientId) {
        if (this.reciptTypeList != null && this.reciptTypeList.length() > 0) {
            String[] codes = this.reciptTypeList.split(";");
            for (int i = 0; i < codes.length; ++i) {
                HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)8);
                paramsMap.put("code", codes[i]);
                paramsMap.put("rrcflg", "1");
                paramsMap.put("clientId", clientId);
                BankReceiptRequest request = BankReceiptRequest.builder().accNo(accNo).transDate(date).paramsMap((Map)paramsMap).build();
                BankReceiptImpl iBankReceipt = new BankReceiptImpl();
                iBankReceipt.doBiz((BankRequest)request);
                paramsMap.put("rrcflg", "2");
                request.setParamsMap((Map)paramsMap);
                iBankReceipt.doBiz((BankRequest)request);
            }
        } else {
            HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)8);
            paramsMap.put("rrcflg", "1");
            paramsMap.put("clientId", clientId);
            BankReceiptRequest request = BankReceiptRequest.builder().accNo(accNo).transDate(date).paramsMap((Map)paramsMap).build();
            BankReceiptImpl iBankReceipt = new BankReceiptImpl();
            iBankReceipt.doBiz((BankRequest)request);
            paramsMap.put("rrcflg", "2");
            request.setParamsMap((Map)paramsMap);
            iBankReceipt.doBiz((BankRequest)request);
        }
    }

    public boolean isBreak() {
        return true;
    }

    private void wait(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CMB_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u62db\u884c\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-cmb-dc", (Object[])new Object[0]);
    }
}

