/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.psbc.srdc.service.receipt.api;

import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.psbc.srdc.service.util.DomHelper;
import kd.ebg.receipt.banks.psbc.srdc.service.util.Packer;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import org.jdom2.Element;

public class ReceiptInfoRequestImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(ReceiptInfoRequestImpl.class);

    public String pack(BankReceiptRequest request) {
        Element root = Packer.createReqRootElement("5006");
        Element Param = JDomUtils.addChild((Element)root, (String)"Param");
        JDomUtils.addChild((Element)Param, (String)"Account", (String)request.getAccNo());
        JDomUtils.addChild((Element)Param, (String)"Tx_Date", (String)request.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Param, (String)"Cli_serial", (String)request.getRequestStr());
        JDomUtils.addChild((Element)Param, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved2", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved3", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved4", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2String((Element)root, (String)encoding);
        String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        if ("http".equalsIgnoreCase(protocol)) {
            return xmlStr;
        }
        String requestStr = Packer.createCommonMsg(xmlStr);
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element Head = DomHelper.getChildElementNotNull(root, "Head");
        String OpRetCode = Head.getChildText("OpRetCode");
        if (Objects.equals("000000", OpRetCode)) {
            Element Param = DomHelper.getChildElementNotNull(root, "Param");
            try {
                String fileName = DomHelper.getChildTextNotNull(Param, "File_name", "File_name is null");
                return BankReceiptResponseEB.success((Object)fileName);
            }
            catch (Exception e) {
                log.error("\u538b\u7f29\u5305\u6a21\u5f0f\u89e3\u6790\u62a5\u6587\u5931\u8d25\uff1a{}" + e.getMessage(), (Throwable)e);
                try {
                    List RecordSets = Param.getChildren("RecordSet");
                    Map paramMap = request.getParamsMap();
                    String Reserved2 = (String)paramMap.get("Reserved2");
                    for (Element RecordSet : RecordSets) {
                        String fileName = RecordSet.getChildText("File_name");
                        if (!fileName.contains(Reserved2)) continue;
                        return BankReceiptResponseEB.success((Object)fileName);
                    }
                    return null;
                }
                catch (Exception e2) {
                    log.error("\u5faa\u73af\u57df\u6a21\u5f0f\u89e3\u6790\u62a5\u6587\u5931\u8d25\uff1a{}" + e2.getMessage(), (Throwable)e2);
                    return null;
                }
            }
        }
        String OpRetMsg = Head.getChildText("OpRetMsg");
        String msg = String.format(ResManager.loadKDString((String)"5006\u63a5\u53e3\u8fd4\u56de\u9519\u8bef\uff0c\u9519\u8bef\u7801\uff1a%1$s-\u9519\u8bef\u63cf\u8ff0:%2$s", (String)"ReceiptInfoRequestImpl_4", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]), OpRetCode, OpRetMsg);
        throw new ReceiptException(msg);
    }

    public String recv(InputStream inputStream) {
        return ReceiptInfoRequestImpl.parseRecvMsg(super.recv(inputStream));
    }

    public static String parseRecvMsg(String input) {
        if (!StringUtils.isEmpty((String)input)) {
            String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
            if ("http".equalsIgnoreCase(protocol)) {
                return input;
            }
            return input.substring(10);
        }
        return "";
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"\u51ed\u8bc1\u4e0b\u8f7d\uff085006\uff09", (String)"ReceiptInfoRequestImpl_2", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51ed\u8bc1\u4e0b\u8f7d", (String)"ReceiptInfoRequestImpl_3", (String)"ebg-receipt-banks-psbc-srdc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        if ("http".equalsIgnoreCase(protocol)) {
            String requesturl = RequestContextUtils.getBankParameterValue((String)"exchangeUri");
            factory.setUri(requesturl);
            factory.setHttpHeader("content-type", "application/xml;charset=GBK");
        } else {
            factory.setHttpHeader("Content-Type", "text/xml");
        }
    }
}

