/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hxb.dc.service.receipt.api;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.receipt.banks.hxb.dc.service.receipt.api.ReceiptPacker;
import kd.ebg.receipt.banks.hxb.dc.service.receipt.api.ReceiptParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class HxbDcReceiptDetailQuery
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HxbDcReceiptDetailQuery.class);

    public String pack(BankReceiptRequest bankDetailRequest) {
        String accNo = bankDetailRequest.getAccNo();
        String transDateStr = bankDetailRequest.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        int currentPage = Integer.parseInt(this.getCurrentPage());
        String receiptRequest = ReceiptPacker.packXhj8035(accNo, bankDetailRequest.getTransDate(), currentPage);
        logger.info("\u534e\u590f\u94f6\u884c\u2014\u2014xhj8035\u7535\u5b50\u56de\u5355\u660e\u7ec6\u67e5\u8be2\u8bf7\u6c42-{}-{}\uff1a{}", new Object[]{accNo, transDateStr, receiptRequest});
        return receiptRequest;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        String accNo = request.getAccNo();
        String transDateStr = request.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        logger.info("\u534e\u590f\u94f6\u884c\u2014\u2014xhj8035\u7535\u5b50\u56de\u5355\u660e\u7ec6\u67e5\u8be2\u54cd\u5e94-{}-{}\uff1a{}", new Object[]{accNo, transDateStr, responseStr});
        BankReceiptResponseEB receiptResponseEB = ReceiptParser.parseXhj8035(request, responseStr);
        return receiptResponseEB;
    }

    public static List<String> queryReceiptDetail(String accNo, LocalDate transDate) {
        ArrayList<String> detailInfos = new ArrayList<String>(1);
        HxbDcReceiptDetailQuery query = new HxbDcReceiptDetailQuery();
        BankReceiptRequest bankDetailRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
        query.setCurrentPage("1");
        query.setLastPage(false);
        while (!query.isLastPage()) {
            BankReceiptResponseEB response = query.doBiz(bankDetailRequest);
            if (Objects.nonNull(response) && Objects.nonNull(response.getData())) {
                detailInfos.addAll((List)response.getData());
                int currentPage = Integer.parseInt(query.getCurrentPage());
                query.setCurrentPage(currentPage + 1);
                continue;
            }
            query.setLastPage(true);
        }
        return detailInfos;
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "xhj8035";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u660e\u7ec6\u67e5\u8be2", (String)"HxbDcReceiptDetailQuery_0", (String)"ebg-receipt-banks-hxb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
    }
}

