/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.pab.dc.service.receipt;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.receipt.banks.pab.dc.service.receipt.PABDCCommConfig;
import kd.ebg.receipt.banks.pab.dc.service.receipt.PABDCFileParser;
import kd.ebg.receipt.banks.pab.dc.service.receipt.TodayReceiptInfo;
import kd.ebg.receipt.banks.pab.dc.service.receipt.util.DetailInfo;
import kd.ebg.receipt.banks.pab.dc.service.receipt.util.ErrorCodeEnum;
import kd.ebg.receipt.banks.pab.dc.service.receipt.util.HistoryReceiptInfo;
import kd.ebg.receipt.banks.pab.dc.service.receipt.util.ReceiptInfo;
import kd.ebg.receipt.banks.pab.dc.service.receipt.util.RequestPacker;
import kd.ebg.receipt.banks.pab.dc.service.receipt.util.ResponseParser;
import kd.ebg.receipt.banks.pab.dc.service.receipt.util.SocletUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest bankReceiptHandleRequest) {
        List<Object> detailList;
        block13: {
            this.init(bankReceiptHandleRequest);
            long taskId = bankReceiptHandleRequest.getTaskId();
            DownloadListTask task = this.downloadTaskService.findById(taskId);
            detailList = new ArrayList(16);
            String accNo = task.getAccNo();
            String transDate = task.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
            String bankLoginId = EBContext.getContext().getBankLoginID();
            PABDCCommConfig config = (PABDCCommConfig)EBConfigBuilder.getInstance().buildConfig(PABDCCommConfig.class, bankLoginId);
            String transCode = config.getQueryReceiptInt();
            HashMap existMap = Maps.newHashMapWithExpectedSize((int)1);
            HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
            for (DownloadListDetail detail : downloadListDetails) {
                if (detail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
                PABDCFileParser pabdcFileParser = new PABDCFileParser();
                String newFileName = detail.getFileName();
                pabdcFileParser.setFileName(newFileName);
                String HostTrace = pabdcFileParser.getParsedString(2);
                String DcFlag = pabdcFileParser.getParsedString(3);
                String AbstractStr = pabdcFileParser.getParsedString(4);
                if (Objects.equals(transCode, "ELC009")) {
                    newFileName = accNo + "_" + transDate + "_" + HostTrace + "_" + DcFlag + "_" + AbstractStr + ".pdf";
                    if (countMap.containsKey(newFileName)) {
                        int count = (Integer)countMap.get(newFileName) + 1;
                        countMap.put(newFileName, count);
                        newFileName = accNo + "_" + transDate + "_" + HostTrace + "_" + DcFlag + "_" + AbstractStr + "_" + String.format("%04d", count) + ".pdf";
                    } else {
                        countMap.put(newFileName, 0);
                    }
                    existMap.put(newFileName, detail);
                    continue;
                }
                if (pabdcFileParser.getFileSplitLength() >= 7) continue;
                this.downloadListDetailService.deleteById(detail.getId());
            }
            if (bankReceiptHandleRequest.getTransDate().isEqual(LocalDate.now())) {
                detailList = this.doJob_today(task, transDate, accNo, existMap);
            } else {
                try {
                    if (Objects.equals(transCode, "ELC009") || bankReceiptHandleRequest.getTransDate().minusDays(-15L).isBefore(LocalDate.now())) {
                        return BankReceiptHandleResponseEB.success(this.queryReceiptByELC009(bankReceiptHandleRequest, existMap));
                    }
                    String request = RequestPacker.receiptDetailRequest(transCode, accNo, transDate);
                    EBContext.getContext().setType("request");
                    logger.info("\u5e73\u5b89\u94f6\u884c\u76f4\u8fde\u7248-\u56de\u5355\u6587\u4ef6\u63a5\u53e3[" + transCode + "]\u67e5\u8be2\u62a5\u6587: \n" + request);
                    String response = SocletUtils.sendRequest(request, task.getBankLoginId());
                    EBContext.getContext().setType("response");
                    logger.info(transCode + "\u7684\u54cd\u5e94\u6570\u636e\uff1a" + response);
                    ReceiptInfo receiptInfo = ResponseParser.responseParser(response);
                    logger.info("\u56de\u5355\u6587\u4ef6\u63a5\u53e3[" + transCode + "]\u54cd\u5e94\u62a5\u6587: \n" + receiptInfo.getXmlStr());
                    if (EBGStringUtils.isEmpty((String)receiptInfo.getXmlStr())) {
                        throw new ReceiptException(receiptInfo.getReturnCode() + ":" + receiptInfo.getReturnMsg());
                    }
                    List<HistoryReceiptInfo> historyReceiptInfos = ResponseParser.responseXMLParser(receiptInfo.getXmlStr(), transCode);
                    if (historyReceiptInfos.size() > 0) {
                        for (HistoryReceiptInfo fileInfo : historyReceiptInfos) {
                            if (fileInfo.getFileName().contains("fzhhd")) continue;
                            EBContext.getContext().setType("request");
                            String downFileRequest = RequestPacker.receiptDownloadRequest(fileInfo.getFileName(), fileInfo.getRandomPwd());
                            logger.info("\u6587\u4ef6\u4e0b\u8f7d\u63a5\u53e3[FILE03]\u67e5\u8be2\u62a5\u6587: \n" + downFileRequest);
                            String downFileResponse = SocletUtils.sendRequest(downFileRequest, task.getBankLoginId());
                            EBContext.getContext().setType("response");
                            logger.info("FILE03\u7684\u54cd\u5e94\u6570\u636e\uff1a" + downFileResponse);
                            ReceiptInfo downloadInfo = ResponseParser.responseParser(downFileResponse);
                            logger.info("\u6587\u4ef6\u4e0b\u8f7d\u63a5\u53e3[FILE03]\u54cd\u5e94\u7ed3\u679c: \n" + downloadInfo.getReturnCode() + " " + downloadInfo.getReturnMsg());
                            if (!"000000".equals(downloadInfo.getReturnCode())) continue;
                            DownloadListDetail detail = new DownloadListDetail();
                            detail.setFileName(fileInfo.getFileName());
                            detail.setTransDate(task.getTransDate());
                            detailList.add(detail);
                        }
                        break block13;
                    }
                    throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-pab-dc", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u5217\u8868\u5931\u8d25:%s\u3002", (String)"BankReceiptFetchListImpl_6", (String)"ebg-receipt-banks-pab-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                }
            }
        }
        if (detailList.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-pab-dc", (Object[])new Object[0]));
        }
        EBContext.getContext().setType("");
        return BankReceiptHandleResponseEB.success(detailList);
    }

    public List<DownloadListDetail> queryReceiptByELC009(BankReceiptHandleRequest handleRequest, Map<String, DownloadListDetail> existMap) throws Exception {
        boolean elc009HastNext;
        boolean hastNext;
        ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>(16);
        String accNo = handleRequest.getAccNo();
        String transDateStr = handleRequest.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        int page = 1;
        ArrayList<DetailInfo> detailInfoResult = new ArrayList<DetailInfo>(1);
        do {
            int sleepCount = 0;
            try {
                String detailRequest = RequestPacker.detailRequest("4013", accNo, transDateStr, page);
                logger.info("\u5e73\u5b89\u94f6\u884c[4013\u63a5\u53e3]\u56de\u5355\u67e5\u8be2\u8bf7\u6c42: \n" + detailRequest);
                String detailResponse = this.doQuest4013(detailRequest, handleRequest.getBankLoginId(), sleepCount);
                if (EBGStringUtils.isNotEmpty((String)detailResponse)) {
                    logger.info("\u5e73\u5b89\u94f6\u884c[4013\u63a5\u53e3]\u56de\u5355\u67e5\u8be2\u9519\u8bef\u54cd\u5e94: \n" + detailResponse);
                    ReceiptInfo receiptInfo = ResponseParser.responseParser(detailResponse);
                    hastNext = ResponseParser.detailParser(detailInfoResult, receiptInfo.getXmlStr(), false);
                    ++page;
                    continue;
                }
                hastNext = false;
            }
            catch (Throwable e) {
                hastNext = false;
            }
        } while (hastNext);
        logger.info("\u5e73\u5b89\u94f6\u884c[4013\u63a5\u53e3]\u4ea4\u6613\u660e\u7ec6\u6761\u6570:" + detailInfoResult.size());
        int elc009Page = 1;
        ArrayList<DetailInfo> elc009Result = new ArrayList<DetailInfo>(1);
        do {
            String eLC009Request = RequestPacker.eLC009ReceiptRequest("ELC009", accNo, transDateStr, elc009Page);
            logger.info("\u5e73\u5b89\u94f6\u884c[ELC009\u63a5\u53e3]\u56de\u5355\u67e5\u8be2\u8bf7\u6c42: \n" + eLC009Request);
            int sleepCount = 0;
            try {
                String eLC009Response = this.doQuestELC009(eLC009Request, handleRequest.getBankLoginId(), sleepCount);
                if (EBGStringUtils.isNotEmpty((String)eLC009Response)) {
                    logger.info("\u5e73\u5b89\u94f6\u884c[elc009\u63a5\u53e3]\u56de\u5355\u67e5\u8be2\u9519\u8bef\u54cd\u5e94: \n" + eLC009Response);
                    ReceiptInfo receiptInfo = ResponseParser.responseParser(eLC009Response);
                    elc009HastNext = ResponseParser.elc009Parser(elc009Result, receiptInfo.getXmlStr());
                    logger.info("elc009Result size : " + elc009Result.size());
                    ++elc009Page;
                    continue;
                }
                elc009HastNext = false;
            }
            catch (Throwable e) {
                logger.monitorError("ELC009-ERROR:" + e.getMessage(), e);
                elc009HastNext = false;
            }
        } while (elc009HastNext);
        logger.info("\u5e73\u5b89\u94f6\u884c[ELC009\u63a5\u53e3]\u4ea4\u6613\u660e\u7ec6\u6761\u6570:" + elc009Result.size());
        if (elc009Result.size() > detailInfoResult.size()) {
            this.doELCReceiptDownload(false, detailInfoResult, elc009Result, accNo, transDateStr, existMap, detailList, handleRequest, true);
        } else {
            this.doELCReceiptDownload(true, elc009Result, detailInfoResult, accNo, transDateStr, existMap, detailList, handleRequest, false);
        }
        EBContext.getContext().setType("");
        return detailList;
    }

    public void doELCReceiptDownload(boolean firstIsReceipt, List<DetailInfo> firstList, List<DetailInfo> twoList, String accNo, String transDateStr, Map<String, DownloadListDetail> existMap, List<DownloadListDetail> detailList, BankReceiptHandleRequest handleRequest, boolean isBreak) throws Exception {
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        block2: for (DetailInfo firstDetail : firstList) {
            for (DetailInfo twoDetail : twoList) {
                DetailInfo info;
                DetailInfo elc009;
                if (firstIsReceipt) {
                    elc009 = firstDetail;
                    info = twoDetail;
                } else {
                    elc009 = twoDetail;
                    info = firstDetail;
                }
                if (!info.getHostTrace().equals(elc009.getHostTrace()) || !info.getDcFlag().equals(elc009.getDcFlag())) continue;
                try {
                    elc009.setAbstractStr(info.getAbstractStr());
                    String newFileName = accNo + "_" + transDateStr + "_" + elc009.getHostTrace() + "_" + elc009.getDcFlag() + "_" + elc009.getAbstractStr() + ".pdf";
                    if (countMap.containsKey(newFileName)) {
                        int count = (Integer)countMap.get(newFileName) + 1;
                        countMap.put(newFileName, count);
                        newFileName = accNo + "_" + transDateStr + "_" + elc009.getHostTrace() + "_" + elc009.getDcFlag() + "_" + elc009.getAbstractStr() + "_" + String.format("%04d", count) + ".pdf";
                    } else {
                        countMap.put(newFileName, 0);
                    }
                    if (existMap.containsKey(newFileName)) {
                        DownloadListDetail detail = existMap.get(newFileName);
                        detailList.add(detail);
                        if (!isBreak) continue;
                        continue block2;
                    }
                    String elc010Request = RequestPacker.eLC010ReceiptRequest("ELC010", accNo, transDateStr, elc009.getSeqNo(), elc009.getReceiptType());
                    int sleepCount = 0;
                    logger.info("\u5e73\u5b89\u94f6\u884c[ELC010\u63a5\u53e3]\u56de\u5355\u67e5\u8be2\u8bf7\u6c42: \n" + elc010Request);
                    String elc010Response = this.doQuestELC010(elc010Request, handleRequest.getBankLoginId(), sleepCount);
                    logger.info("\u5e73\u5b89\u94f6\u884c[elc010\u63a5\u53e3]\u54cd\u5e94: \n" + elc010Response);
                    ReceiptInfo receiptInfo = ResponseParser.responseParser(elc010Response);
                    HistoryReceiptInfo fileInfo = ResponseParser.elc010Parser(receiptInfo.getXmlStr());
                    EBContext.getContext().setType("request");
                    String downFileRequest = RequestPacker.receiptDownloadRequest(fileInfo.getFileName(), fileInfo.getRandomPwd());
                    logger.info("\u6587\u4ef6\u4e0b\u8f7d\u63a5\u53e3[FILE03]\u67e5\u8be2\u62a5\u6587: \n" + downFileRequest);
                    sleepCount = 0;
                    String downFileResponse = this.doQuestFile03(downFileRequest, handleRequest.getBankLoginId(), sleepCount);
                    EBContext.getContext().setType("response");
                    logger.info("FILE03\u7684\u54cd\u5e94\u6570\u636e\uff1a" + downFileResponse);
                    ReceiptInfo downloadInfo = ResponseParser.responseParser(downFileResponse);
                    if ("000000".equals(downloadInfo.getReturnCode())) {
                        DownloadListDetail detail = new DownloadListDetail();
                        detail.setFileName(newFileName);
                        detail.setFileLink(fileInfo.getFileName());
                        detailList.add(detail);
                    }
                }
                catch (Throwable e) {
                    logger.monitorError("ELC010-ERROR:" + e.getMessage(), e);
                }
                if (!isBreak) continue;
                continue block2;
            }
        }
        EBContext.getContext().setType("");
    }

    public String doQuest4013(String requestStr, String bankLoginId, int sleepCount) throws Exception {
        String detailRequest = requestStr;
        String detailResponse = SocletUtils.sendRequest(detailRequest, bankLoginId);
        if (EBGStringUtils.isNotEmpty((String)detailResponse) && ErrorCodeEnum.isContainRetryMsgByContent(detailResponse)) {
            if (sleepCount == 2) {
                logger.info("\u5e73\u5b89\u94f6\u884c[4013\u63a5\u53e3]\u67e5\u8be2\u54cd\u5e94: \n" + detailResponse);
                return null;
            }
            Thread.sleep((long)(sleepCount + 1) * 1000L);
            return this.doQuest4013(requestStr, bankLoginId, sleepCount + 1);
        }
        return detailResponse;
    }

    public String doQuestELC009(String requestStr, String bankLoginId, int sleepCount) throws Exception {
        String eLC009Request = requestStr;
        String eLC009Response = SocletUtils.sendRequest(eLC009Request, bankLoginId);
        if (EBGStringUtils.isNotEmpty((String)eLC009Response) && ErrorCodeEnum.isContainRetryMsgByContent(eLC009Response)) {
            if (sleepCount == 2) {
                logger.info("\u5e73\u5b89\u94f6\u884c[elc009\u63a5\u53e3]\u56de\u5355\u67e5\u8be2\u54cd\u5e94: \n" + eLC009Response);
                return null;
            }
            Thread.sleep((long)(sleepCount + 1) * 1000L);
            return this.doQuestELC009(eLC009Request, bankLoginId, sleepCount + 1);
        }
        return eLC009Response;
    }

    public String doQuestELC010(String requestStr, String bankLoginId, int sleepCount) throws Exception {
        String elc010Request = requestStr;
        String elc010Response = SocletUtils.sendRequest(elc010Request, bankLoginId);
        if (EBGStringUtils.isNotEmpty((String)elc010Response) && ErrorCodeEnum.isContainRetryMsgByContent(elc010Response)) {
            if (sleepCount == 2) {
                logger.info("\u5e73\u5b89\u94f6\u884c[elc010\u63a5\u53e3]\u56de\u5355\u67e5\u8be2\u54cd\u5e94: \n" + elc010Response);
                return null;
            }
            Thread.sleep((long)(sleepCount + 1) * 1000L);
            return this.doQuestELC010(elc010Request, bankLoginId, sleepCount + 1);
        }
        return elc010Response;
    }

    public String doQuestFile03(String requestStr, String bankLoginId, int sleepCount) throws Exception {
        String downFileRequest = requestStr;
        logger.info("\u6587\u4ef6\u4e0b\u8f7d\u63a5\u53e3[FILE03]\u67e5\u8be2\u62a5\u6587: \n" + downFileRequest);
        String downFileResponse = SocletUtils.sendRequest(downFileRequest, bankLoginId);
        if (EBGStringUtils.isNotEmpty((String)downFileResponse) && ErrorCodeEnum.isContainRetryMsgByContent(downFileResponse)) {
            if (sleepCount == 2) {
                return null;
            }
            Thread.sleep((long)(sleepCount + 1) * 1000L);
            return this.doQuestFile03(requestStr, bankLoginId, sleepCount + 1);
        }
        return downFileResponse;
    }

    public List<DownloadListDetail> doJob_today(DownloadListTask task, String transDate, String accNo, Map<String, DownloadListDetail> existMap) {
        int page = 1;
        ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>(16);
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(1);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        try {
            boolean hastNext;
            Thread.sleep(10000L);
            do {
                String detailRequest = RequestPacker.detailRequest("4013", accNo, transDate, page);
                logger.info("\u5e73\u5b89\u94f6\u884c[4013\u63a5\u53e3]\u56de\u5355\u67e5\u8be2\u8bf7\u6c42: \n" + (String)detailRequest);
                String detailResponse = SocletUtils.sendRequest(detailRequest, task.getBankLoginId());
                logger.info("\u5e73\u5b89\u94f6\u884c[4013\u63a5\u53e3]\u56de\u5355\u67e5\u8be2\u54cd\u5e94: \n" + detailResponse);
                ReceiptInfo receiptInfo = ResponseParser.responseParser(detailResponse);
                hastNext = ResponseParser.detailParser(result, receiptInfo.getXmlStr(), true);
                ++page;
            } while (hastNext);
            for (DetailInfo info : result) {
                String newFileName = accNo + "_" + transDate + "_" + info.getHostTrace() + "_" + info.getDcFlag() + "_" + info.getAbstractStr() + ".pdf";
                if (countMap.containsKey(newFileName)) {
                    int count = (Integer)countMap.get(newFileName) + 1;
                    countMap.put(newFileName, count);
                    newFileName = accNo + "_" + transDate + "_" + info.getHostTrace() + "_" + info.getDcFlag() + "_" + info.getAbstractStr() + "_" + String.format("%04d", count) + ".pdf";
                } else {
                    countMap.put(newFileName, 0);
                }
                if (existMap.containsKey(newFileName)) {
                    DownloadListDetail detail = existMap.get(newFileName);
                    detailList.add(detail);
                    continue;
                }
                try {
                    String todayReceiptRequest = RequestPacker.todayReceiptRequest("ELC008", accNo, info);
                    logger.info("\u5e73\u5b89\u94f6\u884c \u5f53\u65e5PDF\u56de\u5355\u6587\u4ef6\u67e5\u8be2\u63a5\u53e3[ELC008] \u67e5\u8be2\u8bf7\u6c42: \n" + todayReceiptRequest);
                    String todayReceiptResponse = SocletUtils.sendRequest(todayReceiptRequest, task.getBankLoginId());
                    logger.info("\u5e73\u5b89\u94f6\u884c \u5f53\u65e5PDF\u56de\u5355\u6587\u4ef6\u67e5\u8be2\u63a5\u53e3[ELC008] \u67e5\u8be2\u54cd\u5e94: \n" + todayReceiptResponse);
                    ReceiptInfo receiptInfo = ResponseParser.responseParser(todayReceiptResponse);
                    TodayReceiptInfo todayReceiptInfo = ResponseParser.todayReceiptParser(receiptInfo.getXmlStr());
                    String downFileRequest = RequestPacker.receiptDownloadRequest(todayReceiptInfo.getFileName(), todayReceiptInfo.getRandomPwd());
                    logger.info("\u5e73\u5b89\u94f6\u884c[FILE03\u63a5\u53e3]\u56de\u5355\u4e0b\u8f7d\u8bf7\u6c42: \n" + downFileRequest);
                    String downFileResponse = SocletUtils.sendRequest(downFileRequest, task.getBankLoginId());
                    logger.info("\u5e73\u5b89\u94f6\u884c[FILE03\u63a5\u53e3]\u56de\u5355\u4e0b\u8f7d\u54cd\u5e94\uff1a" + downFileResponse);
                    ReceiptInfo downloadInfo = ResponseParser.responseParser(downFileResponse);
                    if (!"000000".equals(downloadInfo.getReturnCode())) {
                        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u5e73\u5b89\u94f6\u884c[FILE03\u63a5\u53e3]\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\u6587\u4ef6[%1$s]\u5931\u8d25\u3002\u54cd\u5e94\u7801%2$s\uff0c\u8fd4\u56de\u63cf\u8ff0%3$s\u3002", (String)"BankReceiptFetchListImpl_7", (String)"ebg-receipt-banks-pab-dc", (Object[])new Object[0]), todayReceiptInfo.getFileName(), downloadInfo.getReturnCode(), downloadInfo.getReturnMsg()));
                    }
                    logger.info("\u5e73\u5b89\u94f6\u884c[FILE03\u63a5\u53e3]\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\u6587\u4ef6[" + todayReceiptInfo.getFileName() + "]\u6210\u529f");
                    if ("000000".equals(downloadInfo.getReturnCode())) {
                        DownloadListDetail detail = new DownloadListDetail();
                        detail.setFileLink(todayReceiptInfo.getFileName());
                        detail.setFileName(newFileName);
                        detail.setTransDate(task.getTransDate());
                        detailList.add(detail);
                    }
                    Thread.sleep(1000L);
                }
                catch (Throwable e) {
                    logger.monitorError("ELC008-ERROR:" + e.getMessage(), e);
                }
            }
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        return detailList;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "PAB_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u5e73\u5b89\u94f6\u884c\u76f4\u8fde\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_5", (String)"ebg-receipt-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return !FileCommonUtils.isTestEnv();
    }
}

