/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gsnx.dc.service.receipt.utils;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.LocalTime;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.receipt.banks.gsnx.dc.service.receipt.utils.CommonUtils;
import kd.ebg.receipt.banks.gsnx.dc.service.receipt.utils.SMUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.apache.commons.codec.binary.Base64;

public class CommonPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CommonPacker.class);

    public static String createRootMsg(JSONObject body, String transCode) {
        JSONObject root = new JSONObject();
        root.put("sys_header", (Object)CommonPacker.createHeader(transCode, Sequence.gen16Sequence()));
        root.put("body", (Object)body);
        return CommonPacker.getSendMsg(root.toJSONString());
    }

    public static JSONObject createHeader(String transCode, String seqNo) {
        JSONObject header = new JSONObject();
        header.put("std_intf_ind", (Object)transCode);
        header.put("chnl_code", (Object)RequestContextUtils.getBankParameterValue((String)"channelNo"));
        header.put("cnsmr_txn_dt", (Object)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        header.put("cnsmr_txn_tm", (Object)LocalDateUtil.formatLocalTime((LocalTime)LocalTime.now()));
        header.put("cnsmr_rung_num", (Object)seqNo);
        header.put("busi_no", (Object)RequestContextUtils.getBankParameterValue((String)"businessNo"));
        return header;
    }

    public static String getSendMsg(String jsonStr) {
        String signPrivateKey = CommonUtils.getKeyValue("signPrivateKey");
        String encodePublicKey = CommonUtils.getKeyValue("encodePublicKey");
        SMUtil smUtil = new SMUtil();
        logger.info("\u62a5\u6587\u8bf7\u6c42\u52a0\u5bc6\u524d:{}", (Object)jsonStr);
        byte[] signBytes = smUtil.sm2Sign(signPrivateKey, jsonStr);
        String base64Sign = Base64.encodeBase64String((byte[])signBytes);
        byte[] enyptByte = smUtil.sm2Encrypt(encodePublicKey, jsonStr);
        String sm4base64str = Base64.encodeBase64String((byte[])enyptByte);
        JSONObject req = new JSONObject();
        req.put("sign", (Object)base64Sign);
        req.put("data", (Object)sm4base64str);
        req.put("busi_no", (Object)RequestContextUtils.getBankParameterValue((String)"businessNo"));
        String reqFmt = req.toString();
        return reqFmt;
    }
}

