/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gsnx.dc.service.receipt.utils;

import kd.ebg.receipt.banks.gsnx.dc.service.receipt.utils.BitFile;
import kd.ebg.receipt.banks.gsnx.dc.service.receipt.utils.DictElem;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class Lzw {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(Lzw.class);
    protected int current_code_bits;
    protected byte[] decode_stack;
    protected int next_code;
    protected int next_bump_code;
    protected DictElem[][] dict;
    protected BitFile bitFile;
    protected int m_type;

    public Lzw(int type, String src) {
        this.m_type = type;
        this.bitFile = new BitFile(src);
        this.decode_stack = new byte[35023];
        this.dict = new DictElem[137][256];
        for (int i = 0; i < 137; ++i) {
            for (int j = 0; j < 256; ++j) {
                this.dict[i][j] = new DictElem();
            }
        }
        this.initDict();
    }

    int decode_string(int count, int code) {
        while (code > 255) {
            this.decode_stack[count++] = this.dict[code >> 8][code & 0xFF].getByte();
            code = this.dict[code >> 8][code & 0xFF].getParentCode();
        }
        this.decode_stack[count++] = (byte)code;
        return count;
    }

    public String expand() {
        if (this.m_type == 1) {
            return "";
        }
        try {
            block2: while (true) {
                this.initDict();
                int old_code = this.inputBits(this.current_code_bits);
                if (old_code == 256) {
                    return this.bitFile.toString();
                }
                int character = old_code;
                this.bitFile.putc((byte)old_code);
                while (true) {
                    int count;
                    int new_code;
                    if ((new_code = this.inputBits(this.current_code_bits)) == 256) {
                        return this.bitFile.toString();
                    }
                    if (new_code == 258) continue block2;
                    if (new_code == 257) {
                        ++this.current_code_bits;
                        continue;
                    }
                    if (new_code >= this.next_code) {
                        this.decode_stack[0] = (byte)character;
                        count = this.decode_string(1, old_code);
                    } else {
                        count = this.decode_string(0, new_code);
                    }
                    character = this.decode_stack[count - 1] & 0xFF;
                    while (count > 0) {
                        this.bitFile.putc(this.decode_stack[--count]);
                    }
                    this.dict[this.next_code >> 8][this.next_code & 0xFF].setParentCode(old_code);
                    this.dict[this.next_code >> 8][this.next_code & 0xFF].setByte((byte)character);
                    ++this.next_code;
                    old_code = new_code;
                }
                break;
            }
        }
        catch (Throwable var6) {
            logger.error("expand:error:" + var6.getMessage(), var6);
            return "";
        }
    }

    private void initDict() {
        for (int i = 0; i < 35023; ++i) {
            this.dict[i >> 8][i & 0xFF].setCode(-1);
        }
        this.current_code_bits = 9;
        this.next_code = 259;
        this.next_bump_code = 511;
    }

    private int inputBits(int bit_count) throws Exception {
        int returnValue = 0;
        for (int mask = 1 << bit_count - 1; mask != 0; mask >>= 1) {
            if (this.bitFile.getMask() == -128) {
                this.bitFile.setRack(this.bitFile.getc());
                if (this.bitFile.getRack() == -1) {
                    throw new Exception("error input");
                }
            }
            if ((this.bitFile.getRack() & this.bitFile.getMask()) != 0) {
                returnValue |= mask;
            }
            this.bitFile.setMask((byte)(this.bitFile.getMask() >> 1 & 0x7F));
            if (this.bitFile.getMask() != 0) continue;
            this.bitFile.setMask((byte)-128);
        }
        return returnValue;
    }
}

